/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Hashtable;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;

public class TrackProbePerformance {
    protected static Hashtable cTrackedProbes = new Hashtable();
    protected static boolean sPerfTraceEnabled = false;

    public static void startProbe(String string) {
        if (string != null && TrackProbePerformance.checkPerfTraceEnabledConfiguration()) {
            ProbePerfTracker probePerfTracker = new ProbePerfTracker(string);
            cTrackedProbes.put(string, probePerfTracker);
        }
    }

    public static ProbePerfTracker.ProbeAction startProbeAction(String string, int n) {
        ProbePerfTracker probePerfTracker;
        if (sPerfTraceEnabled && string != null && (probePerfTracker = (ProbePerfTracker)cTrackedProbes.get(string)) != null) {
            return probePerfTracker.startAction(n);
        }
        return null;
    }

    public static void finishedProbeAction(String string, int n) {
        ProbePerfTracker probePerfTracker;
        if (sPerfTraceEnabled && string != null && (probePerfTracker = (ProbePerfTracker)cTrackedProbes.get(string)) != null) {
            probePerfTracker.finishedAction(n);
        }
    }

    public static void finishedProbeAction(ProbePerfTracker.ProbeAction probeAction) {
        if (sPerfTraceEnabled && probeAction != null) {
            probeAction.finished();
        }
    }

    public static void finishedProbe(String string, LogTraceHelper logTraceHelper) {
        ProbePerfTracker probePerfTracker;
        if (sPerfTraceEnabled && string != null && (probePerfTracker = (ProbePerfTracker)cTrackedProbes.get(string)) != null) {
            probePerfTracker.probeFinished(logTraceHelper);
            cTrackedProbes.remove(string);
        }
    }

    private static boolean checkPerfTraceEnabledConfiguration() {
        boolean bl;
        sPerfTraceEnabled = bl = DiskManagerConfigSvc.getBooleanConfigValue((String)"Probe.TrackProbePerformance", (boolean)false);
        return bl;
    }
}

