/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.cimom;

import java.net.InetAddress;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.aperi.discovery.Configuration;
import org.eclipse.aperi.discovery.Response;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.slp.Locator;
import org.sblim.slp.ServiceLocationEnumeration;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.ServiceLocationManager;
import org.sblim.slp.ServiceType;
import org.sblim.slp.ServiceURL;

public class SLPScanner
extends Thread {
    public static String queueName;
    public static String discoverAll;
    private boolean shutdown = false;
    private Thread thread = null;
    public static final String MESSAGE_NAME = "aperi.logger.message.SLPScanner";
    public static final String TRACE_NAME = "aperi.logger.trace.SLPScanner";
    public static String MSG_FILE;
    public static final String SERVICE_WBEM_HTTPS = "service:wbem:https";
    public static final String SERVICE_WBEM_HTTP = "service:wbem:http";
    private static String className;
    public static ILogger msgLogger;
    public static ILogger traceLogger;

    static {
        Class<?> clazz;
        queueName = "SLP";
        discoverAll = "DiscoverAll";
        MSG_FILE = "org.eclipse.aperi.discovery.parser.resources.MsgLoggingTMS";
        try {
            clazz = Class.forName("org.eclipse.aperi.discovery.cimom.SLPScanner");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        className = clazz.getName();
        msgLogger = null;
        traceLogger = null;
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }

    public SLPScanner() {
        this.setName(String.valueOf(queueName) + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getCIMOMServices(Locator locator, Vector vector, boolean bl, Vector vector2) throws ServiceLocationException {
        ServiceType serviceType;
        String string;
        String string2 = "getCIMOMServices";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string2);
        }
        Vector<Object> vector3 = new Vector<Object>();
        if (locator == null) {
            return vector3;
        }
        ServiceLocationEnumeration serviceLocationEnumeration = null;
        if (bl) {
            if (traceLogger.isLogging()) {
                string = String.valueOf(queueName) + ":Multicast discovery in progress";
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, string);
            }
            serviceType = new ServiceType(SERVICE_WBEM_HTTPS);
            string = System.getProperty("net.slp.DAAddresses");
            try {
                ServiceURL serviceURL;
                System.setProperty("net.slp.DAAddresses", "");
                serviceLocationEnumeration = locator.findServices(serviceType, vector, "");
                while (true) {
                    if (!serviceLocationEnumeration.hasMoreElements()) {
                        serviceType = new ServiceType(SERVICE_WBEM_HTTP);
                        serviceLocationEnumeration = locator.findServices(serviceType, vector, "");
                        break;
                    }
                    serviceURL = (ServiceURL)serviceLocationEnumeration.nextElement();
                    vector3.add(serviceURL);
                }
                while (serviceLocationEnumeration.hasMoreElements()) {
                    serviceURL = (ServiceURL)serviceLocationEnumeration.nextElement();
                    vector3.add(serviceURL);
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                try {
                    System.setProperty("net.slp.DAAddresses", string);
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            {
                Object var11_13 = null;
            }
            try {}
            catch (Exception exception) {}
            System.setProperty("net.slp.DAAddresses", string);
        }
        if (vector2 != null && vector2.size() > 0) {
            if (traceLogger.isLogging()) {
                string = String.valueOf(queueName) + ":DA discovery in progress";
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, string);
            }
            serviceType = new ServiceType(SERVICE_WBEM_HTTPS);
            serviceLocationEnumeration = locator.findServices(serviceType, vector, "", vector2);
            while (true) {
                if (!serviceLocationEnumeration.hasMoreElements()) {
                    serviceType = new ServiceType(SERVICE_WBEM_HTTP);
                    serviceLocationEnumeration = locator.findServices(serviceType, vector, "", vector2);
                    break;
                }
                string = (ServiceURL)serviceLocationEnumeration.nextElement();
                vector3.add(string);
            }
            while (serviceLocationEnumeration.hasMoreElements()) {
                string = (ServiceURL)serviceLocationEnumeration.nextElement();
                vector3.add(string);
            }
        }
        if (!traceLogger.isLogging()) return vector3;
        traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string2);
        return vector3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector findAttributes(Locator locator, ServiceURL serviceURL, Vector vector, Vector vector2, boolean bl, Vector vector3) throws ServiceLocationException {
        String string = "findAttributes";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, string);
        }
        Vector vector4 = new Vector();
        ServiceLocationEnumeration serviceLocationEnumeration = null;
        if (bl) {
            String string2 = System.getProperty("net.slp.DAAddresses");
            try {
                System.setProperty("net.slp.DAAddresses", "");
                serviceLocationEnumeration = locator.findAttributes(serviceURL, vector, vector2);
                while (serviceLocationEnumeration.hasMoreElements()) {
                    vector4.add(serviceLocationEnumeration.nextElement());
                }
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                System.setProperty("net.slp.DAAddresses", string2);
                throw throwable;
            }
            {
                Object var11_13 = null;
            }
            System.setProperty("net.slp.DAAddresses", string2);
        }
        if (vector3 != null && vector3.size() > 0) {
            serviceLocationEnumeration = locator.findAttributes(serviceURL, vector, vector2, vector3);
            while (serviceLocationEnumeration.hasMoreElements()) {
                vector4.add(serviceLocationEnumeration.nextElement());
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, string);
        }
        return vector4;
    }

    public void run() {
        String string;
        Locator locator;
        String string2;
        block45: {
            string2 = "run";
            this.thread = Thread.currentThread();
            locator = null;
            try {
                locator = ServiceLocationManager.getLocator((Locale)Locale.getDefault());
            }
            catch (ServiceLocationException serviceLocationException) {
                string = String.valueOf(queueName) + ":Error - Failed to start service - no locale object found for the SLP client";
                if (Configuration.debug) {
                    System.out.println(string);
                }
                if (!traceLogger.isLogging()) break block45;
                traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string2, string);
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)serviceLocationException);
            }
        }
        while (!this.shutdown) {
            Object object;
            if (Configuration.debug) {
                System.out.println(String.valueOf(queueName) + ": waiting for a job");
            }
            if (traceLogger.isLogging()) {
                object = String.valueOf(queueName) + ": waiting for a job";
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, (String)object);
            }
            object = QueueController.getInstance().getNextJob(queueName);
            if (this.shutdown) {
                string = String.valueOf(queueName) + ":Shutting down SLPScanner";
                if (!traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, string);
                continue;
            }
            if (object == null) {
                string = String.valueOf(queueName) + ":Error - got a NULL job from the queue";
                if (!traceLogger.isLogging()) continue;
                traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string2, string);
                continue;
            }
            try {
                Object object2;
                boolean bl;
                Object object3;
                Object object4;
                Object object5;
                if (Configuration.debug) {
                    System.out.println(String.valueOf(queueName) + ": performing SLP scan");
                }
                if (traceLogger.isLogging()) {
                    string = String.valueOf(queueName) + ": performing SLP scan";
                    traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, string);
                }
                if ((string = object.getRequest()) == null) {
                    object5 = String.valueOf(queueName) + ":Error got a NULL scope parameter";
                    if (Configuration.debug) {
                        System.out.println((String)object5);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string2, (String)object5);
                    continue;
                }
                object5 = (Vector)string.getData();
                if (object5 == null || ((Vector)object5).size() != 2) {
                    object4 = null;
                    object4 = object5 == null && Configuration.debug ? String.valueOf(queueName) + ":Error got a NULL parameter for the SLP scanner" : String.valueOf(queueName) + ":Error got invalid number of parameters. Total parameters:" + ((Vector)object5).size() + ", it should be 2";
                    if (Configuration.debug) {
                        System.out.println((String)object4);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string2, (String)object4);
                    continue;
                }
                object4 = null;
                String[] stringArray = null;
                if (!(((Vector)object5).elementAt(0) instanceof String[])) {
                    object3 = String.valueOf(queueName) + ":Error got an invalid parameter for 'scope'. A String[] must be used.";
                    if (Configuration.debug) {
                        System.out.println((String)object3);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string2, (String)object3);
                    continue;
                }
                if (!(((Vector)object5).elementAt(1) instanceof String[])) {
                    object3 = String.valueOf(queueName) + ":Error got an invalid parameter for 'DA'. A String[] must be used.";
                    if (Configuration.debug) {
                        System.out.println((String)object3);
                    }
                    if (!traceLogger.isLogging()) continue;
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string2, (String)object3);
                    continue;
                }
                object4 = (String[])((Vector)object5).elementAt(0);
                stringArray = (String[])((Vector)object5).elementAt(1);
                object3 = new Vector();
                if (object4 == null || ((String[])object4).length == 0) {
                    if (traceLogger.isLogging()) {
                        String string3 = String.valueOf(queueName) + ":Using'default' scope...";
                        traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, string3);
                    }
                    ((Vector)object3).add("default");
                } else {
                    bl = false;
                    while (bl < ((String[])object4).length) {
                        if (object4[bl] != null) {
                            ((Vector)object3).add(object4[bl]);
                        }
                        bl += 1;
                    }
                }
                bl = false;
                Vector vector = new Vector();
                int n = 0;
                while (n < stringArray.length) {
                    block46: {
                        if (stringArray[n] == null || "local".equals(stringArray[n])) {
                            bl = true;
                        } else {
                            try {
                                object2 = InetAddress.getByName(stringArray[n]);
                                vector.add(object2);
                            }
                            catch (Exception exception) {
                                object2 = String.valueOf(queueName) + ":Can not resolve address:" + stringArray[n];
                                if (Configuration.debug) {
                                    System.out.println((String)object2);
                                }
                                if (!traceLogger.isLogging()) break block46;
                                traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, string2, (String)object2);
                            }
                        }
                    }
                    ++n;
                }
                if (vector.size() == 0) {
                    bl = true;
                }
                try {
                    Object object6;
                    Vector vector2 = this.getCIMOMServices(locator, (Vector)object3, bl, vector);
                    object2 = new Vector();
                    Iterator iterator = vector2.iterator();
                    while (iterator.hasNext()) {
                        object6 = (ServiceURL)iterator.next();
                        Vector vector3 = this.findAttributes(locator, (ServiceURL)object6, (Vector)object3, new Vector(), bl, vector);
                        if (Configuration.debug) {
                            System.out.println(object6);
                            if (traceLogger.isLogging()) {
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, object6.toString());
                            }
                            Iterator iterator2 = vector3.iterator();
                            while (iterator2.hasNext()) {
                                Object e = iterator2.next();
                                System.out.println(e);
                                if (!traceLogger.isLogging()) continue;
                                traceLogger.text(IRecordType.TYPE_INFO, (Object)className, string2, e.toString());
                            }
                        }
                        ((Vector)object2).add(vector3);
                    }
                    object6 = new ObjectResponse(object2, (JobInfo)object);
                    object.setResponse((Response)object6);
                    object.setReturnCode(0);
                    object.queryComplete(true);
                }
                catch (ServiceLocationException serviceLocationException) {
                    short s = serviceLocationException.getErrorCode();
                    object.setReturnCode((int)s);
                    if (Configuration.debug) {
                        serviceLocationException.printStackTrace();
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)serviceLocationException);
                    }
                    object.complete(false);
                }
                catch (Exception exception) {
                    if (Configuration.debug) {
                        exception.printStackTrace();
                    }
                    if (traceLogger.isLogging()) {
                        traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, (Throwable)exception);
                    }
                    object.setReturnCode(10);
                    object.complete(false);
                }
            }
            catch (Throwable throwable) {
                if (Configuration.debug) {
                    throwable.printStackTrace();
                }
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string2, throwable);
                }
                object.setReturnCode(10);
                object.complete(false);
            }
            if (!Configuration.debug) continue;
            System.out.println(String.valueOf(queueName) + ": finishing job");
        }
    }

    public void shutdown() {
        block4: {
            String string = "shutdown";
            this.shutdown = true;
            if (this.thread != null) {
                try {
                    this.thread.interrupt();
                    this.thread.join(30000L);
                    this.thread = null;
                }
                catch (Exception exception) {
                    if (Configuration.debug) {
                        exception.printStackTrace();
                    }
                    if (!traceLogger.isLogging()) break block4;
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, string, (Throwable)exception);
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        new SLPScanner();
        System.out.println("");
    }
}

