/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.api.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.LogFilePos;
import org.eclipse.aperi.common.ReadLogResponse;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.CimomAndDeviceStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.IJobMgmtService;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.disk.api.HostType;
import org.eclipse.aperi.disk.api.IDiskCollectionService;
import org.eclipse.aperi.disk.api.IDiskConfigurationService;
import org.eclipse.aperi.disk.api.IDiskManagementService;
import org.eclipse.aperi.disk.api.IDiskReportingService;
import org.eclipse.aperi.disk.api.IDiskSVCConfigurationService;
import org.eclipse.aperi.disk.api.impl.DiskCollectionOperations;
import org.eclipse.aperi.disk.api.impl.DiskConfigurationOperations;
import org.eclipse.aperi.disk.api.impl.DiskManagementOperations;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.api.impl.DiskReportingOperations;
import org.eclipse.aperi.disk.collection.DiskCIMScanner;
import org.eclipse.aperi.disk.common.CIM.CIMClientPool;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.exceptions.EntityNotFoundException;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageSubsystemTable;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskManager
implements IDiskReportingService,
IDiskConfigurationService,
IDiskSVCConfigurationService,
IDiskCollectionService,
IDiskManagementService,
ICIMOMMgmtService,
IJobMgmtService {
    private static DiskManager stSingletongInstance = null;
    private ServiceHelper cServiceHelper = null;
    public Status cStatus = new Status(5, 6);
    private DiskCollectionOperations cCollOps = null;
    private DiskConfigurationOperations cConfOps = null;
    private DiskReportingOperations cRepOps = null;
    private DiskManagementOperations cMgmtOps = null;
    private DiskCIMScanner cDiskScanner = null;

    static {
        stSingletongInstance = new DiskManager();
    }

    private DiskManager() {
    }

    public static DiskManager getInstance() {
        return stSingletongInstance;
    }

    public AsyncResult createStorageVolumes(long[] lArray, String[] stringArray, String[] stringArray2, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.createStorageVolumes(lArray, stringArray, stringArray2, hashMap);
    }

    public AsyncResult deleteStorageVolumes(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.deleteStorageVolumes(stringArray);
    }

    public AsyncResult assignStorageVolumesToWWPNs(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, int n, String string, String[] stringArray5, String[] stringArray6, boolean bl) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.assignStorageVolumesToWWPNs(stringArray, stringArray2, stringArray3, stringArray4, n, string, stringArray5, stringArray6, bl);
    }

    public AsyncResult unassignStorageVolumesFromWWPNs(String[] stringArray, String[] stringArray2, int n, boolean bl) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.unassignStorageVolumesFromWWPNs(stringArray, stringArray2, n, bl);
    }

    public AsyncResult modifyStoragePoolSize(String string, String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.modifyStoragePoolSize(string, stringArray, stringArray2);
    }

    public AsyncResult modifyStorageVolumeSize(String string, long l) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.modifyStorageVolumeSize(string, l);
    }

    public AsyncResult unassignStorageVolumesFromWWPNs(String[] stringArray, String[] stringArray2, boolean bl) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.unassignStorageVolumesFromWWPNs(stringArray, stringArray2, bl);
    }

    public Result[] deleteStorageSubsystems(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.deleteStorageSubsystems(stringArray);
    }

    public Result removeStorageVolumesFromDB(int[] nArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.removeStorageVolumesFromDB(nArray);
    }

    public Result removePhysicalVolumesFromDB(int[] nArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.removePhysicalVolumesFromDB(nArray);
    }

    public Result removeStoragePoolsFromDB(int[] nArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.removeStoragePoolsFromDB(nArray);
    }

    public Result removePortsFromDB(int[] nArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cMgmtOps.removePortsFromDB(nArray);
    }

    public AsyncResult createSVCVDisks(long[] lArray, String[] stringArray, String[] stringArray2, boolean bl, int n, int n2, String[] stringArray3) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cConfOps.createSVCVDisks(lArray, stringArray, stringArray2, bl, n, n2, stringArray3);
    }

    public String[] getStorageSubsystems(HashMap hashMap) throws ServerException, InvalidParameterException {
        return this.cRepOps.getStorageSubsystems(hashMap);
    }

    public HashMap[] getStorageSubsystemAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageSubsystemAttributes(stringArray, stringArray2);
    }

    public String[] getPortsForSubsystem(String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getPortsForSubsystem(string, hashMap);
    }

    public HashMap[] getPortAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getPortAttributes(stringArray, stringArray2);
    }

    public String[] getStoragePoolsForSubsystem(String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStoragePoolsForSubsystem(string, hashMap);
    }

    public HashMap[] getStoragePoolAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStoragePoolAttributes(stringArray, stringArray2);
    }

    public String[] getStorageVolumesForPool(String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageVolumesForPool(string, hashMap);
    }

    public String[] getStorageVolumesForSubsystem(String string, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageVolumesForSubsystem(string, hashMap);
    }

    public HashMap[] getStorageVolumeAttributes(String[] stringArray, String[] stringArray2) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageVolumeAttributes(stringArray, stringArray2);
    }

    public HashMap[] getStorageVolumeAssignments(String[] stringArray, HashMap hashMap) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getStorageVolumeAssignments(stringArray, hashMap);
    }

    public HashMap getHostInfo(String string, HashMap hashMap, boolean bl) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getHostInfo(string, hashMap, bl);
    }

    public HostType[] getHostTypes(String string) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getHostTypes(string);
    }

    public long[] getSupportedVolumeSizeRange(String string, int n, int n2, int n3) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getSupportedVolumeSizeRange(string, n, n2, n3);
    }

    public long[] getDefaultSupportedVolumeSizeRange(String string) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cRepOps.getDefaultSupportedVolumeSizeRange(string);
    }

    public AsyncResult discoverStorageSubsystems(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cCollOps.discoverStorageSubsystems(stringArray);
    }

    public AsyncResult discoverDevicesFromCIMOM(String[] stringArray) throws ServerException, InvalidParameterException, MissingParameterException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.discoverDevicesFromCIMOM(stringArray);
    }

    public AsyncResult probeStorageSubsystems(String[] stringArray, Integer n) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cCollOps.probeStorageSubsystems(stringArray, (int)n);
    }

    public AsyncResult probeStorageSubsystems(String[] stringArray, int n) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cCollOps.probeStorageSubsystems(stringArray, n);
    }

    public AsyncResult probeStorageVolume(String string, String string2, int n) throws ServerException, InvalidParameterException, MissingParameterException {
        return this.cCollOps.probeStorageVolume(string, string2, n);
    }

    public Hashtable getRoleMap() {
        Hashtable hashtable = new Hashtable();
        DiskManager.addMethodAuthorization(hashtable, "collect", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "discoverStorageSubsystems", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "probeStorageSubsystems", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getCIMOMs", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "testCIMOMConnection", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "addCIMOMs", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "getCIMOMIDs", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "discoverCIMOMs", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "deleteCIMOMs", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "modifyCIMOMs", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "discoverDevicesFromCIMOM", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getStorageSubsystems", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getStorageSubsystemAttributes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getPortsForSubsystem", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getPortAttributes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getStoragePoolsForSubsystem", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getStoragePoolAttributes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getStorageVolumesForPool", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getStorageVolumesForSubsystem", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getStorageVolumeAttributes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getStorageVolumeAssignments", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getHostInfo", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getHostTypes", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getDefaultSupportedVolumeSizeRange", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getSupportedVolumeSizeRang", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "createStorageVolumes", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "deleteStorageVolumes", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "assignStorageVolumesToWWPNs", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "unassignStorageVolumesFromWWPNs", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "modifyStoragePoolSize", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "modifyStorageVolumeSize", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "createSVCVDisks", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "deleteStorageSubsystems", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "getJobStatus", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "waitForJobToComplete", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "cancelJob", RoleChecker.DISK_ADMIN);
        DiskManager.addMethodAuthorization(hashtable, "getLog", RoleChecker.DISK_VIEWER);
        DiskManager.addMethodAuthorization(hashtable, "getAPIVersion", RoleChecker.DISK_VIEWER);
        return hashtable;
    }

    private static void addMethodAuthorization(Map map, String string, int n) {
        if (map == null || string == null || n == 0) {
            throw new IllegalArgumentException();
        }
        map.put(string, new Integer(n));
    }

    public String getDescription() {
        return "Service providing disk management capabilities (disk configuration information, disk control, disk monitoring)";
    }

    public String getName() {
        return "DiskManagerService";
    }

    public String getVersion() {
        return "5.0.0";
    }

    public Status getStatus() {
        return this.cStatus;
    }

    public boolean shutdown() {
        boolean bl;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"shutdown", null);
        Boolean bl2 = null;
        try {
            if (this.cStatus.getRunStatus() == 8) {
                this.cStatus.setRunStatus(11);
                logTraceHelper.traceInfo("Initiating operations shutdown...");
                this.cConfOps.handleServiceShutdown();
                this.cCollOps.handleServiceShutdown();
                this.cRepOps.handleServiceShutdown();
                this.cMgmtOps.handleServiceShutdown();
                this.cCollOps = null;
                this.cRepOps = null;
                this.cConfOps = null;
                this.cMgmtOps = null;
                logTraceHelper.traceInfo("DiskCIMScanner shutdown...");
                this.cDiskScanner.shutdown();
                this.cDiskScanner = null;
                logTraceHelper.traceInfo("Shutting down pools...");
                CIMClientPool.shutdown();
                DiskThreadManager.shutdown();
                logTraceHelper.traceInfo("cleanup CIMOMs with pending deletion");
                CIMOMManager.getCIMOMManager().cleanupPendingCIMOMDeletions();
                this.cStatus.setRunStatus(10);
                bl2 = new Boolean(true);
                logTraceHelper.traceInfo("DiskManager with version" + this.getVersion() + "stopped successfully.");
            } else {
                logTraceHelper.traceWarning("Disk Manager not in status \"running\".");
                bl2 = new Boolean(false);
            }
            bl = bl2;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            logTraceHelper.exit(bl2);
            throw throwable;
        }
        logTraceHelper.exit((Object)bl2);
        return bl;
    }

    public boolean startup(ServiceHelper serviceHelper) {
        boolean bl;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"startup", null);
        Boolean bl2 = null;
        if (serviceHelper == null) {
            logTraceHelper.traceError("No ServiceHelper object is passed.", (Throwable)new NullPointerException());
            return false;
        }
        this.cServiceHelper = serviceHelper;
        try {
            if (this.cStatus.getRunStatus() != 9 && this.cStatus.getRunStatus() != 8) {
                logTraceHelper.traceInfo("Disk Manager version " + this.getVersion() + " is starting...");
                this.cStatus.setInstallStatus(5);
                this.cStatus.setRunStatus(9);
                DiskManagerConfigSvc.get().checkDefaultConfig();
                logTraceHelper.traceInfo("cleanup CIMOMs with pending deletion");
                CIMOMManager.getCIMOMManager().cleanupPendingCIMOMDeletions();
                logTraceHelper.traceInfo("Staring DiskCIMScanner...");
                this.cDiskScanner = new DiskCIMScanner();
                logTraceHelper.traceInfo("Creating operations classes...");
                this.cCollOps = new DiskCollectionOperations(this);
                this.cRepOps = new DiskReportingOperations(this);
                this.cConfOps = new DiskConfigurationOperations(this);
                this.cMgmtOps = new DiskManagementOperations(this);
                this.clearCollectionStatus();
                this.cStatus.setRunStatus(8);
                bl2 = new Boolean(true);
                logTraceHelper.traceInfo("Disk Manager version " + this.getVersion() + " started successfully.");
            } else {
                logTraceHelper.traceWarning("Disk Manager already in status \"starting\" or \"running\".");
                bl2 = new Boolean(false);
            }
            bl = bl2;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            logTraceHelper.exit(bl2);
            throw throwable;
        }
        logTraceHelper.exit((Object)bl2);
        return bl;
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, Boolean bl) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.discoverCIMOMs(stringArray, bl.booleanValue());
    }

    public AsyncResult discoverCIMOMs(String[] stringArray, boolean bl) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.discoverCIMOMs(stringArray, bl);
    }

    public CIMOM[] getCIMOMs() throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.getCIMOMsWithoutPW();
    }

    public Result testDeviceStatus(String string, String string2) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.testDeviceStatus(string, string2);
    }

    public String[] getCIMOMIDs() throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.getCIMOMIDs();
    }

    public void modifyCIMOMs(CIMOM[] cIMOMArray) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        cIMOMManager.modifyCIMOMs(cIMOMArray);
    }

    public String[] addCIMOMs(CIMOM[] cIMOMArray) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.addCIMOMs(cIMOMArray);
    }

    public void deleteCIMOMs(String[] stringArray) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        cIMOMManager.deleteCIMOMs(stringArray);
    }

    public CIMOMConnectionStatus[] testCIMOMConnection(CIMOM[] cIMOMArray) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.testCIMOMConnection(cIMOMArray);
    }

    public CimomAndDeviceStatus testCIMOMConnection(CIMOM[] cIMOMArray, CIMObjectPath cIMObjectPath) throws ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.testCIMOMConnection(cIMOMArray, cIMObjectPath);
    }

    public AsyncResult getJobStatus(String string) {
        return ServiceUtils.getJobStatus((String)string);
    }

    public AsyncResult waitForJobToComplete(String string) {
        return DiscoverUtils.waitForJobToComplete((String)string);
    }

    public void cancelJob(String string) {
        DiscoverUtils.cancelJob((String)string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReadLogResponse getLog(String string, byte by, LogFilePos logFilePos, int n) throws RemoteException {
        ReadLogResponse readLogResponse;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{string, new Byte(by), logFilePos, new Integer(n)});
        ReadLogResponse readLogResponse2 = new ReadLogResponse();
        try {
            try {
                logTraceHelper.traceDMInvokation(new Object[]{string, new Byte(by), logFilePos, new Integer(n)});
                readLogResponse = readLogResponse2 = this.getJobManagement().getLog(string, by, logFilePos, n);
                Object var8_8 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (RuntimeException runtimeException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)runtimeException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            logTraceHelper.traceDMReturn(null);
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.traceDMReturn(null);
        logTraceHelper.exit(null);
        return readLogResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReadLogResponse getLog(String string, byte by, LogFilePos logFilePos, String string2, int n) throws RemoteException {
        ReadLogResponse readLogResponse;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{string, new Byte(by), logFilePos, string2, new Integer(n)});
        ReadLogResponse readLogResponse2 = new ReadLogResponse();
        try {
            try {
                logTraceHelper.traceDMInvokation(new Object[]{string, new Byte(by), logFilePos, string2, new Integer(n)});
                readLogResponse = readLogResponse2 = this.getJobManagement().getLog(string, by, logFilePos, string2, n);
                Object var9_9 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (RuntimeException runtimeException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)runtimeException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            logTraceHelper.traceDMReturn(null);
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.traceDMReturn(null);
        logTraceHelper.exit(null);
        return readLogResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReadLogResponse getLog(int n, String string, byte by, LogFilePos logFilePos, int n2) throws RemoteException {
        ReadLogResponse readLogResponse;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{new Integer(n), string, new Byte(by), logFilePos, new Integer(n2)});
        ReadLogResponse readLogResponse2 = new ReadLogResponse();
        try {
            try {
                logTraceHelper.traceDMInvokation(new Object[]{new Integer(n), string, new Byte(by), logFilePos, new Integer(n2)});
                readLogResponse = readLogResponse2 = this.getJobManagement().getLog(n, string, by, logFilePos, n2);
                Object var9_9 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (RuntimeException runtimeException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)runtimeException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            logTraceHelper.traceDMReturn(null);
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.traceDMReturn(null);
        logTraceHelper.exit(null);
        return readLogResponse;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReadLogResponse getLog(int n, String string, byte by, LogFilePos logFilePos, String string2, int n2) throws RemoteException {
        ReadLogResponse readLogResponse;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)this, (String)"getLog", (Object[])new Object[]{new Integer(n), string, new Byte(by), logFilePos, string2, new Integer(n2)});
        ReadLogResponse readLogResponse2 = new ReadLogResponse();
        try {
            try {
                logTraceHelper.traceDMInvokation(new Object[]{new Integer(n), string, new Byte(by), logFilePos, string2, new Integer(n2)});
                readLogResponse = readLogResponse2 = this.getJobManagement().getLog(n, string, by, logFilePos, n2);
                Object var10_10 = null;
            }
            catch (SRMRuntimeException sRMRuntimeException) {
                logTraceHelper.traceError("SRMRuntimeException during Disk Manager service method execution.", (Throwable)sRMRuntimeException);
                throw sRMRuntimeException;
            }
            catch (RuntimeException runtimeException) {
                throw DiskMessageHelper.getServerException((String)"HWN021503E", null, (Throwable)runtimeException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            logTraceHelper.traceDMReturn(null);
            logTraceHelper.exit(null);
            throw throwable;
        }
        logTraceHelper.traceDMReturn(null);
        logTraceHelper.exit(null);
        return readLogResponse;
    }

    public static void registerSubsystemDataInUse(String string) {
        DiskManager.getInstance().cMgmtOps.registerSubsystemDataInUse(string);
    }

    public static void deregisterSubsystemDataInUse(String string) {
        DiskManager.getInstance().cMgmtOps.deregisterSubsystemDataInUse(string);
    }

    public static boolean checkSubsystemDataInUse(String string) throws IDParseException, EntityNotFoundException {
        return DiskManager.getInstance().cMgmtOps.checkSubsystemDataInUse(string);
    }

    public String getOSNameFromOSType(int n) throws RemoteException, ServerException {
        return this.cRepOps.getOSNameFromOSType(n);
    }

    public String getPortNameFromPortType(int n) throws RemoteException, ServerException {
        return this.cRepOps.getPortNameFromPortType(n);
    }

    public String getVendorNameFromID(int n) throws RemoteException, ServerException {
        return this.cRepOps.getVendorNameFromID(n);
    }

    public String getModelNameFromID(int n) throws RemoteException, ServerException {
        return this.cRepOps.getModelNameFromID(n);
    }

    public ArrayList getCIMOMtoDevices(String string) throws RemoteException, ServerException {
        CIMOMManager cIMOMManager = CIMOMManager.getCIMOMManager();
        return cIMOMManager.getCIMOMtoDevices(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean clearCollectionStatus() {
        block10: {
            var1_1 = LogTraceHelper.entry((Object)this, (String)"clearCollectionStatus", null);
            var2_2 = false;
            var3_3 = ServiceUtils.getConnection();
            if (var3_3 == null) {
                var1_1.traceError("No DB connection received", null);
                var1_1.exit((Object)new Boolean(false));
                return false;
            }
            var4_4 = "UPDATE " + TResStorageSubsystemTable.getTablename() + " SET " + "PROBE_STATUS" + " = '" + "1" + "', " + "COLLECTION_STATUS" + " = " + 9 + " WHERE " + "PROBE_STATUS" + " LIKE '%" + "0" + "%'";
            var1_1.traceHigh(var4_4);
            try {
                try {
                    var5_5 = ComplexQuery.sqlUpdate((DBConnection)var3_3, (String)var4_4, new Hashtable<K, V>());
                    var1_1.traceInfo("Cleared running status from " + var5_5 + " storage subsystem records.");
                    var2_2 = true;
                }
                catch (Exception var6_6) {
                    var1_1.traceError("Error cleaning collection status. Query issued: " + var4_4, (Throwable)var6_6);
                }
            }
            catch (Throwable var8_7) {
                var7_8 = null;
                try {
                    if (var3_3 == null) throw var8_7;
                    var3_3.close();
                    throw var8_7;
                }
                catch (Exception var9_10) {
                    var1_1.traceError("Error closing DB connection: ", (Throwable)var9_10);
                    var2_2 = false;
                }
                throw var8_7;
            }
            {
                var7_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 232->243)] { 
lbl32:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block10;
lbl35:
            // 1 sources

            catch (Exception var9_11) {
                var1_1.traceError("Error closing DB connection: ", (Throwable)var9_11);
                var2_2 = false;
            }
        }
        var1_1.exit((Object)new Boolean(var2_2));
        return var2_2;
    }

    public ServiceHelper getServiceHelper() {
        return this.cServiceHelper;
    }

    protected IJobMgmtService getJobManagement() {
        IJobMgmtService iJobMgmtService = (IJobMgmtService)this.getServiceHelper().bindLocal("FabricManagerService");
        return iJobMgmtService;
    }
}

