/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.IStep;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.AssociatorCIMQuery;
import org.eclipse.aperi.discovery.DiscoverStep;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.IProgressLogger;
import org.eclipse.aperi.discovery.ProgressLogger;
import org.eclipse.aperi.discovery.SimpleCIMDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.Query;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.DiskProgressLogger;
import org.eclipse.aperi.disk.collection.IBMDeviceRegistrationDataHelper;
import org.eclipse.aperi.disk.collection.ProbeGenericArraySubsystemProcess;
import org.eclipse.aperi.disk.collection.step.COPCacheStep;
import org.eclipse.aperi.disk.collection.step.CommitStep;
import org.eclipse.aperi.disk.collection.step.RemoveDBReferencesStep;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.interfaces.ParameterException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class ProbeESS11SubsystemProcess
extends ProbeGenericArraySubsystemProcess {
    protected boolean cUseVolumeDistribution = false;
    protected static final String COLLECTIBMEXTENTPOOLSFROMCOMPUTERSYSTEM = "collectIBMExtentPoolsFromComputerSystem";
    protected static final String COLLECTIBMRANKPOOLSFROMCOMPUTERSYSTEM = "collectIBMRankPoolsFromComputerSystem";
    protected static final String COLLECTIBMPRIMORDIALPOOLSFROMCOMPUTERSYSTEM = "collectIBMPrimordialPoolsFromComputerSystem";
    protected static final String COLLECT_VOLUMEDISTRIBUTION_FROM_VIEW = "collectVolumeDistributionFromView";
    protected static final String COLLECT_VOLUMEDISTRIBUTIONCLASS = "collectVolumeDistributionClass";

    public static void registerSteps() {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        try {
            clazz4 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECTIBMEXTENTPOOLSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect IBM Extent Pools From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"IBMTSDS_HostedExtentPool", (String)"IBMTSDS_ExtentPool", null, null), "CIM_ComputerSystem", clazz4.getName(), false));
        try {
            clazz3 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECTIBMRANKPOOLSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect IBM Rank Pools From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"IBMTSDS_HostedRankPool", (String)"IBMTSDS_RankPool", null, null), "CIM_ComputerSystem", clazz3.getName(), false));
        try {
            clazz2 = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECTIBMPRIMORDIALPOOLSFROMCOMPUTERSYSTEM, (IDiscoverProcess)new AssociatorCIMQuery("Collect IBM Primordial Pools From Computersystem", Query.associators((String)"CIM_ComputerSystem", (String)"IBMTSDS_HostedPrimordialStoragePool", (String)"IBMTSDS_PrimordialStoragePool", null, null), "CIM_ComputerSystem", clazz2.getName(), false));
        try {
            clazz = Class.forName("org.sblim.wbem.cim.CIMInstance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        Router.getRouter().addProcess(COLLECT_VOLUMEDISTRIBUTION_FROM_VIEW, (IDiscoverProcess)new AssociatorCIMQuery("collect DSVolumeDistributionView for StorageSystem from view", Query.associators((String)"CIM_ComputerSystem", (String)"IBMTSDS_StorageSystemToVolumeDistribution", (String)"IBMTSDS_VolumeDistribution", null, null), "CIM_ComputerSystem", clazz.getName(), false));
        Router.getRouter().addProcess(COLLECT_VOLUMEDISTRIBUTIONCLASS, (IDiscoverProcess)new SimpleCIMDiscoverProcess("collect DSVolumeDistributionClass", false, new Query[]{Query.enumerateClassNamesQuery((String)"IBMTSDS_StorageSystemToVolumeDistribution")}, false));
    }

    public ProbeESS11SubsystemProcess() {
        super("collectDataFromStorageSubsystem", false);
    }

    public ProbeESS11SubsystemProcess(String string, boolean bl) {
        super(string, bl);
    }

    public static DiscoverProcess.RegistrationData[] getRegistrationData() {
        DiscoverProcess.RegistrationData[] registrationDataArray = IBMDeviceRegistrationDataHelper.generateDS8kRegistrationData("collectDataFromStorageSubsystem", "1.1.0");
        DiscoverProcess.RegistrationData[] registrationDataArray2 = IBMDeviceRegistrationDataHelper.generateDS6kRegistrationData("collectDataFromStorageSubsystem", "1.1.0");
        DiscoverProcess.RegistrationData[] registrationDataArray3 = IBMDeviceRegistrationDataHelper.generateESSRegistrationData("collectDataFromStorageSubsystem", "1.1.0");
        DiscoverProcess.RegistrationData[] registrationDataArray4 = new DiscoverProcess.RegistrationData[registrationDataArray.length + registrationDataArray2.length + registrationDataArray3.length];
        System.arraycopy(registrationDataArray, 0, registrationDataArray4, 0, registrationDataArray.length);
        System.arraycopy(registrationDataArray2, 0, registrationDataArray4, registrationDataArray.length, registrationDataArray2.length);
        System.arraycopy(registrationDataArray3, 0, registrationDataArray4, registrationDataArray.length + registrationDataArray2.length, registrationDataArray3.length);
        return registrationDataArray4;
    }

    public IStep getStepCollectNodesFromComputerSystem(DiskCIMProcessor diskCIMProcessor, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep("collectNodesFromComputerSystem", "CIM_ComputerSystemNodes", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        return discoverStep;
    }

    public IStep getStepCollectPoolsFromComputerSystem(DiskCIMProcessor diskCIMProcessor, CapabilityData capabilityData, String string, LogTraceHelper logTraceHelper) {
        SimpleStep simpleStep = new SimpleStep();
        DiscoverStep discoverStep = new DiscoverStep(COLLECTIBMEXTENTPOOLSFROMCOMPUTERSYSTEM, "CIM_StoragePool", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep2 = new DiscoverStep(COLLECTIBMRANKPOOLSFROMCOMPUTERSYSTEM, "CIM_RankStoragePool", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep3 = new DiscoverStep(COLLECTIBMPRIMORDIALPOOLSFROMCOMPUTERSYSTEM, "CIM_StoragePool", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep4 = new DiscoverStep("collectCapabilitiesFromPools", null, (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep5 = (DiscoverStep)this.getStepCollectVolumesFromPool(diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep6 = new DiscoverStep("collectPoolFromConcretePool", "CIM_RankStoragePool", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep7 = new DiscoverStep("collectExtentsFromRankPool", "CIM_StorageExtent", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep8 = new DiscoverStep("collectExtentsFromRankPool", "CIM_StorageExtent", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep9 = new DiscoverStep("collectExtentsFromPool", "CIM_DiskStorageExtent", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep10 = new DiscoverStep("collectExtentData_StorageVolume_Names", "CIM_StorageVolume", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep11 = new DiscoverStep("collectDiskExtentsFromRankExtent", "CIM_DiskStorageExtent", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep12 = new DiscoverStep("collectArrayExtentsFromRankExtent", "CIM_ArrayStorageExtent", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep13 = new DiscoverStep("collectArraySiteExtentsFromArrayExtent", "CIM_ArraySiteStorageExtent", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        DiscoverStep discoverStep14 = new DiscoverStep("collectDiskExtentsFromArraySiteExtent", "CIM_DiskStorageExtent", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        COPCacheStep cOPCacheStep = null;
        IStep iStep = null;
        cOPCacheStep = new COPCacheStep("CIM_DiskDrive", diskCIMProcessor, false);
        DiskProgressLogger diskProgressLogger = new DiskProgressLogger(logTraceHelper, string, "HWN021734I", "HWN021735I", "HWN021736I", null);
        diskProgressLogger.enableHierarchicalMode();
        simpleStep.setProgressLogger((IProgressLogger)diskProgressLogger);
        cOPCacheStep.setProgressLogger((IProgressLogger)new ProgressLogger.InnerProgressLogger((ProgressLogger)diskProgressLogger));
        iStep = this.getStepCollectDiskDriveFromExtent(diskCIMProcessor, this.getStepCollectDiskDriveLiteData(diskCIMProcessor, cOPCacheStep), logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_StoragePool", "CIM_RankStoragePool", "IBMTSDS_ExtentPool", "IBMTSDS_RankPool", "IBMTSDS_PrimordialStoragePool"}, diskCIMProcessor);
        RemoveDBReferencesStep removeDBReferencesStep2 = new RemoveDBReferencesStep(new String[]{"CIM_StorageVolume"}, diskCIMProcessor);
        RemoveDBReferencesStep removeDBReferencesStep3 = new RemoveDBReferencesStep(new String[]{"CIM_StorageExtent"}, diskCIMProcessor);
        CommitStep commitStep = new CommitStep(diskCIMProcessor);
        simpleStep.addNextStep((IStep)discoverStep);
        discoverStep.addNextStep((IStep)discoverStep4);
        discoverStep.addNextStep((IStep)discoverStep5);
        discoverStep.addNextStep((IStep)discoverStep6);
        discoverStep6.addNextStep((IStep)discoverStep7);
        if (!this.cUseVolumeDistribution) {
            discoverStep7.addNextStep((IStep)discoverStep10);
            discoverStep7.addNextStep((IStep)removeDBReferencesStep2);
        }
        discoverStep7.addNextStep((IStep)discoverStep11);
        discoverStep11.addNextStep(iStep);
        discoverStep7.addNextStep((IStep)discoverStep12);
        discoverStep12.addNextStep((IStep)discoverStep13);
        discoverStep13.addNextStep((IStep)discoverStep14);
        discoverStep14.addNextStep(iStep);
        discoverStep7.addNextStep((IStep)removeDBReferencesStep3);
        discoverStep.addNextStep((IStep)removeDBReferencesStep);
        discoverStep.addNextStep((IStep)commitStep);
        simpleStep.addNextStep((IStep)discoverStep2);
        discoverStep2.addNextStep((IStep)discoverStep8);
        discoverStep8.addNextStep((IStep)discoverStep11);
        discoverStep8.addNextStep((IStep)discoverStep12);
        discoverStep8.addNextStep((IStep)removeDBReferencesStep3);
        discoverStep2.addNextStep((IStep)removeDBReferencesStep);
        discoverStep2.addNextStep((IStep)commitStep);
        simpleStep.addNextStep((IStep)discoverStep3);
        discoverStep3.addNextStep((IStep)discoverStep9);
        discoverStep9.addNextStep(iStep);
        discoverStep9.addNextStep((IStep)removeDBReferencesStep3);
        discoverStep3.addNextStep((IStep)removeDBReferencesStep);
        discoverStep3.addNextStep((IStep)commitStep);
        DiskProgressLogger diskProgressLogger2 = new DiskProgressLogger(logTraceHelper, string, this.cProbeProgressVolumeStart, this.cProbeProgressVolumeProgress, this.cProbeProgressVolumeTotal, null);
        diskProgressLogger2.enableHierarchicalMode();
        discoverStep.setProgressLogger((IProgressLogger)diskProgressLogger2);
        discoverStep5.setProgressLogger((IProgressLogger)new ProgressLogger.InnerProgressLogger((ProgressLogger)diskProgressLogger2));
        if (this.cUseVolumeDistribution) {
            DiscoverStep discoverStep15 = new DiscoverStep(COLLECT_VOLUMEDISTRIBUTION_FROM_VIEW, null, (CIMProcessor)diskCIMProcessor, logTraceHelper);
            simpleStep.addNextStep((IStep)discoverStep15);
        }
        return simpleStep;
    }

    public IStep getStepCollectDiskDriveFromExtent(DiskCIMProcessor diskCIMProcessor, IStep iStep, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep("collectDiskExtentData_DiskDrives", "CIM_DiskDrive", (CIMProcessor)diskCIMProcessor, logTraceHelper);
        RemoveDBReferencesStep removeDBReferencesStep = new RemoveDBReferencesStep(new String[]{"CIM_DiskDrive"}, diskCIMProcessor);
        discoverStep.addNextStep(iStep);
        discoverStep.addNextStep((IStep)removeDBReferencesStep);
        return discoverStep;
    }

    protected boolean runPreprocess(Map map, String string) {
        Router.getRouter().perform("CIMOMUpgradePopProcessESS11", map, string);
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result process(Request request, Map map) throws ParameterException {
        IStep iStep;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Request)request, (Object)((Object)this), (String)"ProbeESS11SubsystemProcess.process", (Object[])new Object[]{map});
        String cfr_ignored_0 = (String)map.get("SUBSYSTEMID");
        String cfr_ignored_1 = (String)map.get("SUBSYSTEMID");
        map = DiscoverUtils.setProbeTimeout((Map)map, (long)DiskManagerConfigSvc.getLongConfigValue((String)"Probe.Timeout.Array", (long)0L), (LogTraceHelper)logTraceHelper);
        DiskCIMProcessor diskCIMProcessor = new DiskCIMProcessor(request.getScannerId());
        boolean bl = false;
        try {
            try {
                CapabilityData cfr_ignored_2 = (CapabilityData)map.get("CAPABILITY");
                iStep = this.getStepCollectClassOfIBMTSDSStorageSystemToVolumeDistribution(diskCIMProcessor, logTraceHelper);
                CIMObjectPath cIMObjectPath = (CIMObjectPath)map.get("TL_CS");
                diskCIMProcessor.initializeForSubsystemProbe(map);
                CIMInstance cIMInstance = new CIMInstance(cIMObjectPath);
                map.put("CIM_ComputerSystem", cIMInstance);
                new Hashtable();
                diskCIMProcessor.start(request.getId());
                bl = iStep.process(new Integer(request.getId()).toString(), map);
                if (bl) {
                    this.cUseVolumeDistribution = true;
                }
            }
            catch (Exception exception) {}
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            request.setReturnCode(0);
            request.setStatus(1);
            diskCIMProcessor.end(request.getId());
            if (diskCIMProcessor != null) {
                diskCIMProcessor.shutdown(request.getId());
                diskCIMProcessor = null;
            }
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        request.setReturnCode(0);
        request.setStatus(1);
        diskCIMProcessor.end(request.getId());
        if (diskCIMProcessor != null) {
            diskCIMProcessor.shutdown(request.getId());
            diskCIMProcessor = null;
        }
        iStep = super.process(request, map);
        logTraceHelper.exit((Object)iStep);
        return iStep;
    }

    public IStep getStepCollectClassOfIBMTSDSStorageSystemToVolumeDistribution(DiskCIMProcessor diskCIMProcessor, LogTraceHelper logTraceHelper) {
        DiscoverStep discoverStep = new DiscoverStep(COLLECT_VOLUMEDISTRIBUTIONCLASS, null, (CIMProcessor)diskCIMProcessor, logTraceHelper);
        SimpleStep simpleStep = new SimpleStep();
        simpleStep.addNextStep((IStep)discoverStep);
        return simpleStep;
    }
}

