/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection.step;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.disk.collection.DiskCIMProcessor;
import org.eclipse.aperi.disk.collection.MappingMaskingProcessor;
import org.eclipse.aperi.disk.collection.step.SimpleStep;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class SVCProtocolControllerForUnitCollectionStep
extends SimpleStep {
    private String cMapName = null;
    private MappingMaskingProcessor cProcessor = null;

    public SVCProtocolControllerForUnitCollectionStep(DiskCIMProcessor diskCIMProcessor, String string) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"SVCProtocolControllerForUnitCollectionStep", (Object[])new Object[]{string});
        this.cMapName = string;
        this.cProcessor = (MappingMaskingProcessor)diskCIMProcessor;
        logTraceHelper.exit(null);
    }

    public boolean process(String string, Map map) throws Exception {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Object)((Object)this), (String)"process", (Object[])new Object[]{string});
        boolean bl = true;
        HashMap hashMap = (HashMap)map.get(this.cMapName);
        CIMInstance cIMInstance = (CIMInstance)map.get("CIM_SCSIProtocolController");
        if (cIMInstance != null) {
            CIMObjectPath cIMObjectPath = cIMInstance.getObjectPath();
            logTraceHelper.traceInfo("Getting VolumeInfos for Controller " + cIMObjectPath.toString());
            List list = (List)hashMap.get(cIMObjectPath);
            if (list != null) {
                Iterator iterator = list.iterator();
                logTraceHelper.traceInfo("Number of VolumeInfos: " + list.size());
                while (iterator.hasNext()) {
                    String[] stringArray = (String[])iterator.next();
                    if (stringArray != null) {
                        this.cProcessor.addVolumeToDataPathForSVC(stringArray[0], stringArray[1]);
                        continue;
                    }
                    logTraceHelper.traceWarning("A VolumeInfo was null");
                }
                logTraceHelper.traceInfo("Finished with all VolumeInfos");
            } else {
                logTraceHelper.traceWarning("List of VolumeInfos was null");
            }
        }
        logTraceHelper.exit((Object)new Boolean(bl));
        return bl;
    }
}

