/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.CIM;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.control.data.Token;
import org.eclipse.aperi.disk.common.CIM.CIMClientWrapper;
import org.eclipse.aperi.disk.common.CIM.CIMDiskManagement;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ParameterHelper;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.control.StorageConfigurationPlugin;
import org.eclipse.aperi.disk.control.util.AssignmentParameter;
import org.eclipse.aperi.disk.control.util.HardwareIDCollection;
import org.eclipse.aperi.disk.control.util.PrivilegeToWWPNs;
import org.eclipse.aperi.disk.control.util.StorageHardwareID;
import org.sblim.wbem.cim.CIMArgument;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.cim.UnsignedInt16;

public class HardwareIDMangement
extends CIMDiskManagement {
    private CIMObjectPath cHardwareIDManagementService = null;

    public HardwareIDMangement(StorageConfigurationPlugin storageConfigurationPlugin, CIMClientWrapper cIMClientWrapper, CIMObjectPath cIMObjectPath, String string, Token token) {
        super(storageConfigurationPlugin, cIMClientWrapper, cIMObjectPath, string, token);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CIMObjectPath retrieveAssociatedHardwareIDManagementService() throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveAssociatedHardwareIDManagementService", null);
        try {
            this.cHardwareIDManagementService = this.retrieveAssociatedService("CIM_StorageHardwareIDManagementService", "CIM_HostedService", "Antecedent", "Dependent");
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            logTraceHelper.exit((Object)this.cHardwareIDManagementService);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        logTraceHelper.exit((Object)this.cHardwareIDManagementService);
        return this.cHardwareIDManagementService;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveStorageHardwareIDsOfHardwareIDCollection(HardwareIDCollection hardwareIDCollection) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveStorageHardwareIDsOfHardwareIDCollection", (Object[])new Object[]{hardwareIDCollection});
        ArrayList<StorageHardwareID> arrayList = new ArrayList<StorageHardwareID>();
        try {
            try {
                Enumeration enumeration = this.cCimClient.associators(hardwareIDCollection.getHardwareIDCollectionCOP(), "CIM_MemberOfCollection", "CIM_StorageHardwareID", "Collection", "Member", true, true, null, this.cLogTraceHelper);
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    StorageHardwareID storageHardwareID = this.generateStorageHardwareIDsFromCIMInstance(cIMInstance, null);
                    arrayList.add(storageHardwareID);
                }
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            logTraceHelper.exit(arrayList);
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        logTraceHelper.exit(arrayList);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveStorageHardwareIDs(ArrayList arrayList, boolean bl) throws ServerException {
        ArrayList<StorageHardwareID> arrayList2;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveStorageHardwareIDs", (Object[])new Object[]{arrayList, new Boolean(bl)});
        ArrayList<StorageHardwareID> arrayList3 = new ArrayList<StorageHardwareID>();
        try {
            try {
                block14: {
                    Enumeration enumeration = this.cCimClient.associators(this.retrieveAssociatedHardwareIDManagementService(), "CIM_ConcreteDependency", "CIM_StorageHardwareID", "Antecedent", "Dependent", true, true, null, this.cLogTraceHelper);
                    while (true) {
                        if (!enumeration.hasMoreElements() || arrayList3.size() >= arrayList.size()) {
                            if (bl && arrayList3.size() < arrayList.size()) {
                                break;
                            }
                            break block14;
                        }
                        CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                        StorageHardwareID storageHardwareID = this.generateStorageHardwareIDsFromCIMInstance(cIMInstance, arrayList);
                        if (storageHardwareID == null) continue;
                        arrayList3.add(storageHardwareID);
                    }
                    String string = "";
                    ArrayList<String> arrayList4 = new ArrayList<String>();
                    int n = 0;
                    while (true) {
                        if (n >= arrayList3.size()) break;
                        arrayList4.add(((StorageHardwareID)arrayList3.get(n)).getWWPN());
                        ++n;
                    }
                    n = 0;
                    while (true) {
                        if (n >= arrayList.size()) {
                            ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021613E", (Object)string, (Object)this.cPlugin.getParams().getStorageSubsystemID(), (LogTraceHelper)logTraceHelper);
                            logTraceHelper.traceError("StorageHardwareID not found", (Throwable)serverException);
                            throw serverException;
                        }
                        if (!ParameterHelper.listContainsStringIgnoreCase(arrayList4, (String)((String)arrayList.get(n)))) {
                            string = (String)arrayList.get(n);
                        }
                        ++n;
                    }
                }
                if (arrayList3.size() > arrayList.size()) {
                    ServerException serverException = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)logTraceHelper);
                    logTraceHelper.traceError("CIMOM returned several StorageHardwareIDs for the same WWPN.", (Throwable)serverException);
                    throw serverException;
                }
                arrayList2 = arrayList3;
                Object var11_16 = null;
            }
            catch (CIMException cIMException) {
                cIMException.printStackTrace();
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        logTraceHelper.exit(arrayList3);
        return arrayList2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivilegeToWWPNs retrieveHardwareIDCollectionsOfPrivileges(PrivilegeToWWPNs privilegeToWWPNs) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveHardwareIDCollectionsOfPrivileges", (Object[])new Object[]{privilegeToWWPNs});
        PrivilegeToWWPNs privilegeToWWPNs2 = privilegeToWWPNs;
        try {
            try {
                Enumeration enumeration = this.cCimClient.associators(privilegeToWWPNs.getPrivilege(), "CIM_AuthorizedSubject", "CIM_SystemSpecificCollection", "Privilege", "PrivilegedElement", true, true, null, this.cLogTraceHelper);
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    HardwareIDCollection hardwareIDCollection = new HardwareIDCollection(cIMInstance.getObjectPath());
                    hardwareIDCollection.setHardwareIDCollectionInstance(cIMInstance);
                    hardwareIDCollection.setStorageHardwareIDs(this.retrieveStorageHardwareIDsOfHardwareIDCollection(hardwareIDCollection));
                    privilegeToWWPNs2.addStorageHardwareIDCollection(hardwareIDCollection);
                }
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            logTraceHelper.exit((Object)privilegeToWWPNs2);
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        logTraceHelper.exit((Object)privilegeToWWPNs2);
        return privilegeToWWPNs2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivilegeToWWPNs retrieveStorageHardwareIDsOfPrivileges(PrivilegeToWWPNs privilegeToWWPNs) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveStorageHardwareIDsOfPrivileges", (Object[])new Object[]{privilegeToWWPNs});
        PrivilegeToWWPNs privilegeToWWPNs2 = privilegeToWWPNs;
        try {
            try {
                Enumeration enumeration = this.cCimClient.associators(privilegeToWWPNs.getPrivilege(), "CIM_AuthorizedSubject", "CIM_StorageHardwareID", "Privilege", "PrivilegedElement", true, true, null, this.cLogTraceHelper);
                while (enumeration.hasMoreElements()) {
                    CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                    privilegeToWWPNs2.addStorageHardwareID(this.generateStorageHardwareIDsFromCIMInstance(cIMInstance, null));
                }
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associators", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            logTraceHelper.exit((Object)privilegeToWWPNs2);
            throw throwable;
        }
        {
            Object var6_10 = null;
        }
        logTraceHelper.exit((Object)privilegeToWWPNs2);
        return privilegeToWWPNs2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList createStorageHardwareIDs(ArrayList arrayList, String[] stringArray, CIMObjectPath cIMObjectPath) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"createStorageHardwareIDs", (Object[])new Object[]{arrayList, stringArray, cIMObjectPath});
        ArrayList<StorageHardwareID> arrayList2 = new ArrayList<StorageHardwareID>();
        try {
            try {
                int n = 0;
                block8: while (n < arrayList.size()) {
                    Vector<CIMArgument> vector = new Vector<CIMArgument>();
                    Vector vector2 = new Vector();
                    vector.add(new CIMArgument("StorageID", new CIMValue(arrayList.get(n), CIMDataType.getPredefinedType((int)8))));
                    vector.add(new CIMArgument("IDType", new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2))));
                    if (stringArray != null && stringArray.length != 0) {
                        vector.add(new CIMArgument("ElementName", new CIMValue((Object)stringArray[n], CIMDataType.getPredefinedType((int)8))));
                    }
                    if (cIMObjectPath != null) {
                        vector.add(new CIMArgument("Setting", new CIMValue((Object)cIMObjectPath, CIMDataType.getPredefinedType((int)14))));
                    }
                    if (stringArray != null && stringArray.length != 0) {
                        try {
                            this.invokeCIMMethod(this.getHardwareIDManagementService(), "CreateStorageHardwareID", vector, vector2);
                        }
                        catch (ServerException serverException) {
                            if (!serverException.getSRMMessage().getMsgId().equals("HWN021515E")) throw serverException;
                            if (serverException.getCause().getMessage().toLowerCase().indexOf("cim_err_not_supported") == -1) throw serverException;
                            logTraceHelper.traceError("Will retry CreateStorageHardwareID cause the Internal error: CIMException", serverException.getCause());
                            DiskMessageHelper.getSRMMessage((String)"HWN021515E", (Object)"CreateStorageHardwareID", (Object)this.cCimClient.toString(), (Object)"Will retry this method without ElementName", (LogTraceHelper)logTraceHelper);
                            vector = new Vector();
                            vector2 = new Vector();
                            vector.add(new CIMArgument("StorageID", new CIMValue(arrayList.get(n), CIMDataType.getPredefinedType((int)8))));
                            vector.add(new CIMArgument("IDType", new CIMValue((Object)new UnsignedInt16(2), CIMDataType.getPredefinedType((int)2))));
                            if (cIMObjectPath != null) {
                                vector.add(new CIMArgument("Setting", new CIMValue((Object)cIMObjectPath, CIMDataType.getPredefinedType((int)14))));
                            }
                            this.invokeCIMMethod(this.getHardwareIDManagementService(), "CreateStorageHardwareID", vector, vector2);
                        }
                    } else {
                        this.invokeCIMMethod(this.getHardwareIDManagementService(), "CreateStorageHardwareID", vector, vector2);
                    }
                    int n2 = 0;
                    while (true) {
                        if (n2 >= vector2.size()) {
                            ++n;
                            continue block8;
                        }
                        CIMArgument cIMArgument = (CIMArgument)vector2.get(n2);
                        if (cIMArgument.getName().equals("HardwareID")) {
                            CIMObjectPath cIMObjectPath2 = (CIMObjectPath)cIMArgument.getValue().getValue();
                            CIMInstance cIMInstance = this.retrieveCIMInstance(cIMObjectPath2);
                            StorageHardwareID storageHardwareID = new StorageHardwareID((String)arrayList.get(n), cIMInstance, cIMObjectPath2);
                            arrayList2.add(storageHardwareID);
                        }
                        ++n2;
                    }
                }
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"getInstance", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            logTraceHelper.exit(arrayList2);
            throw throwable;
        }
        {
            Object var14_19 = null;
        }
        logTraceHelper.exit(arrayList2);
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList getStorageHardwareIDs(ArrayList arrayList, String[] stringArray, CIMObjectPath cIMObjectPath, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getStorageHardwareIDs", (Object[])new Object[]{arrayList, stringArray, cIMObjectPath, arrayList2});
        ArrayList arrayList3 = null;
        try {
            if (arrayList2 == null) {
                arrayList2 = new ArrayList();
            }
            ArrayList arrayList4 = new ArrayList();
            ArrayList<String> arrayList5 = new ArrayList<String>();
            arrayList3 = this.retrieveStorageHardwareIDs(arrayList, false);
            if (arrayList3.size() != arrayList.size()) {
                ArrayList<String> arrayList6 = new ArrayList<String>();
                int n = 0;
                while (n < arrayList3.size()) {
                    arrayList6.add(((StorageHardwareID)arrayList3.get(n)).getWWPN());
                    ++n;
                }
                n = 0;
                while (n < arrayList.size()) {
                    if (!ParameterHelper.listContainsStringIgnoreCase(arrayList6, (String)((String)arrayList.get(n)))) {
                        arrayList4.add(arrayList.get(n));
                        if (stringArray != null) {
                            arrayList5.add(stringArray[n]);
                        }
                    }
                    ++n;
                }
                arrayList2.addAll(this.createStorageHardwareIDs(arrayList4, arrayList5.toArray(new String[0]), cIMObjectPath));
                arrayList3.addAll(arrayList2);
            }
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        logTraceHelper.exit((Object)arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArrayList retrieveCollectionsForStorageHardwareIDs(ArrayList arrayList, ArrayList arrayList2) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveCollectionsForStorageHardwareIDs", (Object[])new Object[]{arrayList, arrayList2});
        ArrayList<HardwareIDCollection> arrayList3 = new ArrayList<HardwareIDCollection>();
        try {
            try {
                int n = 0;
                while (n < arrayList.size()) {
                    block12: {
                        Object object;
                        HardwareIDCollection hardwareIDCollection;
                        boolean bl = false;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= arrayList3.size()) {
                                if (!bl) break;
                                break block12;
                            }
                            hardwareIDCollection = (HardwareIDCollection)arrayList3.get(n2);
                            bl = hardwareIDCollection.containsStorageHardwareID((StorageHardwareID)arrayList.get(n));
                            ++n2;
                        }
                        CIMObjectPath cIMObjectPath = ((StorageHardwareID)arrayList.get(n)).getStorageHardwareIDCOP();
                        Enumeration enumeration = this.cCimClient.associators(cIMObjectPath, "CIM_MemberOfCollection", "CIM_SystemSpecificCollection", "Member", "Collection", true, true, null, this.cLogTraceHelper);
                        if (!enumeration.hasMoreElements()) {
                            if (arrayList2 == null) {
                                object = DiskMessageHelper.getServerException((String)"HWN021529E", (Object)this.cCimClient.toString(), (LogTraceHelper)logTraceHelper);
                                logTraceHelper.traceError("No HardwareIDCollection for StorageHardwareID found", (Throwable)object);
                                throw object;
                            }
                            arrayList2.add(arrayList.get(n));
                        }
                        while (enumeration.hasMoreElements()) {
                            object = (CIMInstance)enumeration.nextElement();
                            hardwareIDCollection = new HardwareIDCollection(object.getObjectPath());
                            hardwareIDCollection.setHardwareIDCollectionInstance((CIMInstance)object);
                            ArrayList arrayList4 = this.retrieveStorageHardwareIDsOfHardwareIDCollection(hardwareIDCollection);
                            hardwareIDCollection.addStorageHardwareIDs(arrayList4);
                            arrayList3.add(hardwareIDCollection);
                        }
                    }
                    ++n;
                }
            }
            catch (CIMException cIMException) {
                logTraceHelper.traceError("Internal error: CIMException", (Throwable)cIMException);
                throw DiskMessageHelper.getServerException((String)"HWN021515E", (Object)"associatorNames", (Object)this.cCimClient.toString(), (Object)cIMException.toString(), (Throwable)cIMException, (LogTraceHelper)logTraceHelper);
            }
            catch (DiskManagerTimeoutException diskManagerTimeoutException) {
                logTraceHelper.traceError("Internal error: DiskManagerTimeoutException", (Throwable)diskManagerTimeoutException);
                throw DiskMessageHelper.getServerException((String)"HWN021650E", (Object)this.cCimClient, (Throwable)diskManagerTimeoutException, (LogTraceHelper)logTraceHelper);
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            logTraceHelper.exit(arrayList3);
            throw throwable;
        }
        {
            Object var12_17 = null;
        }
        logTraceHelper.exit(arrayList3);
        return arrayList3;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrivilegeToWWPNs retrieveInitiatorsOfPrivilege(PrivilegeToWWPNs privilegeToWWPNs) throws ServerException {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"retrieveInitiatorsOfPrivilege", (Object[])new Object[]{privilegeToWWPNs});
        PrivilegeToWWPNs privilegeToWWPNs2 = null;
        try {
            privilegeToWWPNs2 = this.retrieveStorageHardwareIDsOfPrivileges(privilegeToWWPNs);
            if (((AssignmentParameter)this.cPlugin.getParams()).getCapability().getControllerSuppColl() == 1) {
                privilegeToWWPNs2 = this.retrieveHardwareIDCollectionsOfPrivileges(privilegeToWWPNs2);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            logTraceHelper.exit((Object)privilegeToWWPNs2);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        logTraceHelper.exit((Object)privilegeToWWPNs2);
        return privilegeToWWPNs2;
    }

    public CIMObjectPath getHardwareIDManagementService() throws ServerException {
        CIMObjectPath cIMObjectPath;
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"getHardwareIDManagementService", (Object[])new Object[1]);
        try {
            if (this.cHardwareIDManagementService == null) {
                this.retrieveAssociatedHardwareIDManagementService();
            }
            cIMObjectPath = this.cHardwareIDManagementService;
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            logTraceHelper.exit((Object)this.cHardwareIDManagementService);
            throw throwable;
        }
        logTraceHelper.exit((Object)this.cHardwareIDManagementService);
        return cIMObjectPath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StorageHardwareID generateStorageHardwareIDsFromCIMInstance(CIMInstance cIMInstance, ArrayList arrayList) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry((Token)this.cToken, (Object)((Object)this), (String)"generateStorageHardwareIDsFromCIMInstance", (Object[])new Object[]{cIMInstance, arrayList});
        StorageHardwareID storageHardwareID = null;
        try {
            CIMValue cIMValue = cIMInstance.getProperty("IDType").getValue();
            if (((UnsignedInt16)cIMValue.getValue()).intValue() == 2) {
                cIMValue = cIMInstance.getProperty("StorageID").getValue();
                if (arrayList == null || ParameterHelper.listContainsStringIgnoreCase((List)arrayList, (String)((String)cIMValue.getValue()))) {
                    storageHardwareID = new StorageHardwareID((String)cIMValue.getValue(), cIMInstance);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            logTraceHelper.exit(storageHardwareID);
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        logTraceHelper.exit(storageHardwareID);
        return storageHardwareID;
    }
}

