/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.monitor;

import java.sql.SQLException;
import java.util.Hashtable;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.Processor;
import org.eclipse.aperi.disk.api.impl.DiskManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.thread.DiskManagerTimeoutException;
import org.eclipse.aperi.disk.discovery.CIMInstanceHelper;
import org.eclipse.aperi.disk.monitor.CIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.HandlingResult;
import org.eclipse.aperi.disk.monitor.ICIMIndicationHandler;
import org.eclipse.aperi.disk.monitor.VolumeIndicationHandler;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.infrastructure.database.objects.StorageSubsystem;
import org.eclipse.aperi.infrastructure.database.objects.StorageVolume;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.eclipse.aperi.monitor.eventcorrelator.data.CIMIndicationEvent;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;

public class VolumeCreationHandler
extends VolumeIndicationHandler
implements ICIMIndicationHandler {
    public String mSMISVersion = "";

    public static CIMIndicationHandler.RegistrationData[] getRegistrationData() {
        CIMIndicationHandler.RegistrationData registrationData = new CIMIndicationHandler.RegistrationData("CIM_StorageVolume", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData registrationData2 = new CIMIndicationHandler.RegistrationData("IBMTSESS_Volume", "CIM_InstCreation");
        CIMIndicationHandler.RegistrationData registrationData3 = new CIMIndicationHandler.RegistrationData("IBMTSSVC_StorageVolume", "CIM_InstCreation");
        return new CIMIndicationHandler.RegistrationData[]{registrationData, registrationData2, registrationData3};
    }

    public VolumeCreationHandler(String string, String string2, CIMIndicationEvent cIMIndicationEvent) {
        super(string, string2, cIMIndicationEvent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HandlingResult handle(LogTraceHelper logTraceHelper, String string) {
        try {
            HandlingResult handlingResult;
            DBConnection dBConnection = (DBConnection)DBConnPoolDataSource.getInstance().getPooledConnection();
            try {
                MapperResult mapperResult;
                CIMInstance cIMInstance = this.getEvent().getSourceInstance();
                CIMInstance cIMInstance2 = this.getTopLevelSystemInstance(cIMInstance);
                this.mSMISVersion = this.getSMISVersion(cIMInstance2);
                CIMInstance cIMInstance3 = this.getPoolInstance(cIMInstance);
                String string2 = this.getEvent().getCIMOM().getServiceUrl();
                String string3 = cIMInstance.getObjectPath().getNameSpace();
                String string4 = cIMInstance2.getObjectPath().getNameSpace();
                String string5 = (String)cIMInstance2.getProperty("Name").getValue().getValue();
                short s = Short.parseShort(DBConstants.getValueFromKey((String)"SMISName_Format", (String)((String)cIMInstance2.getProperty("NameFormat").getValue().getValue()).toLowerCase()));
                StorageSubsystem storageSubsystem = new StorageSubsystem();
                storageSubsystem.setName(string5);
                storageSubsystem.setNameFormat(s);
                storageSubsystem.retrieve(dBConnection);
                Hashtable hashtable = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)cIMInstance2);
                hashtable.put("ref_serviceurl", string2);
                hashtable.put("ref_namespace", string4);
                Hashtable hashtable2 = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)cIMInstance3);
                hashtable2.put("ref_serviceurl", string2);
                hashtable2.put("ref_namespace", string3);
                hashtable2.put("ref_classname", cIMInstance3.getClassName());
                Hashtable hashtable3 = CIMInstanceHelper.getAllPropertiesIntoHashTable((CIMInstance)cIMInstance);
                hashtable3.put("ref_serviceurl", string2);
                hashtable3.put("ref_namespace", string3);
                MapperRouter mapperRouter = MapperRouter.getMapperRouter();
                IDBAttributeMapper iDBAttributeMapper = mapperRouter.findMapper(cIMInstance2.getClassName(), this.mSMISVersion, null, null, "15", "CIM_ComputerSystem");
                IDBAttributeMapper iDBAttributeMapper2 = mapperRouter.findMapper(cIMInstance3.getClassName(), this.mSMISVersion, null, null, null, "CIM_StoragePool");
                IDBAttributeMapper iDBAttributeMapper3 = mapperRouter.findMapper(this.getCIMClassname(), this.mSMISVersion, null, null, null, "CIM_StorageVolume");
                try {
                    mapperResult = iDBAttributeMapper.persist(dBConnection, hashtable, string);
                    hashtable3.putAll(mapperResult.getKeyReferences());
                    hashtable2.putAll(mapperResult.getKeyReferences());
                    mapperResult = iDBAttributeMapper2.persist(dBConnection, hashtable2, string);
                    hashtable3.putAll(mapperResult.getKeyReferences());
                    mapperResult = iDBAttributeMapper3.persist(dBConnection, hashtable3, string);
                    dBConnection.commit();
                    AlertProcessor.processAlerts((String)string, (MapperResult)mapperResult, new Hashtable(), new Hashtable());
                    Processor.getEventMonitorProxy().handleModelUpdate(string);
                }
                catch (Exception exception) {
                    logTraceHelper.traceError("Database update failed, calling rollback()", (Throwable)exception);
                    dBConnection.rollback();
                    throw new RuntimeException(exception);
                }
                Hashtable hashtable4 = mapperResult.getAllRows();
                Hashtable hashtable5 = (Hashtable)hashtable4.get(StorageVolume.getTablename());
                String string6 = (String)hashtable5.get(StorageVolume.getColumnInfo((String)"NAME"));
                String string7 = (String)hashtable5.get(StorageVolume.getColumnInfo((String)"NAME_FORMAT"));
                String string8 = ExternalKeyConverter.frameKeyStorageVolume((String)string6, (short)Short.parseShort(string7), (String)storageSubsystem.getName(), (short)storageSubsystem.getNameFormat());
                DiskManager.getInstance().probeStorageVolume(String.valueOf(String.valueOf(storageSubsystem.getName()) + "+" + String.valueOf(storageSubsystem.getNameFormat())), string8, 2);
                handlingResult = HandlingResult.SUCCESS;
                Object var26_31 = null;
                if (dBConnection == null) return handlingResult;
            }
            catch (Throwable throwable) {
                Object var26_32 = null;
                if (dBConnection != null) {
                    dBConnection.close();
                }
                throw throwable;
            }
            dBConnection.close();
            return handlingResult;
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException);
        }
        catch (CIMException cIMException) {
            throw new RuntimeException(cIMException);
        }
        catch (DiskManagerTimeoutException diskManagerTimeoutException) {
            throw new RuntimeException(diskManagerTimeoutException);
        }
    }
}

