/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CachedMetaDataHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IDataSetModel;
import org.eclipse.birt.report.model.elements.interfaces.ISimpleDataSetModel;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public abstract class DataSetHandle
extends ReportElementHandle
implements IDataSetModel,
ISimpleDataSetModel {
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataSetHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public DataSourceHandle getDataSource() {
        return (DataSourceHandle)this.getElementProperty("dataSource");
    }

    public String getDataSourceName() {
        return this.getStringProperty("dataSource");
    }

    public void setDataSource(String name) throws SemanticException {
        this.setStringProperty("dataSource", name);
    }

    public Iterator parametersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("parameters");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public Iterator paramBindingsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("paramBindings");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public Iterator resultSetIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("resultSet");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public Iterator resultSetHintsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("resultSetHints");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public Iterator computedColumnsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("computedColumns");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public Iterator columnHintsIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("columnHints");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        return propHandle.iterator();
    }

    public String getBeforeOpen() {
        return this.getStringProperty("beforeOpen");
    }

    public void setBeforeOpen(String code) throws SemanticException {
        this.setProperty("beforeOpen", code);
    }

    public String getBeforeClose() {
        return this.getStringProperty("beforeClose");
    }

    public void setBeforeClose(String code) throws SemanticException {
        this.setProperty("beforeClose", code);
    }

    public String getAfterOpen() {
        return this.getStringProperty("afterOpen");
    }

    public void setAfterOpen(String code) throws SemanticException {
        this.setProperty("afterOpen", code);
    }

    public String getAfterClose() {
        return this.getStringProperty("afterClose");
    }

    public void setAfterClose(String code) throws SemanticException {
        this.setProperty("afterClose", code);
    }

    public String getOnFetch() {
        return this.getStringProperty("onFetch");
    }

    public void setOnFetch(String code) throws SemanticException {
        this.setProperty("onFetch", code);
    }

    public CachedMetaDataHandle getCachedMetaDataHandle() {
        PropertyHandle propHandle = this.getPropertyHandle("cachedMetaData");
        if (!$assertionsDisabled && propHandle == null) {
            throw new AssertionError();
        }
        CachedMetaData value = (CachedMetaData)propHandle.getValue();
        if (value == null) {
            return null;
        }
        return (CachedMetaDataHandle)value.getHandle(propHandle);
    }

    public CachedMetaDataHandle setCachedMetaData(CachedMetaData metadata) throws SemanticException {
        this.setProperty("cachedMetaData", metadata);
        if (metadata == null) {
            return null;
        }
        return (CachedMetaDataHandle)metadata.getHandle(this.getPropertyHandle("cachedMetaData"));
    }

    public PropertyHandle getPropertyHandle(String propName) {
        if ("parameters".equals(propName)) {
            return new DataSetParametersPropertyHandle((DesignElementHandle)this, propName);
        }
        return super.getPropertyHandle(propName);
    }

    public void setCachedRowCount(int count) throws SemanticException {
        this.setIntProperty("cachedRowCount", count);
    }

    public int getCachedRowCount() {
        return this.getIntProperty("cachedRowCount");
    }

    static {
        $assertionsDisabled = !DataSetHandle.class.desiredAssertionStatus();
    }

    static final class DataSetParametersPropertyHandle
    extends PropertyHandle {
        static final /* synthetic */ boolean $assertionsDisabled;

        public DataSetParametersPropertyHandle(DesignElementHandle element, ElementPropertyDefn prop) {
            super(element, prop);
        }

        public DataSetParametersPropertyHandle(DesignElementHandle element, String propName) {
            super(element, propName);
        }

        public void removeItem(int posn) throws PropertyValueException {
            DataSetParameterHandle paramHandle = (DataSetParameterHandle)this.getAt(posn);
            DataSetParameter param = (DataSetParameter)paramHandle.getStructure();
            this.getModule().getActivityStack().startTrans();
            try {
                super.removeItem(posn);
            }
            catch (PropertyValueException e) {
                this.getModule().getActivityStack().rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(param.getName());
            }
            catch (PropertyValueException e) {
                // empty catch block
            }
            this.getModule().getActivityStack().commit();
        }

        public void removeItem(IStructure item) throws PropertyValueException {
            DataSetParameter param = (DataSetParameter)item;
            this.getModule().getActivityStack().startTrans();
            try {
                super.removeItem(item);
            }
            catch (PropertyValueException e) {
                this.getModule().getActivityStack().rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(param.getName());
            }
            catch (PropertyValueException propertyValueException) {
                // empty catch block
            }
            this.getModule().getActivityStack().commit();
        }

        public void removeItems(List items) throws PropertyValueException {
            this.getModule().getActivityStack().startTrans();
            try {
                super.removeItems(items);
            }
            catch (PropertyValueException e) {
                this.getModule().getActivityStack().rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(items);
            }
            catch (PropertyValueException propertyValueException) {
                // empty catch block
            }
            this.getModule().getActivityStack().commit();
        }

        public void replaceItem(IStructure oldItem, IStructure newItem) throws SemanticException {
            this.getModule().getActivityStack().startTrans();
            try {
                super.replaceItem(oldItem, newItem);
            }
            catch (PropertyValueException e) {
                this.getModule().getActivityStack().rollback();
                throw e;
            }
            this.updateParamBindings(((DataSetParameter)oldItem).getName(), ((DataSetParameter)newItem).getName());
            this.getModule().getActivityStack().commit();
        }

        public void setValue(Object value) throws SemanticException {
            ArrayList paramList = this.getListValue();
            this.getModule().getActivityStack().startTrans();
            try {
                super.setValue(value);
            }
            catch (PropertyValueException e) {
                this.getModule().getActivityStack().rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(paramList);
            }
            catch (PropertyValueException propertyValueException) {
                // empty catch block
            }
            this.getModule().getActivityStack().commit();
        }

        public void clearValue() throws SemanticException {
            ArrayList paramList = this.getListValue();
            this.getModule().getActivityStack().startTrans();
            try {
                super.clearValue();
            }
            catch (PropertyValueException e) {
                this.getModule().getActivityStack().rollback();
                throw e;
            }
            try {
                this.removeParamBindingsFor(paramList);
            }
            catch (PropertyValueException propertyValueException) {
                // empty catch block
            }
            this.getModule().getActivityStack().commit();
        }

        private void removeParamBindingsFor(List params) throws PropertyValueException {
            if (params == null) {
                return;
            }
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                String paramName = null;
                Object item = iter.next();
                if (item instanceof DataSetParameterHandle) {
                    paramName = ((DataSetParameterHandle)item).getName();
                } else if (item instanceof DataSetParameter) {
                    paramName = ((DataSetParameter)item).getName();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                this.removeParamBindingsFor(paramName);
            }
        }

        private void removeParamBindingsFor(String paramName) throws PropertyValueException {
            if (paramName == null) {
                return;
            }
            Iterator iter = this.getElementHandle().clientsIterator();
            while (iter.hasNext()) {
                Action action;
                DesignElementHandle client = (DesignElementHandle)iter.next();
                PropertyHandle paramBindingsPropHandle = client.getPropertyHandle("paramBindings");
                DataSetParametersPropertyHandle.removeParamBindingFor(paramBindingsPropHandle, paramName);
                PropertyHandle actionPropHandle = client.getPropertyHandle("action");
                if (actionPropHandle == null || (action = (Action)actionPropHandle.getValue()) == null) continue;
                ActionHandle actionHandle = (ActionHandle)action.getHandle(actionPropHandle);
                MemberHandle paramBindingsMemberHandle = actionHandle.getMember("paramBindings");
                DataSetParametersPropertyHandle.removeParamBindingFor(paramBindingsMemberHandle, paramName);
            }
            PropertyHandle paramBindingsPropHandle = this.getElementHandle().getPropertyHandle("paramBindings");
            DataSetParametersPropertyHandle.removeParamBindingFor(paramBindingsPropHandle, paramName);
        }

        private static void removeParamBindingFor(SimpleValueHandle paramBindingsPropHandle, String paramName) throws PropertyValueException {
            if (paramBindingsPropHandle == null) {
                return;
            }
            ArrayList<ParamBindingHandle> bindings = new ArrayList<ParamBindingHandle>();
            Iterator bindingIter = paramBindingsPropHandle.iterator();
            while (bindingIter.hasNext()) {
                ParamBindingHandle bindingHandle = (ParamBindingHandle)bindingIter.next();
                if (!paramName.equals(bindingHandle.getParamName())) continue;
                bindings.add(bindingHandle);
            }
            paramBindingsPropHandle.removeItems(bindings);
        }

        void updateParamBindings(String oldParamName, String newParamName) {
            Iterator iter = this.getElementHandle().clientsIterator();
            while (iter.hasNext()) {
                Action action;
                DesignElementHandle client = (DesignElementHandle)iter.next();
                PropertyHandle paramBindingsPropHandle = client.getPropertyHandle("paramBindings");
                DataSetParametersPropertyHandle.updateParamBindings(paramBindingsPropHandle, oldParamName, newParamName);
                PropertyHandle actionPropHandle = client.getPropertyHandle("action");
                if (actionPropHandle == null || (action = (Action)actionPropHandle.getValue()) == null) continue;
                ActionHandle actionHandle = (ActionHandle)action.getHandle(actionPropHandle);
                MemberHandle paramBindingsMemberHandle = actionHandle.getMember("paramBindings");
                DataSetParametersPropertyHandle.updateParamBindings(paramBindingsMemberHandle, oldParamName, newParamName);
            }
            PropertyHandle paramBindingsPropHandle = this.getElementHandle().getPropertyHandle("paramBindings");
            DataSetParametersPropertyHandle.updateParamBindings(paramBindingsPropHandle, oldParamName, newParamName);
        }

        private static void updateParamBindings(SimpleValueHandle paramBindingsPropHandle, String oldParamName, String newParamName) {
            if (paramBindingsPropHandle == null) {
                return;
            }
            Iterator bindingIter = paramBindingsPropHandle.iterator();
            while (bindingIter.hasNext()) {
                ParamBindingHandle bindingHandle = (ParamBindingHandle)bindingIter.next();
                if (!oldParamName.equals(bindingHandle.getParamName())) continue;
                bindingHandle.setParamName(newParamName);
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$model$api$DataSetHandle == null ? (class$org$eclipse$birt$report$model$api$DataSetHandle = DataSetHandle.class$("org.eclipse.birt.report.model.api.DataSetHandle")) : class$org$eclipse$birt$report$model$api$DataSetHandle).desiredAssertionStatus();
        }
    }
}

