/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.List;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;

public final class LayoutHelper {
    private static void applyLayoutOnRow(LayoutSlot mappingSlot, TableRow row, Module module) {
        List cells = row.getContentsSlot();
        if (cells.size() == 0) {
            return;
        }
        LayoutRow mappingRow = mappingSlot.getCurrentLayoutRow();
        int startCol = 1;
        for (int i = 0; i < cells.size(); ++i) {
            Cell cell = (Cell)cells.get(i);
            int colSpan = cell.getColSpan(module);
            int definedColumn = cell.getColumn(module);
            startCol = definedColumn != 0 ? definedColumn : LayoutHelper.findFillInPosition(mappingRow, startCol, colSpan);
            mappingSlot.addCell(startCol, cell.getRowSpan(module), colSpan, cell, false);
            startCol += colSpan;
        }
    }

    private static int findFillInPosition(LayoutRow row, int startPos, int colSpan) {
        int i;
        int startCol = 0;
        int interval = 0;
        for (i = startPos - 1; i < row.getColumnCount(); ++i) {
            LayoutCell cell = row.getLayoutCell(i);
            interval = !cell.isUsed() ? ++interval : 0;
            if (interval <= 0) continue;
            startCol = i + 1;
            break;
        }
        if (startCol == 0) {
            LayoutCell cell;
            startCol = row.getColumnCount() + 1;
            for (i = row.getColumnCount() - 1; i >= startPos - 1 && !(cell = row.getLayoutCell(i)).isUsed(); --i) {
                --startCol;
            }
        }
        return startCol;
    }

    public static LayoutTable applyLayout(Module module, TableItem table) {
        LayoutSlot slot;
        ContainerSlot header;
        TableGroup group;
        int groupIndex;
        LayoutTable mappingTable = new LayoutTable(table, module);
        LayoutHelper.applyLayoutOnSlot(mappingTable.getHeader(), table.getSlot(0), module);
        ContainerSlot groups = table.getSlot(1);
        int groupCount = groups.getCount();
        for (groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
            group = (TableGroup)groups.getContent(groupIndex);
            header = group.getSlot(0);
            slot = mappingTable.getGroupHeaders().addSlot(group.getGroupLevel(), mappingTable.getColumnCount());
            LayoutHelper.applyLayoutOnSlot(slot, header, module);
        }
        LayoutHelper.applyLayoutOnSlot(mappingTable.getDetail(), table.getSlot(2), module);
        for (groupIndex = groupCount - 1; groupIndex >= 0; --groupIndex) {
            group = (TableGroup)groups.getContent(groupIndex);
            header = group.getSlot(1);
            slot = mappingTable.getGroupFooters().addSlot(group.getGroupLevel(), mappingTable.getColumnCount());
            LayoutHelper.applyLayoutOnSlot(slot, header, module);
        }
        LayoutHelper.applyLayoutOnSlot(mappingTable.getFooter(), table.getSlot(3), module);
        return mappingTable;
    }

    protected static void applyLayoutOnSlot(LayoutSlot mappingSlot, ContainerSlot slot, Module module) {
        for (int rowIndex = 0; rowIndex < slot.getCount(); ++rowIndex) {
            TableRow row = (TableRow)slot.getContent(rowIndex);
            mappingSlot.newLayoutRow(row);
            LayoutHelper.applyLayoutOnRow(mappingSlot, row, module);
        }
    }
}

