/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class DataSetRequiredValidator
extends AbstractElementValidator {
    private static final DataSetRequiredValidator instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static DataSetRequiredValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof ListingElement) && !(element instanceof ExtendedItem)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, element);
    }

    private List doValidate(Module module, DesignElement toValidate) {
        ArrayList<SemanticError> list = new ArrayList<SemanticError>();
        DesignElement container = toValidate;
        int slot = toValidate.getContainerSlot();
        boolean dataSetFound = false;
        if (toValidate instanceof ExtendedItem) {
            if (((ExtendedItem)toValidate).getDataSetElement(module) != null) {
                dataSetFound = true;
            } else {
                while (container.getContainer() != null) {
                    slot = container.getContainerSlot();
                    container = container.getContainer();
                }
            }
        } else if (toValidate instanceof ListingElement) {
            while (container.getContainer() != null && !dataSetFound) {
                if (container instanceof ListingElement && ((ListingElement)container).getDataSetElement(module) != null) {
                    dataSetFound = true;
                    break;
                }
                slot = container.getContainerSlot();
                container = container.getContainer();
            }
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        if (!dataSetFound && 5 != slot) {
            list.add(new SemanticError(toValidate, "Error.SemanticError.MISSING_DATA_SET"));
        }
        return list;
    }

    static {
        $assertionsDisabled = !DataSetRequiredValidator.class.desiredAssertionStatus();
        instance = new DataSetRequiredValidator();
    }
}

