/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.ExtensionLoader;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.SimpleEncryptionHelper;

public class EncryptionHelperExtensionLoader
extends ExtensionLoader {
    public static final String EXTENSION_POINT = "org.eclipse.birt.report.model.encryptionHelper";
    private static final String ENCRYPTION_HELPER_TAG = "encryptionHelper";

    public EncryptionHelperExtensionLoader() {
        super(EXTENSION_POINT);
    }

    void loadExtension(IExtension extension) throws ExtensionException, MetaDataException {
        IConfigurationElement[] configElements = extension.getConfigurationElements();
        EncryptionHelperElementLoader loader = new EncryptionHelperElementLoader();
        for (int i = 0; i < configElements.length; ++i) {
            IConfigurationElement currentTag = configElements[i];
            if (!ENCRYPTION_HELPER_TAG.equals(currentTag.getName())) continue;
            loader.loadElement(currentTag);
        }
    }

    protected void logExtenstionException(ExtensionException e) {
        if (Platform.runningEclipse()) {
            super.logExtenstionException(e);
        }
    }

    class EncryptionHelperElementLoader {
        private static final String EXTENSION_NAME_ATTRIB = "extensionName";
        private static final String CLASS_ATTRIB = "class";

        EncryptionHelperElementLoader() {
        }

        public void loadElement(IConfigurationElement elementTag) throws ExtensionException {
            String extensionName = elementTag.getAttribute(EXTENSION_NAME_ATTRIB);
            String className = elementTag.getAttribute(CLASS_ATTRIB);
            this.checkRequiredAttribute(EXTENSION_NAME_ATTRIB, extensionName);
            this.checkRequiredAttribute(CLASS_ATTRIB, className);
            try {
                IEncryptionHelper helper = (IEncryptionHelper)elementTag.createExecutableExtension(CLASS_ATTRIB);
                IEncryptionHelper registeredHelper = MetaDataDictionary.getInstance().getEncryptionHelper();
                if (registeredHelper != SimpleEncryptionHelper.getInstance()) {
                    throw new ExtensionException(new String[]{className}, "ENCYRPTION_EXTENSION_EXISTS");
                }
                MetaDataDictionary.getInstance().setEncryptionHelper(helper);
            }
            catch (FrameworkException e) {
                throw new ExtensionException(new String[]{className}, "FAILED_TO_CREATE_INSTANCE");
            }
        }

        void checkRequiredAttribute(String name, String value) throws ExtensionException {
            if (StringUtil.isBlank(value)) {
                throw new ExtensionException(new String[]{name}, "VALUE_REQUIRED");
            }
        }
    }
}

