/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.security.cert.X509Certificate;
import org.eclipse.aperi.connector.internal.InternalConstants;
import org.eclipse.aperi.connector.internal.server.BiModalSocketListener;
import org.eclipse.aperi.connector.internal.ssl.SSLManager;
import org.eclipse.aperi.connector.log.LogHelper;
import org.mortbay.http.HttpConnection;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.jetty.servlet.ServletSSL;
import org.mortbay.util.InetAddrPort;

public class BiModalSSLSocketListener
extends BiModalSocketListener
implements InternalConstants {
    static final long serialVersionUID = 298789788L;
    static final String CACHED_INFO_ATTR;
    private String[] cipherSuites = null;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.aperi.connector.internal.server.BiModalSSLSocketListener$CachedInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        CACHED_INFO_ATTR = clazz.getName();
    }

    public BiModalSSLSocketListener() {
        this.setDefaultScheme("https://");
    }

    public boolean isIntegral(HttpConnection httpConnection) {
        int n = this.getIntegralPort();
        return n == 0 || n == this.getPort();
    }

    public boolean isConfidential(HttpConnection httpConnection) {
        int n = this.getConfidentialPort();
        return n == 0 || n == this.getPort();
    }

    protected void customizeRequest(Socket socket, HttpRequest httpRequest) {
        super.customizeRequest(socket, httpRequest);
        if (!(socket instanceof SSLSocket)) {
            return;
        }
        try {
            java.security.cert.X509Certificate[] x509CertificateArray;
            Integer n;
            SSLSocket sSLSocket = (SSLSocket)socket;
            SSLSession sSLSession = sSLSocket.getSession();
            String string = sSLSession.getCipherSuite();
            CachedInfo cachedInfo = (CachedInfo)sSLSession.getValue(CACHED_INFO_ATTR);
            if (cachedInfo != null) {
                n = cachedInfo.getKeySize();
                x509CertificateArray = cachedInfo.getCerts();
            } else {
                n = new Integer(ServletSSL.deduceKeyLength((String)string));
                x509CertificateArray = BiModalSSLSocketListener.getCertChain(sSLSession);
                cachedInfo = new CachedInfo(n, x509CertificateArray);
                sSLSession.putValue(CACHED_INFO_ATTR, cachedInfo);
            }
            if (x509CertificateArray == null) {
                throw new HttpException(403);
            }
            httpRequest.setAttribute("javax.servlet.request.X509Certificate", (Object)x509CertificateArray);
            httpRequest.setAttribute("javax.servlet.request.cipher_suite", (Object)string);
            httpRequest.setAttribute("javax.servlet.request.key_size", (Object)n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected SSLServerSocketFactory createFactory() throws Exception {
        return SSLManager.getSSLServerSocketFactory();
    }

    protected ServerSocket newServerSocket(InetAddrPort inetAddrPort, int n) throws IOException {
        SSLServerSocketFactory sSLServerSocketFactory = null;
        SSLServerSocket sSLServerSocket = null;
        try {
            sSLServerSocketFactory = this.createFactory();
            sSLServerSocket = inetAddrPort == null ? (SSLServerSocket)sSLServerSocketFactory.createServerSocket(0, n) : (SSLServerSocket)sSLServerSocketFactory.createServerSocket(inetAddrPort.getPort(), n, inetAddrPort.getInetAddress());
            sSLServerSocket.setNeedClientAuth(true);
            if (this.cipherSuites != null && this.cipherSuites.length > 0) {
                sSLServerSocket.setEnabledCipherSuites(this.cipherSuites);
                int n2 = 0;
                while (n2 < this.cipherSuites.length) {
                    LogHelper.trace("SslListener enabled ciphersuite: " + this.cipherSuites[n2], this.getClass(), "newServerSocket");
                    ++n2;
                }
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            LogHelper.trace("Could not create JSSE Listener", this.getClass(), "newServerSocket");
            throw new IOException(exception.toString());
        }
        return sSLServerSocket;
    }

    protected Socket accept(ServerSocket serverSocket) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)serverSocket.accept();
        if (this.getMaxIdleTimeMs() > 0) {
            sSLSocket.setSoTimeout(this.getMaxIdleTimeMs());
        }
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    private static java.security.cert.X509Certificate[] getCertChain(SSLSession sSLSession) {
        X509Certificate[] x509CertificateArray;
        java.security.cert.X509Certificate[] x509CertificateArray2;
        block6: {
            x509CertificateArray2 = null;
            x509CertificateArray = sSLSession.getPeerCertificateChain();
            if (x509CertificateArray != null && x509CertificateArray.length != 0) break block6;
            return null;
        }
        try {
            int n = x509CertificateArray.length;
            x509CertificateArray2 = new java.security.cert.X509Certificate[n];
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            int n2 = 0;
            while (n2 < n) {
                byte[] byArray = x509CertificateArray[n2].getEncoded();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                x509CertificateArray2[n2] = (java.security.cert.X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                ++n2;
            }
            return x509CertificateArray2;
        }
        catch (Exception exception) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.aperi.connector.internal.server.BiModalSSLSocketListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            LogHelper.logException(exception, clazz, "getCertChain");
            return x509CertificateArray2;
        }
    }

    private class CachedInfo {
        private Integer keySize;
        private java.security.cert.X509Certificate[] certs;

        Integer getKeySize() {
            return this.keySize;
        }

        java.security.cert.X509Certificate[] getCerts() {
            return this.certs;
        }

        CachedInfo(Integer n, java.security.cert.X509Certificate[] x509CertificateArray) {
            this.keySize = n;
            this.certs = x509CertificateArray;
        }
    }
}

