/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.connector.internal.ssl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import org.eclipse.aperi.connector.Config;
import org.eclipse.aperi.connector.IKeyStoreMgr;
import org.eclipse.aperi.connector.log.LogHelper;

public class KeyStoreMgr
implements IKeyStoreMgr {
    private KeyStore keystore = null;
    private String keystorePWD = null;
    private static IKeyStoreMgr instance = null;

    public static IKeyStoreMgr getIKeyStoreMgr() {
        if (instance == null) {
            String string = Config.getProperty("connector.ssl.keystore.mgr.impl");
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName(string);
                    instance = (IKeyStoreMgr)clazz.newInstance();
                }
                catch (Exception exception) {
                    Class<?> clazz;
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.aperi.connector.IKeyStoreMgr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    LogHelper.log("CNT025W", clazz2, "getIKeyStoreMgr", string);
                    try {
                        clazz = Class.forName("org.eclipse.aperi.connector.IKeyStoreMgr");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    LogHelper.logException(exception, clazz, "getIKeyStoreMgr");
                }
            }
            if (instance == null) {
                instance = new KeyStoreMgr();
            }
        }
        return instance;
    }

    private KeyStoreMgr() {
    }

    public KeyStore getKeyStore() throws KeyStoreException {
        if (this.keystore == null) {
            this.keystore = KeyStore.getInstance("JKS");
            String string = Config.getProperty("connector.ssl.keystore");
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Class<?> clazz;
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                LogHelper.log("CNT022W", clazz2, "getKeystore", string);
                try {
                    clazz = Class.forName("org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                inputStream = clazz.getResourceAsStream("/org/eclipse/aperi/connector/internal/ssl/defaultKeystore.jks");
            }
            try {
                this.keystore.load(inputStream, this.getPassword());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Class<?> clazz;
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                LogHelper.log("CNT023E", clazz3, "getKeyStore", this.keystore.getProvider().getName());
                try {
                    clazz = Class.forName("org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                LogHelper.logException(noSuchAlgorithmException, clazz, "getKeyStore");
                throw new KeyStoreException(noSuchAlgorithmException);
            }
            catch (IOException iOException) {
                Class<?> clazz;
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                LogHelper.log("CNT024E", clazz4, "getKeyStore");
                try {
                    clazz = Class.forName("org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                LogHelper.logException(iOException, clazz, "getKeyStore");
                throw new KeyStoreException(iOException);
            }
            catch (Exception exception) {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.aperi.connector.internal.ssl.KeyStoreMgr");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                LogHelper.traceException(exception, clazz, "getKeyStore");
                throw new KeyStoreException(exception);
            }
        }
        return this.keystore;
    }

    public char[] getPassword() {
        if (this.keystorePWD == null) {
            this.keystorePWD = Config.getProperty("connector.ssl.keystorepassword");
        }
        return this.keystorePWD.toCharArray();
    }
}

