/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.report.data.adapter.impl.ModelAdapter;
import org.eclipse.birt.report.data.adapter.impl.ResultMetaData2;
import org.eclipse.birt.report.data.adapter.impl.ResultSetColumnDefinition;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.JointDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.ResultSetColumn;

public class MetaDataPopulator {
    private static final char RENAME_SEPARATOR = '_';
    private static final String UNNAME_PREFIX = "UNNAMED";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static IResultMetaData retrieveResultMetaData(DataSetHandle dataSetHandle) throws BirtException {
        List resultSetList = null;
        if (dataSetHandle instanceof OdaDataSetHandle) {
            resultSetList = (List)dataSetHandle.getProperty("resultSet");
        } else if (dataSetHandle instanceof ScriptDataSetHandle) {
            resultSetList = dataSetHandle.getListProperty("resultSetHints");
        } else {
            return null;
        }
        List computedList = (List)dataSetHandle.getProperty("computedColumns");
        ArrayList<ResultSetColumnDefinition> columnMeta = new ArrayList<ResultSetColumnDefinition>();
        int count = 0;
        if (resultSetList != null) {
            ResultSetColumnDefinition columnDef;
            int n;
            HashSet<String> orgColumnNameSet = new HashSet<String>();
            HashSet<String> uniqueColumnNameSet = new HashSet<String>();
            for (n = 0; n < resultSetList.size(); ++n) {
                orgColumnNameSet.add(((ResultSetColumn)resultSetList.get(n)).getColumnName());
            }
            for (int i = 0; i < resultSetList.size(); ++i) {
                ResultSetColumn resultSetColumn = (ResultSetColumn)resultSetList.get(i);
                String columnName = resultSetColumn.getColumnName();
                String uniqueColumnName = MetaDataPopulator.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, columnName, i);
                uniqueColumnNameSet.add(uniqueColumnName);
                if (!uniqueColumnName.equals(columnName)) {
                    MetaDataPopulator.updateModelColumn(dataSetHandle, uniqueColumnName, i + 1);
                }
                columnDef = new ResultSetColumnDefinition(uniqueColumnName);
                columnDef.setDataTypeName(resultSetColumn.getDataType());
                columnDef.setDataType(ModelAdapter.adaptModelDataType(resultSetColumn.getDataType()));
                if (resultSetColumn.getPosition() != null) {
                    columnDef.setColumnPosition(resultSetColumn.getPosition());
                }
                if (resultSetColumn.getNativeDataType() != null) {
                    columnDef.setNativeDataType(resultSetColumn.getNativeDataType());
                }
                if (MetaDataPopulator.findColumnHint(dataSetHandle, uniqueColumnName) != null) {
                    ColumnHintHandle columnHint = MetaDataPopulator.findColumnHint(dataSetHandle, uniqueColumnName);
                    columnDef.setAlias(columnHint.getAlias());
                    columnDef.setLableName(columnHint.getDisplayName());
                }
                columnDef.setComputedColumn(false);
                columnMeta.add(columnDef);
            }
            count += resultSetList.size();
            if (computedList != null) {
                for (n = 0; n < computedList.size(); ++n) {
                    orgColumnNameSet.add(((ComputedColumn)computedList.get(n)).getName());
                }
                for (int i = 0; i < computedList.size(); ++i) {
                    ComputedColumn computedColumn = (ComputedColumn)computedList.get(i);
                    String columnName = computedColumn.getName();
                    String uniqueColumnName = MetaDataPopulator.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, columnName, i + count);
                    uniqueColumnNameSet.add(uniqueColumnName);
                    if (!uniqueColumnName.equals(columnName)) {
                        MetaDataPopulator.updateComputedColumn(dataSetHandle, uniqueColumnName, columnName);
                    }
                    columnDef = new ResultSetColumnDefinition(uniqueColumnName);
                    columnDef.setDataTypeName(computedColumn.getDataType());
                    columnDef.setDataType(ModelAdapter.adaptModelDataType(computedColumn.getDataType()));
                    if (MetaDataPopulator.findColumnHint(dataSetHandle, uniqueColumnName) != null) {
                        ColumnHintHandle columnHint = MetaDataPopulator.findColumnHint(dataSetHandle, uniqueColumnName);
                        columnDef.setAlias(columnHint.getAlias());
                        columnDef.setLableName(columnHint.getDisplayName());
                    }
                    columnDef.setComputedColumn(true);
                    columnMeta.add(columnDef);
                }
            }
            return new ResultMetaData2(columnMeta);
        }
        return null;
    }

    private static ColumnHintHandle findColumnHint(DataSetHandle dataSetHandle, String columnName) {
        Iterator columnHintIter = dataSetHandle.columnHintsIterator();
        if (columnHintIter != null) {
            while (columnHintIter.hasNext()) {
                ColumnHintHandle modelColumnHint = (ColumnHintHandle)columnHintIter.next();
                if (!modelColumnHint.getColumnName().equals(columnName)) continue;
                return modelColumnHint;
            }
        }
        return null;
    }

    public static boolean needsUseResultHint(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        boolean hasResultSetHint = false;
        boolean hasColumnHint = false;
        PropertyHandle handle = dataSetHandle.getPropertyHandle("columnHints");
        if (handle != null) {
            hasColumnHint = handle.iterator().hasNext();
        }
        if (!(hasResultSetHint = MetaDataPopulator.populateResultsetHint(dataSetHandle, metaData))) {
            hasResultSetHint = MetaDataPopulator.checkHandleType(dataSetHandle);
        }
        return hasResultSetHint || hasColumnHint;
    }

    private static boolean populateResultsetHint(DataSetHandle dataSetHandle, IResultMetaData metaData) throws BirtException {
        boolean hasResultSetHint = false;
        int columnCount = 0;
        HashSet<String> orgColumnNameSet = new HashSet<String>();
        HashSet<String> uniqueColumnNameSet = new HashSet<String>();
        if (metaData != null) {
            columnCount = metaData.getColumnCount();
            for (int n = 0; n < columnCount; ++n) {
                orgColumnNameSet.add(metaData.getColumnName(n + 1));
            }
        }
        for (int i = 0; i < columnCount; ++i) {
            String columnName = metaData.getColumnName(i + 1);
            String uniqueColumnName = MetaDataPopulator.getUniqueName(orgColumnNameSet, uniqueColumnNameSet, columnName, i);
            uniqueColumnNameSet.add(uniqueColumnName);
            if (uniqueColumnName.equals(columnName)) continue;
            MetaDataPopulator.updateModelColumn(dataSetHandle, uniqueColumnName, i + 1);
            if (hasResultSetHint) continue;
            hasResultSetHint = true;
        }
        return hasResultSetHint;
    }

    private static String getUniqueName(HashSet orgColumnNameSet, HashSet newColumnNameSet, String columnName, int index) {
        String newColumnName;
        if (columnName == null || columnName.trim().length() == 0 || newColumnNameSet.contains(columnName)) {
            newColumnName = columnName == null || columnName.trim().length() == 0 ? "UNNAMED_" + String.valueOf(index + 1) : columnName + '_' + String.valueOf(index + 1);
            int i = 1;
            while (orgColumnNameSet.contains(newColumnName) || newColumnNameSet.contains(newColumnName)) {
                newColumnName = newColumnName + String.valueOf('_') + i;
                ++i;
            }
        } else {
            newColumnName = columnName;
        }
        return newColumnName;
    }

    private static boolean checkHandleType(DataSetHandle dataSetHandle) {
        if (dataSetHandle instanceof ScriptDataSetHandle) {
            return true;
        }
        if (dataSetHandle instanceof JointDataSetHandle) {
            List dataSets = ((JointDataSetHandle)dataSetHandle).getDataSetNames();
            for (int i = 0; i < dataSets.size(); ++i) {
                DataSetHandle dsHandle = ((JointDataSetHandle)dataSetHandle).getModuleHandle().findDataSet(dataSets.get(i).toString());
                if (dsHandle != null && dsHandle instanceof ScriptDataSetHandle) {
                    return true;
                }
                if (!(dsHandle instanceof JointDataSetHandle) || !MetaDataPopulator.checkHandleType(dsHandle)) continue;
                return true;
            }
        }
        return false;
    }

    private static void updateModelColumn(DataSetHandle ds, String uniqueColumnName, int index) throws BirtException {
        PropertyHandle resultSetColumns = ds.getPropertyHandle("resultSet");
        if (resultSetColumns == null) {
            return;
        }
        Iterator iterator = resultSetColumns.iterator();
        while (iterator.hasNext()) {
            ResultSetColumnHandle rsColumnHandle = (ResultSetColumnHandle)iterator.next();
            if (!$assertionsDisabled && rsColumnHandle.getPosition() == null) {
                throw new AssertionError();
            }
            if (rsColumnHandle.getPosition() != index) continue;
            if (rsColumnHandle.getColumnName() == null || rsColumnHandle.getColumnName().equals(uniqueColumnName)) break;
            rsColumnHandle.setColumnName(uniqueColumnName);
            break;
        }
    }

    private static void updateComputedColumn(DataSetHandle ds, String uniqueColumnName, String originalName) throws BirtException {
        PropertyHandle computedColumn = ds.getPropertyHandle("computedColumns");
        if (computedColumn == null) {
            return;
        }
        Iterator iterator = computedColumn.iterator();
        while (iterator.hasNext()) {
            ComputedColumnHandle compColumnHandle = (ComputedColumnHandle)iterator.next();
            if (compColumnHandle.getName() == null || !compColumnHandle.getName().equals(originalName)) continue;
            compColumnHandle.setName(uniqueColumnName);
        }
    }

    static {
        $assertionsDisabled = !MetaDataPopulator.class.desiredAssertionStatus();
    }
}

