/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.api.impl.ResultSetItem;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteDataEngine;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.mozilla.javascript.Scriptable;

public class DataExtractionTask
extends EngineTask
implements IDataExtractionTask {
    protected IReportDocument reportDocReader;
    protected Report report;
    protected InstanceID instanceId;
    protected String resultSetName;
    protected String[] selectedColumns;
    protected IExtractionResults currentResult = null;
    protected IFilterDefinition[] filterExpressions = null;
    protected boolean isMetaDataPrepared = false;
    protected HashMap rsetName2IdMapping = new HashMap();
    protected HashMap rsetId2queryIdMapping = new HashMap();
    protected HashMap queryId2NameMapping = new HashMap();
    protected HashMap queryId2QueryMapping = new HashMap();
    protected ArrayList resultMetaList = new ArrayList();
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    public DataExtractionTask(IReportEngine engine, IReportRunnable runnable, IReportDocument reader) throws EngineException {
        super(engine, runnable);
        this.report = ((ReportRunnable)runnable).getReportIR();
        this.reportDocReader = reader;
        this.executionContext.setReportDocument(this.reportDocReader);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        dataEngine.prepare(this.report, this.appContext);
    }

    private void prepareMetaData() {
        if (this.isMetaDataPrepared) {
            return;
        }
        HashMap queryIds = this.report.getQueryIDs();
        HashMap query2itemMapping = this.report.getReportItemToQueryMap();
        Iterator iter = queryIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IBaseQueryDefinition baseQuery = (IBaseQueryDefinition)entry.getKey();
            if (!(baseQuery instanceof IQueryDefinition)) continue;
            IQueryDefinition query = (IQueryDefinition)baseQuery;
            String queryId = (String)entry.getValue();
            ReportItemDesign item = (ReportItemDesign)query2itemMapping.get(query);
            String queryName = item.getName();
            if (queryName == null) {
                queryName = "ELEMENT_" + item.getID();
            }
            this.queryId2NameMapping.put(queryId, queryName);
            this.queryId2QueryMapping.put(queryId, query);
        }
        try {
            this.loadResultSetMetaData();
        }
        catch (EngineException e) {
            e.printStackTrace();
        }
        this.isMetaDataPrepared = true;
    }

    private String getQueryName(String queryId) {
        return (String)this.queryId2NameMapping.get(queryId);
    }

    private IQueryDefinition getQuery(String queryId) {
        return (IQueryDefinition)this.queryId2QueryMapping.get(queryId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadResultSetMetaData() throws EngineException {
        FilterInputStream dis = null;
        try {
            try {
                HashMap query2ResultMetaData = this.report.getResultMetaData();
                IDocArchiveReader reader = this.reportDocReader.getArchive();
                dis = new DataInputStream((InputStream)reader.getStream("/Data/hierarchy"));
                HashMap<String, Integer> queryCounts = new HashMap<String, Integer>();
                while (true) {
                    ResultMetaData metaData;
                    IOUtil.readString((DataInputStream)dis);
                    IOUtil.readLong((DataInputStream)dis);
                    String queryId = IOUtil.readString((DataInputStream)dis);
                    String rsetId = IOUtil.readString((DataInputStream)dis);
                    IQueryDefinition query = this.getQuery(queryId);
                    if (!this.isMasterQuery(query)) continue;
                    this.rsetId2queryIdMapping.put(rsetId, queryId);
                    int count = -1;
                    Integer countObj = (Integer)queryCounts.get(queryId);
                    if (countObj != null) {
                        count = countObj;
                    }
                    String rsetName = this.getQueryName(queryId);
                    if (++count > 0) {
                        rsetName = rsetName + "_" + count;
                    }
                    queryCounts.put(queryId, new Integer(count));
                    this.rsetName2IdMapping.put(rsetName, rsetId);
                    if (null == query2ResultMetaData || (metaData = (ResultMetaData)query2ResultMetaData.get(query)).getColumnCount() <= 0) continue;
                    ResultSetItem resultItem = new ResultSetItem(rsetName, metaData);
                    this.resultMetaList.add(resultItem);
                }
            }
            catch (EOFException eofe) {
                Object var14_15 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {}
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, ioe.getMessage(), ioe);
                Object var14_16 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    private boolean isMasterQuery(IQueryDefinition query) {
        if (query.getDataSetName() == null) {
            return false;
        }
        for (IBaseQueryDefinition parent = query.getParentQuery(); parent != null; parent = parent.getParentQuery()) {
            if (parent instanceof IQueryDefinition) {
                IQueryDefinition parentQuery = (IQueryDefinition)parent;
                if (parentQuery.getDataSetName() == null) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    protected String instanceId2RsetName(InstanceID iid) {
        String rsetId;
        DataSetID dataSetId;
        DataID dataId = iid.getDataID();
        if (dataId != null && (dataSetId = dataId.getDataSetID()) != null && (rsetId = dataSetId.getDataSetName()) != null) {
            return this.rsetId2Name(rsetId);
        }
        return null;
    }

    protected String queryId2rsetId(String id) {
        Iterator iter = this.rsetId2queryIdMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String queryId = (String)entry.getValue();
            String rsetId = (String)entry.getKey();
            if (!queryId.equals(id)) continue;
            return rsetId;
        }
        return null;
    }

    protected String rsetId2Name(String id) {
        Iterator iter = this.rsetName2IdMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String rsetId = (String)entry.getValue();
            String rsetName = (String)entry.getKey();
            if (!rsetId.equals(id)) continue;
            return rsetName;
        }
        return null;
    }

    protected String rsetName2Id(String name) {
        return (String)this.rsetName2IdMapping.get(name);
    }

    public void setInstanceID(InstanceID iid) {
        if (!$assertionsDisabled && iid == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        this.instanceId = iid;
        this.resultSetName = null;
        this.selectedColumns = null;
    }

    public void selectResultSet(String displayName) {
        if (!$assertionsDisabled && displayName == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        if (displayName.startsWith("InstanceId:")) {
            this.resultSetName = null;
            this.instanceId = InstanceID.parse(displayName.substring(11));
        } else {
            this.resultSetName = displayName;
            this.instanceId = null;
        }
        this.selectedColumns = null;
    }

    public List getMetaData() throws EngineException {
        return this.getResultSetList();
    }

    public List getResultSetList() throws EngineException {
        this.prepareMetaData();
        if (this.instanceId != null) {
            ArrayList<ResultSetItem> rsetList = new ArrayList<ResultSetItem>();
            String rsetName = this.instanceId2RsetName(this.instanceId);
            if (rsetName != null) {
                IResultMetaData metaData = this.getResultMetaData(rsetName);
                if (metaData != null) {
                    rsetList.add(new ResultSetItem(rsetName, metaData));
                }
            } else {
                IResultMetaData metaData = this.getMetaDateByInstanceID(this.instanceId);
                if (metaData != null) {
                    rsetList.add(new ResultSetItem("InstanceId:" + this.instanceId, metaData));
                }
            }
            return rsetList;
        }
        return this.resultMetaList;
    }

    protected IResultMetaData getResultMetaData(String rsetName) {
        Iterator iter = this.resultMetaList.iterator();
        while (iter.hasNext()) {
            IResultSetItem rsetItem = (IResultSetItem)iter.next();
            if (!rsetItem.getResultSetName().equals(rsetName)) continue;
            return rsetItem.getResultMetaData();
        }
        return null;
    }

    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    public IExtractionResults extract() throws EngineException {
        String rsetName = this.resultSetName;
        if (rsetName == null && this.instanceId != null) {
            rsetName = this.instanceId2RsetName(this.instanceId);
        }
        if (rsetName != null) {
            return this.extractByResultSetName(rsetName);
        }
        if (this.instanceId != null) {
            return this.extractByInstanceID(this.instanceId);
        }
        return null;
    }

    private IExtractionResults extractByResultSetName(String rsetName) throws EngineException {
        if (!$assertionsDisabled && rsetName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.executionContext.getDataEngine() == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        DataEngine dataEngine = this.executionContext.getDataEngine().getDataEngine();
        try {
            String rsetId = this.rsetName2Id(rsetName);
            if (rsetId != null) {
                IResultMetaData metaData;
                IQueryResults results = null;
                if (null == this.filterExpressions) {
                    results = dataEngine.getQueryResults(rsetId);
                } else {
                    String queryId = (String)this.rsetId2queryIdMapping.get(rsetId);
                    QueryDefinition query = (QueryDefinition)this.getQuery(queryId);
                    QueryDefinition newQuery = this.queryCopy(query);
                    if (null == newQuery) {
                        return null;
                    }
                    for (int iNum = 0; iNum < this.filterExpressions.length; ++iNum) {
                        newQuery.getFilters().add(this.filterExpressions[iNum]);
                    }
                    this.filterExpressions = null;
                    newQuery.setQueryResultsID(rsetId);
                    Scriptable scope = this.executionContext.getSharedScope();
                    IPreparedQuery preparedQuery = dataEngine.prepare((IQueryDefinition)newQuery);
                    results = preparedQuery.execute(scope);
                }
                if (null != results && (metaData = this.getResultMetaData(rsetName)) != null) {
                    return new ExtractionResults(results, metaData, this.selectedColumns);
                }
            }
        }
        catch (BirtException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IExtractionResults extractByInstanceID(InstanceID iid) throws EngineException {
        IResultMetaData metaData;
        IBaseQueryDefinition query;
        IResultIterator dataIter;
        block14: {
            IExtractionResults iExtractionResults;
            block15: {
                DataID dataId = iid.getDataID();
                DataSetID dataSetId = dataId.getDataSetID();
                DataEngine dataEngine = this.executionContext.getDataEngine().getDataEngine();
                Scriptable scope = this.executionContext.getSharedScope();
                dataIter = null;
                query = null;
                try {
                    try {
                        if (null == this.filterExpressions) {
                            dataIter = this.getResultSetIterator(dataEngine, dataSetId, scope);
                            break block14;
                        }
                        long id = iid.getComponentID();
                        ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
                        query = design.getQuery();
                        if (null == query) {
                            iExtractionResults = null;
                            Object var19_15 = null;
                            if (null == query) return iExtractionResults;
                            break block15;
                        }
                        for (int iNum = 0; iNum < this.filterExpressions.length; ++iNum) {
                            query.getFilters().add(this.filterExpressions[iNum]);
                        }
                        IBaseQueryDefinition rootQuery = query;
                        while (rootQuery instanceof SubqueryDefinition) {
                            rootQuery = rootQuery.getParentQuery();
                        }
                        QueryDefinition newRootQuery = this.queryCopy((QueryDefinition)rootQuery);
                        HashMap queryIds = this.report.getQueryIDs();
                        String queryId = (String)queryIds.get(rootQuery);
                        String rsetId = this.queryId2rsetId(queryId);
                        newRootQuery.setQueryResultsID(rsetId);
                        IPreparedQuery preparedQuery = dataEngine.prepare((IQueryDefinition)newRootQuery);
                        IQueryResults rootResults = preparedQuery.execute(scope);
                        dataIter = this.getFilterResultSetIterator(dataEngine, dataSetId, scope, rootResults);
                        break block14;
                    }
                    catch (BirtException e) {
                        e.printStackTrace();
                        throw new EngineException("Export date by Instance Id failed!", e);
                    }
                }
                catch (Throwable throwable) {
                    Object var19_17 = null;
                    if (null != query) {
                        for (int iNum = 0; iNum < this.filterExpressions.length; ++iNum) {
                            query.getFilters().remove(this.filterExpressions[iNum]);
                        }
                        this.filterExpressions = null;
                    }
                    throw throwable;
                }
            }
            for (int iNum = 0; iNum < this.filterExpressions.length; ++iNum) {
                query.getFilters().remove(this.filterExpressions[iNum]);
            }
            this.filterExpressions = null;
            return iExtractionResults;
        }
        Object var19_16 = null;
        if (null != query) {
            for (int iNum = 0; iNum < this.filterExpressions.length; ++iNum) {
                query.getFilters().remove(this.filterExpressions[iNum]);
            }
            this.filterExpressions = null;
        }
        if (null != (metaData = this.getMetaDateByInstanceID(iid))) {
            return new ExtractionResults(dataIter, metaData, this.selectedColumns);
        }
        return null;
    }

    private IResultMetaData getMetaDateByInstanceID(InstanceID iid) {
        ResultMetaData metaData = null;
        long id = iid.getComponentID();
        ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
        IBaseQueryDefinition query = design.getQuery();
        if (null == query) {
            return null;
        }
        HashMap query2ResultMetaData = this.report.getResultMetaData();
        if (null != query2ResultMetaData) {
            metaData = (ResultMetaData)query2ResultMetaData.get(query);
        }
        return metaData;
    }

    private IResultIterator getResultSetIterator(DataEngine dataEngine, DataSetID dataSet, Scriptable scope) throws BirtException {
        DataSetID parent = dataSet.getParentID();
        if (parent == null) {
            String rsetName = dataSet.getDataSetName();
            if (!$assertionsDisabled && rsetName == null) {
                throw new AssertionError();
            }
            IQueryResults rset = dataEngine.getQueryResults(rsetName);
            return rset.getResultIterator();
        }
        IResultIterator iter = this.getResultSetIterator(dataEngine, parent, scope);
        long rowId = dataSet.getRowID();
        String queryName = dataSet.getQueryName();
        if (!$assertionsDisabled && rowId == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryName == null) {
            throw new AssertionError();
        }
        iter.moveTo((int)rowId);
        return iter.getSecondaryIterator(queryName, scope);
    }

    private IResultIterator getFilterResultSetIterator(DataEngine dataEngine, DataSetID dataSet, Scriptable scope, IQueryResults rset) throws BirtException {
        DataSetID parent = dataSet.getParentID();
        if (parent == null) {
            return rset.getResultIterator();
        }
        IResultIterator iter = this.getFilterResultSetIterator(dataEngine, parent, scope, rset);
        long rowId = dataSet.getRowID();
        String queryName = dataSet.getQueryName();
        if (!$assertionsDisabled && rowId == -1L) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryName == null) {
            throw new AssertionError();
        }
        iter.moveTo((int)rowId);
        return iter.getSecondaryIterator(queryName, scope);
    }

    private QueryDefinition queryCopy(QueryDefinition query) {
        if (null == query) {
            return null;
        }
        QueryDefinition newQuery = new QueryDefinition((BaseQueryDefinition)query.getParentQuery());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getSubqueries().addAll(query.getSubqueries());
        newQuery.getResultSetExpressions().putAll(query.getResultSetExpressions());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setMaxRows(query.getMaxRows());
        newQuery.setDataSetName(query.getDataSetName());
        newQuery.setAutoBinding(query.needAutoBinding());
        newQuery.setColumnProjection(query.getColumnProjection());
        return newQuery;
    }

    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }

    static {
        $assertionsDisabled = !DataExtractionTask.class.desiredAssertionStatus();
        logger = Logger.getLogger(DteDataEngine.class.getName());
    }
}

