/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.IOException;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class EngineLogger {
    private static final String BIRT_NAME_SPACE = "org.eclipse.birt";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void startEngineLogging(String directoryName, Level logLevel) {
        Logger logger = Logger.getLogger(BIRT_NAME_SPACE);
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        if (logLevel != null) {
            logger.setLevel(logLevel);
        }
        FileHandler logFileHandler = null;
        try {
            logFileHandler = new FileHandler(EngineLogger.generateUniqueLogFileName(directoryName), true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (logFileHandler != null) {
            logFileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(logFileHandler);
        }
        logger.setUseParentHandlers(false);
    }

    public static void stopEngineLogging() {
        Logger logger = Logger.getLogger(BIRT_NAME_SPACE);
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        Handler[] handlers = logger.getHandlers();
        if (handlers != null && handlers.length > 0) {
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].close();
                logger.removeHandler(handlers[i]);
            }
        }
    }

    public static void changeLogLevel(Level newLevel) {
        Logger logger = Logger.getLogger(BIRT_NAME_SPACE);
        if (!$assertionsDisabled && logger == null) {
            throw new AssertionError();
        }
        if (newLevel != null) {
            logger.setLevel(newLevel);
        }
    }

    private static String generateUniqueLogFileName(String directoryName) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
        String dateTimeString = df.format(new Date());
        if (directoryName == null) {
            directoryName = "";
        } else if (directoryName.length() > 0) {
            directoryName = directoryName + System.getProperty("file.separator");
        }
        return new String(directoryName + "ReportEngine_" + dateTimeString + ".log");
    }

    static {
        $assertionsDisabled = !EngineLogger.class.desiredAssertionStatus();
    }
}

