/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.report.engine.api.IDataIterator;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.impl.DataIterator;

public class ExtractionResults
implements IExtractionResults {
    protected String[] selectedColumns;
    protected IQueryResults queryResults;
    protected IResultMetaData metaData;
    protected IDataIterator iterator;
    protected IResultIterator resultIterator;

    ExtractionResults(IQueryResults queryResults, IResultMetaData metaData, String[] selectedColumns) {
        this.selectedColumns = selectedColumns;
        this.queryResults = queryResults;
        this.metaData = metaData;
    }

    ExtractionResults(IResultIterator resultIterator, IResultMetaData metaData, String[] selectedColumns) {
        this.selectedColumns = selectedColumns;
        this.resultIterator = resultIterator;
        this.metaData = metaData;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        return this.metaData;
    }

    public IDataIterator nextResultIterator() throws BirtException {
        if (this.iterator == null) {
            if (null == this.resultIterator && null != this.queryResults) {
                this.resultIterator = this.queryResults.getResultIterator();
            }
            this.iterator = new DataIterator(this, this.resultIterator, this.selectedColumns);
        }
        return this.iterator;
    }

    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
        this.iterator = null;
    }
}

