/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.IStreamSorter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.impl.ParameterAttribute;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentConstants;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentStreamSorter;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.ir.EngineIRWriter;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.presentation.PageHint;
import org.eclipse.birt.report.engine.toc.TOCBuilder;
import org.eclipse.birt.report.engine.toc.TOCTree;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.util.DocumentUtil;

public class ReportDocumentWriter
implements ReportDocumentConstants {
    private static Logger logger = Logger.getLogger(ReportDocumentWriter.class.getName());
    protected IReportEngine engine;
    private IDocArchiveWriter archive;
    private String designName;
    private HashMap paramters = new HashMap();
    private HashMap globalVariables = new HashMap();
    private int checkpoint = 0;
    private long pageCount = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportDocumentWriter(IReportEngine engine, IDocArchiveWriter archive) {
        this.engine = engine;
        this.archive = archive;
        try {
            archive.initialize();
            Object lock = archive.lock("/core");
            try {
                this.saveCoreStreams();
            }
            finally {
                archive.unlock(lock);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in initializing the archive", e);
        }
    }

    public IDocArchiveWriter getArchive() {
        return this.archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            Object lock = this.archive.lock("/core");
            try {
                this.checkpoint = -1;
                this.saveCoreStreams();
            }
            finally {
                this.archive.unlock(lock);
            }
            this.archive.setStreamSorter((IStreamSorter)new ReportDocumentStreamSorter());
            this.archive.finish();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed in close the archive", e);
        }
    }

    public String getName() {
        return this.archive.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveTOC(TOCTree tocTree) {
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream("/toc");
        DataOutputStream output = new DataOutputStream((OutputStream)out);
        TOCBuilder.write(tocTree, output);
        Object var5_5 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Save TOC failed!", ex);
                ex.printStackTrace();
                Object var5_6 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void savePageHints(ArrayList hints) {
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream("/pages");
        DataOutputStream oo = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
        IOUtil.writeLong((DataOutputStream)oo, (long)hints.size());
        for (int i = 0; i < hints.size(); ++i) {
            PageHint hint = (PageHint)hints.get(i);
            hint.writeObject(oo);
        }
        oo.close();
        Object var7_7 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save the page hints!", ex);
                Object var7_8 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveBookmarks(HashMap bookmarks) {
        if (bookmarks.isEmpty()) {
            return;
        }
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream("/bookmark");
        DataOutputStream oo = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
        IOUtil.writeLong((DataOutputStream)oo, (long)bookmarks.size());
        Iterator iter = bookmarks.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String bookmark = (String)entry.getKey();
            Long pageNumber = (Long)entry.getValue();
            IOUtil.writeString((DataOutputStream)oo, (String)bookmark);
            IOUtil.writeLong((DataOutputStream)oo, (long)pageNumber);
        }
        oo.close();
        Object var9_9 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save the bookmarks!", ex);
                Object var9_10 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveDesign(ReportRunnable runnable) {
        RAOutputStream out;
        block19: {
            block18: {
                out = null;
                ReportDesignHandle design = runnable.getReport();
                out = this.archive.createRandomAccessStream("/design");
                DocumentUtil.serialize((ReportDesignHandle)design, (OutputStream)out);
                this.designName = design.getFileName();
                Object var5_6 = null;
                if (out == null) break block18;
                try {
                    out.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
            }
            out = null;
            {
                break block19;
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Failed to save design!", ex);
                    Object var5_7 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception ex2) {
                            // empty catch block
                        }
                    }
                    out = null;
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                out = null;
                throw throwable;
            }
        }
        Report reportIR = runnable.getReportIR();
        out = this.archive.createRandomAccessStream("/design.ir");
        new EngineIRWriter().write((OutputStream)out, reportIR);
        Object var8_13 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex3) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save design IR!", ex);
                Object var8_14 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex3) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex3) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public void saveParamters(HashMap map) {
        this.paramters = new HashMap();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            ParameterAttribute valueObj = (ParameterAttribute)entry.getValue();
            Object value = valueObj.getValue();
            String display = valueObj.getDisplayText();
            this.paramters.put(key, new Object[]{value, display});
        }
    }

    public void savePersistentObjects(Map map) {
        this.globalVariables = new HashMap();
        this.globalVariables.putAll(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void saveCoreStreams() throws Exception {
        block24: {
            block23: {
                out = null;
                coreStream = null;
                try {
                    out = this.archive.createRandomAccessStream("/core");
                    coreStream = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
                    IOUtil.writeString((DataOutputStream)coreStream, (String)"reportdocument");
                    IOUtil.writeString((DataOutputStream)coreStream, (String)"2.1.0");
                    IOUtil.writeString((DataOutputStream)coreStream, (String)this.designName);
                    IOUtil.writeMap((DataOutputStream)coreStream, (Map)this.paramters);
                    IOUtil.writeMap((DataOutputStream)coreStream, (Map)this.globalVariables);
                    coreStream.flush();
                    var5_3 = null;
                    ** if (out == null) goto lbl-1000
                }
                catch (Throwable var4_11) {
                    var5_5 = null;
                    if (out != null) {
                        try {
                            out.close();
                            out = null;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    throw var4_11;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        out.close();
                        out = null;
                    }
                    catch (Exception ex) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block23;
                    catch (IOException ex) {
                        ReportDocumentWriter.logger.log(Level.SEVERE, "Failed to save the core stream!", ex);
                        var5_4 = null;
                        if (out != null) {
                            try {
                                out.close();
                                out = null;
                            }
                            catch (Exception ex) {}
                        }
                    }
                }
            }
            checkpointStream = null;
            try {
                out = this.archive.createRandomAccessStream("/checkpoint");
                checkpointStream = new DataOutputStream(new BufferedOutputStream((OutputStream)out));
                if (this.checkpoint != -1) {
                    ++this.checkpoint;
                }
                IOUtil.writeInt((OutputStream)checkpointStream, (int)this.checkpoint);
                IOUtil.writeLong((DataOutputStream)checkpointStream, (long)this.pageCount);
                checkpointStream.flush();
                var8_13 = null;
                ** if (out == null) goto lbl-1000
            }
            catch (Throwable var7_19) {
                var8_15 = null;
                if (out != null) {
                    try {
                        out.close();
                        out = null;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                throw var7_19;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    out.close();
                    out = null;
                }
                catch (Exception ex) {}
            }
lbl-1000:
            // 2 sources

            {
                break block24;
                catch (IOException ex) {
                    ReportDocumentWriter.logger.log(Level.SEVERE, "Failed to save the checkpoint stream!", ex);
                    var8_14 = null;
                    if (out != null) {
                        try {
                            out.close();
                            out = null;
                        }
                        catch (Exception ex) {}
                    }
                }
            }
        }
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    public void saveReprotletsBookmarkIndex(Map bookmarkToOffset) {
        this.saveReportletsIndex(bookmarkToOffset, "/reportletBookmarks");
    }

    public void saveReportletsIdIndex(Map idToOffset) {
        this.saveReportletsIndex(idToOffset, "/reportlet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void saveReportletsIndex(Map index, String streamName) {
        RAOutputStream out = null;
        out = this.archive.createRandomAccessStream(streamName);
        DataOutputStream output = new DataOutputStream((OutputStream)out);
        IOUtil.writeLong((DataOutputStream)output, (long)index.size());
        Iterator iter = index.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String instance = (String)entry.getKey();
            Long offset = (Long)entry.getValue();
            IOUtil.writeString((DataOutputStream)output, (String)instance);
            IOUtil.writeLong((DataOutputStream)output, (long)offset);
        }
        output.flush();
        Object var10_10 = null;
        if (out == null) return;
        try {
            out.close();
            return;
        }
        catch (Exception ex2) {}
        return;
        {
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed to save design!", ex);
                Object var10_11 = null;
                if (out == null) return;
                try {
                    out.close();
                    return;
                }
                catch (Exception ex2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (out == null) throw throwable;
            try {
                out.close();
                throw throwable;
            }
            catch (Exception ex2) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

