/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContentVisitor;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.AbstractContent;
import org.eclipse.birt.report.engine.css.dom.CellComputedStyle;
import org.eclipse.birt.report.engine.ir.CellDesign;

public class CellContent
extends AbstractContent
implements ICellContent {
    protected int rowSpan = -1;
    protected int colSpan = -1;
    protected int column = -1;
    protected boolean displayGroupIcon = false;
    protected static final short FIELD_ROW_SPAN = 100;
    protected static final short FIELD_COL_SPAN = 101;
    protected static final short FIELD_COLUMN = 102;
    protected static final short FIELD_START_OF_GROUP = 103;
    protected static final short FIELD_DISPLAY_GROUP_ICON = 104;

    public int getContentType() {
        return 1;
    }

    public CellContent(IReportContent report) {
        super(report);
    }

    public int getRowSpan() {
        if (this.rowSpan == -1 && this.generateBy instanceof CellDesign) {
            return ((CellDesign)this.generateBy).getRowSpan();
        }
        return this.rowSpan;
    }

    public int getColSpan() {
        if (this.colSpan == -1 && this.generateBy instanceof CellDesign) {
            return ((CellDesign)this.generateBy).getColSpan();
        }
        return this.colSpan;
    }

    public int getColumn() {
        if (this.column == -1 && this.generateBy instanceof CellDesign) {
            return ((CellDesign)this.generateBy).getColumn();
        }
        return this.column;
    }

    public int getRow() {
        if (this.parent != null && this.parent instanceof IRowContent) {
            return ((IRowContent)this.parent).getRowID();
        }
        return 0;
    }

    public void setDrop(String drop) {
        if (this.generateBy instanceof CellDesign) {
            ((CellDesign)this.generateBy).setDrop(drop);
        }
    }

    public Object accept(IContentVisitor visitor, Object value) {
        return visitor.visitCell(this, value);
    }

    public void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    public void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public IStyle getComputedStyle() {
        if (this.computedStyle == null) {
            this.computedStyle = new CellComputedStyle(this);
        }
        return this.computedStyle;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        super.writeFields(out);
        if (this.rowSpan != -1) {
            IOUtil.writeShort((OutputStream)out, (short)100);
            IOUtil.writeInt((OutputStream)out, (int)this.rowSpan);
        }
        if (this.colSpan != -1) {
            IOUtil.writeShort((OutputStream)out, (short)101);
            IOUtil.writeInt((OutputStream)out, (int)this.colSpan);
        }
        if (this.column != -1) {
            IOUtil.writeShort((OutputStream)out, (short)102);
            IOUtil.writeInt((OutputStream)out, (int)this.column);
        }
        if (this.displayGroupIcon) {
            IOUtil.writeShort((OutputStream)out, (short)104);
            IOUtil.writeBool((OutputStream)out, (boolean)this.displayGroupIcon);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 100: {
                this.rowSpan = IOUtil.readInt((InputStream)in);
                break;
            }
            case 101: {
                this.colSpan = IOUtil.readInt((InputStream)in);
                break;
            }
            case 102: {
                this.column = IOUtil.readInt((InputStream)in);
                break;
            }
            case 103: {
                IOUtil.readBool((InputStream)in);
                break;
            }
            case 104: {
                this.displayGroupIcon = IOUtil.readBool((InputStream)in);
                break;
            }
            default: {
                super.readField(version, filedId, in);
            }
        }
    }

    public boolean getDisplayGroupIcon() {
        return this.displayGroupIcon;
    }

    public void setDisplayGroupIcon(boolean displayGroupIcon) {
        this.displayGroupIcon = displayGroupIcon;
    }

    public IColumn getColumnInstance() {
        int columnId;
        ITableContent table;
        IColumn column = null;
        IRowContent row = null;
        if (this.parent != null && this.parent instanceof IRowContent) {
            row = (IRowContent)this.parent;
        }
        if (row != null && (table = row.getTable()) != null && (columnId = this.getColumn()) >= 0 && columnId < table.getColumnCount()) {
            column = table.getColumn(columnId);
        }
        return column;
    }
}

