/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.data.dte;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.data.IResultSet;
import org.eclipse.birt.report.engine.data.dte.AbstractDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteResultSet;
import org.eclipse.birt.report.engine.data.dte.ReportQueryBuilder;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.Report;
import org.mozilla.javascript.Scriptable;

public class DataPresentationEngine
extends AbstractDataEngine {
    private IDocArchiveReader reader;
    protected HashMap rsetRelations = new HashMap();
    private StringBuffer keyBuffer = new StringBuffer();

    public DataPresentationEngine(ExecutionContext context, IDocArchiveReader reader) {
        super(context);
        try {
            DataEngineContext dteContext = DataEngineContext.newInstance((int)2, (Scriptable)context.getSharedScope(), (IDocArchiveReader)reader, null);
            dteContext.setLocale(context.getLocale());
            String tempDir = this.getTempDir(context);
            if (tempDir != null) {
                dteContext.setTmpdir(tempDir);
            }
            this.dteEngine = DataEngine.newDataEngine((DataEngineContext)dteContext);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "can't create the DTE data engine", ex);
            ex.printStackTrace();
        }
        this.reader = reader;
    }

    public void prepare(Report report, Map appContext) {
        new ReportQueryBuilder().build(report, this.context);
        this.doPrepareQuery(report, appContext);
    }

    protected void doPrepareQuery(Report report, Map appContext) {
        this.queryIDMap.putAll(report.getQueryIDs());
        this.loadDteMetaInfo();
    }

    private void loadDteMetaInfo() {
        this.loadDteMetaInfo("/Data/hierarchy");
        if (this.reader.exists("/Data/snap_hierarchy")) {
            this.loadDteMetaInfo("/Data/snap_hierarchy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDteMetaInfo(String metaDataStream) {
        DataInputStream dis = null;
        try {
            try {
                dis = new DataInputStream((InputStream)this.reader.getStream(metaDataStream));
                StringBuffer buffer = new StringBuffer();
                while (true) {
                    String pRsetId = IOUtil.readString((DataInputStream)dis);
                    long rowId = IOUtil.readLong((DataInputStream)dis);
                    String queryId = IOUtil.readString((DataInputStream)dis);
                    String rsetId = IOUtil.readString((DataInputStream)dis);
                    buffer.setLength(0);
                    buffer.append(pRsetId);
                    buffer.append(".");
                    buffer.append(rowId);
                    buffer.append(".");
                    buffer.append(queryId);
                    this.rsetRelations.put(buffer.toString(), rsetId);
                }
            }
            catch (EOFException eofe) {
                Object var10_10 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {}
                }
            }
            catch (IOException ioe) {
                this.context.addException(new EngineException("Can't load the data in report document", ioe));
                logger.log(Level.SEVERE, ioe.getMessage(), ioe);
                Object var10_11 = null;
                if (dis != null) {
                    try {
                        dis.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (dis != null) {
                try {
                    dis.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            throw throwable;
        }
    }

    protected String getResultID(String pRsetId, long rowId, String queryId) {
        int charAt;
        this.keyBuffer.setLength(0);
        this.keyBuffer.append(pRsetId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(rowId);
        this.keyBuffer.append(".");
        this.keyBuffer.append(queryId);
        String rsetId = (String)this.rsetRelations.get(this.keyBuffer.toString());
        if (rsetId == null && pRsetId != null && (charAt = pRsetId.indexOf("_")) != -1) {
            String rootId = pRsetId.substring(0, charAt);
            this.keyBuffer.setLength(0);
            this.keyBuffer.append(rootId);
            this.keyBuffer.append(".");
            this.keyBuffer.append(rowId);
            this.keyBuffer.append(".");
            this.keyBuffer.append(queryId);
            rsetId = (String)this.rsetRelations.get(this.keyBuffer.toString());
        }
        return rsetId;
    }

    protected IResultSet doExecuteQuery(DteResultSet parentResult, IQueryDefinition query) {
        String queryID = (String)this.queryIDMap.get(query);
        try {
            IQueryResults queryResults = null;
            if (parentResult != null) {
                queryResults = parentResult.getQueryResults();
            }
            String resultSetID = null;
            if (queryResults == null) {
                if (this.context.isExecutingMasterPage()) {
                    long pageNumber = this.context.getPageNumber();
                    resultSetID = this.getResultID(null, pageNumber, queryID);
                    if (resultSetID == null) {
                        resultSetID = this.getResultID(null, -1L, queryID);
                    }
                } else {
                    resultSetID = this.getResultID(null, -1L, queryID);
                }
            } else {
                String pRsetId = queryResults.getID();
                long rowid = parentResult.getRawID();
                resultSetID = this.getResultID(pRsetId, rowid, queryID);
            }
            if (resultSetID == null) {
                logger.log(Level.SEVERE, "Can't load the report query");
                return null;
            }
            queryResults = this.dteEngine.getQueryResults(resultSetID);
            DteResultSet resultSet = null;
            resultSet = parentResult == null ? new DteResultSet(this, this.context, query, queryResults) : new DteResultSet(parentResult, query, queryResults);
            return resultSet;
        }
        catch (BirtException be) {
            logger.log(Level.SEVERE, be.getMessage());
            this.context.addException(be);
            return null;
        }
    }
}

