/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.executor.doc;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportItemReader;
import org.eclipse.birt.report.engine.internal.executor.doc.ReportReader;

public class ReportletReader
extends ReportReader {
    Fragment reportletFragment = null;

    public ReportletReader(ExecutionContext context, long offset) {
        super(context);
        this.offset = offset;
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemReader reportlet = this.manager.createExecutor(null, this.offset, this.reportletFragment);
            this.offset = -1L;
            return reportlet;
        }
        return null;
    }

    protected void openReaders() throws IOException {
        super.openReaders();
        this.initializeReportlet();
    }

    public boolean hasNextChild() {
        return this.offset != -1L;
    }

    protected void initializeReportlet() throws IOException {
        long[] leftEdge = this.createEdges(this.offset);
        long[] rightEdge = new long[leftEdge.length + 1];
        System.arraycopy(leftEdge, 0, rightEdge, 0, leftEdge.length);
        rightEdge[leftEdge.length] = Long.MAX_VALUE;
        Fragment fragment = new Fragment();
        fragment.addFragment(leftEdge, rightEdge);
        this.reportletFragment = fragment.getNextFragment(-1L);
        this.offset = this.reportletFragment.offset;
    }

    protected long[] createEdges(long offset) throws IOException {
        LinkedList<Long> parents = new LinkedList<Long>();
        for (IContent content = this.reader.loadContent(offset); content != null; content = (IContent)content.getParent()) {
            DocumentExtension ext = (DocumentExtension)content.getExtension(0);
            if (ext == null) continue;
            parents.addFirst(new Long(ext.getIndex()));
        }
        long[] edges = new long[parents.size()];
        Iterator iter = parents.iterator();
        int length = 0;
        while (iter.hasNext()) {
            Long value = (Long)iter.next();
            edges[length++] = value;
        }
        return edges;
    }
}

