/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IGroupContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.IPDFTableLayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.area.impl.TableArea;
import org.eclipse.birt.report.engine.layout.pdf.BorderConflictResolver;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableRegionLM;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValue;

public class PDFTableLM
extends PDFBlockStackingLM
implements IPDFTableLayoutManager,
IBlockStackingLayoutManager {
    protected ArrayList dropList = new ArrayList();
    protected BorderConflictResolver bcr = new BorderConflictResolver();
    private ITableContent tableContent;
    protected boolean repeatHeader;
    protected int columnNumber;
    protected int tableWidth;
    protected CellWrapper[] lastRowContent = null;
    protected CellWrapper[] currentRowContent = null;
    protected RowWrapper lastRow = null;
    protected RowWrapper currentRow = null;
    protected RowArea lastRowArea = null;
    protected IPDFTableLayoutManager.TableLayoutInfo layoutInfo = null;
    protected PDFTableRegionLM regionLM = null;
    protected int currentRowID = 0;
    protected int hiddenRowCount = 0;
    protected ITableBandContent currentBand = null;
    protected int repeatRowCount = 0;
    protected boolean tablepaginated = false;
    protected IPDFTableLayoutManager.ITableCloseState pageBreakState;
    protected final IPDFTableLayoutManager.ITableCloseState FORCED_PAGE_BREAK_STATE = new ForcedPageBreakState();
    protected final IPDFTableLayoutManager.ITableCloseState AUTO_PAGE_BREAK_STATE = new AutoPageBreakState();
    protected final IPDFTableLayoutManager.ITableCloseState TABLE_TERMINATED_STATE = new TableTerminatedState();
    protected Stack groupStack = new Stack();
    protected ColumnWidthResolver columnWidthResolver;
    protected int rowCount = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFTableLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.tableContent = (ITableContent)content;
        this.columnWidthResolver = new ColumnWidthResolver(this.tableContent);
        this.repeatHeader = this.tableContent.isHeaderRepeat();
        this.columnNumber = this.tableContent.getColumnCount();
        this.lastRowContent = new CellWrapper[this.columnNumber];
        this.currentRowContent = new CellWrapper[this.columnNumber];
        this.pageBreakState = this.AUTO_PAGE_BREAK_STATE;
    }

    public int getRepeatCount() {
        return this.repeatRowCount;
    }

    public void setRepeatCount(int repeatRowCount) {
        this.repeatRowCount = repeatRowCount;
    }

    protected boolean traverseChildren() {
        this.repeat();
        return super.traverseChildren();
    }

    protected void repeat() {
        this.addCaption(this.tableContent.getCaption());
        this.repeatHeader();
    }

    public void startGroup(IGroupContent groupContent) {
        int groupLevel = groupContent.getGroupLevel();
        this.groupStack.push(new Integer(groupLevel));
    }

    public void endGroup(IGroupContent groupContent) {
        int groupLevel = groupContent.getGroupLevel();
        this.updateUnresolvedCell(groupLevel, false);
        this.updateUnresolvedCell(groupLevel, true);
        if (!$assertionsDisabled && this.groupStack.isEmpty()) {
            throw new AssertionError();
        }
        this.groupStack.pop();
    }

    private int getGroupLevel() {
        if (!this.groupStack.isEmpty()) {
            return (Integer)this.groupStack.peek();
        }
        return -1;
    }

    public void startRow(IRowContent row) {
        ++this.currentRowID;
        ++this.rowCount;
        CellWrapper[] newRowContent = new CellWrapper[this.columnNumber];
        if (this.currentRowID > 0) {
            ArrayList<Integer> removedDropCells = new ArrayList<Integer>();
            for (int i = 0; i < this.columnNumber; ++i) {
                if (this.currentRowContent[i] == null) continue;
                int rowSpan = this.currentRowContent[i].rowSpan;
                if (rowSpan > 0 && this.currentRowID < rowSpan + this.currentRowContent[i].rowID || rowSpan < 0) {
                    newRowContent[i] = this.currentRowContent[i];
                    continue;
                }
                newRowContent[i] = null;
                removedDropCells.add(new Integer(i));
            }
            if (removedDropCells.size() > 0) {
                this.removeDropCells(removedDropCells);
            }
        }
        this.lastRowContent = this.currentRowContent;
        this.lastRow = this.currentRow;
        this.currentRowContent = newRowContent;
        this.currentRow = new RowWrapper(row, this.currentRowID);
    }

    protected void removeDropCells(ArrayList list) {
        DropCellInfo dropCell;
        int maxHeight = 0;
        Iterator iter = this.dropList.iterator();
        ArrayList<DropCellInfo> removedList = new ArrayList<DropCellInfo>();
        while (iter.hasNext()) {
            dropCell = (DropCellInfo)iter.next();
            int columnID = dropCell.cell.getColumnID();
            if (!list.contains(new Integer(columnID))) continue;
            this.verticalAlign(dropCell.cell);
            iter.remove();
            maxHeight = Math.max(maxHeight, dropCell.leftHeight);
            removedList.add(dropCell);
        }
        iter = this.dropList.iterator();
        while (iter.hasNext()) {
            dropCell = (DropCellInfo)iter.next();
            int left = dropCell.leftHeight;
            dropCell.leftHeight -= maxHeight;
            if (dropCell.leftHeight >= 0) continue;
            dropCell.cell.setHeight(dropCell.cell.getHeight() + maxHeight - left);
            dropCell.leftHeight = 0;
        }
        if (maxHeight > 0) {
            if (this.lastRowArea != null) {
                this.lastRowArea.setHeight(this.lastRowArea.getHeight() + maxHeight);
                Iterator rowIter = this.lastRowArea.getChildren();
                while (rowIter.hasNext()) {
                    CellArea cell = (CellArea)rowIter.next();
                    if (cell.getRowSpan() != 1) continue;
                    cell.setHeight(cell.getHeight() + maxHeight);
                }
            }
            Iterator removedIter = removedList.iterator();
            while (removedIter.hasNext()) {
                DropCellInfo cell = (DropCellInfo)removedIter.next();
                cell.cell.setHeight(cell.cell.getHeight() + maxHeight - cell.leftHeight);
            }
            this.currentBP += maxHeight;
        }
    }

    protected void removeDropAreaBySpan(int rowSpan) {
        int maxHeight = 0;
        Iterator iter = this.dropList.iterator();
        ArrayList<DropCellInfo> removedList = new ArrayList<DropCellInfo>();
        while (iter.hasNext()) {
            DropCellInfo dropCell = (DropCellInfo)iter.next();
            if (dropCell.rowSpan != rowSpan) continue;
            this.verticalAlign(dropCell.cell);
            iter.remove();
            removedList.add(dropCell);
            maxHeight = Math.max(maxHeight, dropCell.leftHeight);
        }
        if (maxHeight > 0) {
            Object cell;
            if (this.lastRowArea != null) {
                this.lastRowArea.setHeight(this.lastRowArea.getHeight() + maxHeight);
                Iterator rowIter = this.lastRowArea.getChildren();
                while (rowIter.hasNext()) {
                    cell = (CellArea)rowIter.next();
                    ((AbstractArea)cell).setHeight(((AbstractArea)cell).getHeight() + maxHeight);
                }
            }
            Iterator removedIter = removedList.iterator();
            while (removedIter.hasNext()) {
                cell = (DropCellInfo)removedIter.next();
                ((DropCellInfo)cell).cell.setHeight(((DropCellInfo)cell).cell.getHeight() + maxHeight - ((DropCellInfo)cell).leftHeight);
            }
            this.currentBP += maxHeight;
        }
    }

    private int createDropID(int groupIndex, String dropType) {
        int dropId = -10 * (groupIndex + 1);
        if ("all".equals(dropType)) {
            --dropId;
        }
        return dropId;
    }

    public void startCell(ICellContent cell) {
        String dropType;
        CellDesign cellDesign;
        int groupLevel = this.getGroupLevel();
        int rowSpan = cell.getRowSpan();
        if (groupLevel >= 0 && (cellDesign = (CellDesign)cell.getGenerateBy()) != null && (dropType = cellDesign.getDrop()) != null && !"none".equals(dropType)) {
            rowSpan = this.createDropID(groupLevel, dropType);
        }
        for (int i = cell.getColumn(); i < cell.getColumn() + cell.getColSpan(); ++i) {
            if (this.currentRowContent[i] != null) continue;
            this.currentRowContent[i] = new CellWrapper(cell, this.currentRowID, rowSpan);
        }
    }

    public boolean isCellVisible(ICellContent cell) {
        if (cell == null) {
            return false;
        }
        return this.currentRowContent[cell.getColumn()].cell == cell;
    }

    protected void createRoot() {
        this.root = AreaFactory.createTableArea((ITableContent)this.content);
        this.root.setWidth(this.tableWidth);
        if (!this.isFirst) {
            this.root.getStyle().setMarginTop("0");
        }
    }

    public IPDFTableLayoutManager.TableLayoutInfo getLayoutInfo() {
        return this.layoutInfo;
    }

    protected void buildTableLayoutInfo() {
        this.layoutInfo = this.resolveTableFixedLayout((TableArea)this.root);
    }

    protected void newContext() {
        this.createRoot();
        this.buildTableLayoutInfo();
        this.root.setWidth(this.layoutInfo.getTableWidth());
        this.setMaxAvaHeight(this.getAvaHeight());
        this.setMaxAvaWidth(this.layoutInfo.getTableWidth());
        this.setCurrentIP(0);
        this.setCurrentBP(0);
        this.repeatRowCount = 0;
        this.rowCount = 0;
        this.lastRowArea = null;
        this.setCurrentIP(0);
    }

    protected int getAvaHeight() {
        this.root.setAllocatedHeight(this.parent.getMaxAvaHeight() - this.parent.getCurrentBP());
        return this.root.getContentHeight();
    }

    private void closeLayout(IBottomBorderResolverStrategy bbr) {
        Object cell;
        int i;
        if (this.root.getChildrenCount() == 0) {
            return;
        }
        ArrayList<Integer> lastDropCells = new ArrayList<Integer>();
        Iterator it = this.dropList.iterator();
        while (it.hasNext()) {
            DropCellInfo dropCell = (DropCellInfo)it.next();
            for (int columnID = dropCell.cell.getColumnID(); columnID < dropCell.cell.getColumnID() + dropCell.cell.getColSpan(); ++columnID) {
                lastDropCells.add(new Integer(columnID));
            }
        }
        ArrayList list = this.dropList;
        int bottomMaxBorder = 0;
        ArrayList<Object> changed = new ArrayList<Object>();
        for (i = 0; i < list.size(); ++i) {
            cell = (DropCellInfo)list.get(i);
            bottomMaxBorder = Math.max(bbr.resolveBottomBorder(((DropCellInfo)cell).cell), bottomMaxBorder);
            changed.add(((DropCellInfo)cell).cell);
        }
        this.updateAllUnresolvedCellArea(lastDropCells);
        if (this.lastRowArea != null) {
            Iterator iter = this.lastRowArea.getChildren();
            while (iter.hasNext()) {
                cell = (CellArea)iter.next();
                if (changed.contains(cell)) continue;
                bottomMaxBorder = Math.max(bbr.resolveBottomBorder((CellArea)cell), bottomMaxBorder);
                changed.add(cell);
            }
        }
        if (bottomMaxBorder > 0) {
            for (i = 0; i < changed.size(); ++i) {
                cell = (CellArea)changed.get(i);
                ((AbstractArea)cell).setHeight(((AbstractArea)cell).getHeight() + bottomMaxBorder);
            }
            if (this.lastRowArea != null) {
                this.lastRowArea.setHeight(this.lastRowArea.getHeight() + bottomMaxBorder);
                if (this.currentBP + bottomMaxBorder < this.maxAvaHeight) {
                    this.currentBP += bottomMaxBorder;
                }
            }
        }
        this.root.setHeight(this.getCurrentBP() + this.getOffsetY());
    }

    protected void changeTableCloseState(IPDFTableLayoutManager.ITableCloseState tableCloseState) {
        this.pageBreakState = tableCloseState;
    }

    public void setTableCloseStateAsForced() {
        this.changeTableCloseState(this.FORCED_PAGE_BREAK_STATE);
    }

    public void setTableCloseStateAsAuto() {
        this.changeTableCloseState(this.AUTO_PAGE_BREAK_STATE);
    }

    public void setTableCloseStateAsTerminated() {
        this.changeTableCloseState(this.TABLE_TERMINATED_STATE);
    }

    protected void closeLayout() {
        if (this.isLast) {
            this.changeTableCloseState(this.TABLE_TERMINATED_STATE);
        }
        this.pageBreakState.closeLayout();
        this.changeTableCloseState(this.AUTO_PAGE_BREAK_STATE);
    }

    protected void closeTableLayout() {
        this.closeLayout(new IBottomBorderResolverStrategy(){

            public int resolveBottomBorder(CellArea cell) {
                IStyle tableStyle = PDFTableLM.this.tableContent.getComputedStyle();
                IContent cellContent = cell.getContent();
                IStyle rowStyle = ((IContent)cellContent.getParent()).getComputedStyle();
                IStyle columnStyle = PDFTableLM.this.getColumnStyle(cell.getColumnID());
                IStyle cellContentStyle = cellContent.getComputedStyle();
                IStyle cellAreaStyle = cell.getStyle();
                PDFTableLM.this.bcr.resolveTableBottomBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
                return PDFTableLM.this.getDimensionValue(cellAreaStyle.getProperty(19));
            }
        });
    }

    protected void closeForcedPageBreak() {
        this.closeLayout(new IBottomBorderResolverStrategy(){

            public int resolveBottomBorder(CellArea cell) {
                IContent cellContent = cell.getContent();
                IStyle rowStyle = ((IContent)cellContent.getParent()).getComputedStyle();
                IStyle cellContentStyle = cellContent.getComputedStyle();
                IStyle cellAreaStyle = cell.getStyle();
                PDFTableLM.this.bcr.resolvePagenatedTableBottomBorder(rowStyle, cellContentStyle, cellAreaStyle);
                return PDFTableLM.this.getDimensionValue(cellAreaStyle.getProperty(19));
            }
        });
        this.tablepaginated = true;
    }

    protected void closeAutoPageBreak() {
        this.closeLayout(new IBottomBorderResolverStrategy(){

            public int resolveBottomBorder(CellArea cell) {
                return 0;
            }
        });
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void resolveBorderConflict(CellArea cellArea) {
        IStyle topCellStyle;
        IStyle leftCellContentStyle;
        IStyle preColumnStyle;
        IStyle preRowStyle;
        IStyle columnStyle;
        IStyle rowStyle;
        IStyle tableStyle;
        IStyle cellAreaStyle;
        IStyle cellContentStyle;
        int colSpan;
        int rowID;
        int columnID;
        block14: {
            block13: {
                IContent cellContent = cellArea.getContent();
                columnID = cellArea.getColumnID();
                rowID = cellArea.getRowID();
                colSpan = cellArea.getColSpan();
                IRowContent row = (IRowContent)cellContent.getParent();
                cellContentStyle = cellContent.getComputedStyle();
                cellAreaStyle = cellArea.getStyle();
                tableStyle = this.tableContent.getComputedStyle();
                rowStyle = row.getComputedStyle();
                columnStyle = this.getColumnStyle(columnID);
                preRowStyle = null;
                preColumnStyle = this.getColumnStyle(columnID - 1);
                leftCellContentStyle = null;
                topCellStyle = null;
                if (columnID > 0 && this.currentRowContent[columnID - 1] != null) {
                    leftCellContentStyle = this.currentRowContent[columnID - 1].cell.getComputedStyle();
                }
                if (this.rowCount <= 1 || this.lastRow == null) break block13;
                preRowStyle = this.lastRow.row.getComputedStyle();
                if (this.lastRowContent[columnID] == null) break block14;
                topCellStyle = this.lastRowContent[columnID].cell.getComputedStyle();
                break block14;
            }
            if (this.lastRowArea != null) {
                preRowStyle = this.lastRowArea.getContent().getComputedStyle();
                Iterator iter = this.lastRowArea.getChildren();
                while (iter.hasNext()) {
                    CellArea cell = (CellArea)iter.next();
                    ICellContent cc = (ICellContent)cell.getContent();
                    if (cc == null || cc.getColumn() != columnID) continue;
                    topCellStyle = cc.getComputedStyle();
                    break;
                }
            }
        }
        if (rowID == 0) {
            if (this.tablepaginated) {
                this.bcr.resolvePagenatedTableTopBorder(rowStyle, cellContentStyle, cellAreaStyle);
                this.tablepaginated = false;
            } else {
                this.bcr.resolveTableTopBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID == 0) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan == this.columnNumber) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        } else {
            this.bcr.resolveCellTopBorder(preRowStyle, rowStyle, topCellStyle, cellContentStyle, cellAreaStyle);
            if (columnID == 0) {
                this.bcr.resolveTableLeftBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            } else {
                this.bcr.resolveCellLeftBorder(preColumnStyle, columnStyle, leftCellContentStyle, cellContentStyle, cellAreaStyle);
            }
            if (columnID + colSpan == this.columnNumber) {
                this.bcr.resolveTableRightBorder(tableStyle, rowStyle, columnStyle, cellContentStyle, cellAreaStyle);
            }
        }
    }

    private IStyle getColumnStyle(int columnID) {
        return null;
    }

    private boolean isColumnHidden(IColumn column) {
        String format = this.context.getFormat();
        String formats = column.getVisibleFormat();
        return formats != null && formats.length() > 0 && (formats.toUpperCase().indexOf(format.toUpperCase()) >= 0 || formats.toUpperCase().indexOf("all".toUpperCase()) >= 0);
    }

    public boolean addArea(IArea area) {
        if (area instanceof RowArea) {
            this.lastRowArea = (RowArea)area;
        }
        return super.addArea(area);
    }

    protected void updateAllUnresolvedCellArea(ArrayList lastDropCells) {
        this.removeDropCells(lastDropCells);
    }

    public void updateUnresolvedCell(int groupLevel, boolean dropAll) {
        String dropType = dropAll ? "all" : "detail";
        int dropValue = this.createDropID(groupLevel, dropType);
        this.removeDropAreaBySpan(dropValue);
        for (int i = 0; i < this.columnNumber; ++i) {
            if (this.currentRowContent[i] == null || dropValue != this.currentRowContent[i].rowSpan) continue;
            this.currentRowContent[i] = null;
        }
    }

    protected void validateBoxProperty(IStyle style) {
        int maxWidth = 0;
        if (this.parent != null) {
            maxWidth = this.parent.getMaxAvaWidth();
        }
        int leftMargin = this.getDimensionValue(style.getProperty(31), maxWidth);
        int rightMargin = this.getDimensionValue(style.getProperty(32), maxWidth);
        int topMargin = this.getDimensionValue(style.getProperty(53), maxWidth);
        int bottomMargin = this.getDimensionValue(style.getProperty(52), maxWidth);
        int[] vs = new int[]{rightMargin, leftMargin};
        this.resolveBoxConflict(vs, maxWidth);
        int[] hs = new int[]{bottomMargin, topMargin};
        this.resolveBoxConflict(hs, this.context.getMaxHeight());
        style.setProperty(31, new FloatValue(1, vs[1]));
        style.setProperty(32, new FloatValue(1, vs[0]));
        style.setProperty(53, new FloatValue(1, hs[1]));
        style.setProperty(52, new FloatValue(1, hs[0]));
    }

    private IPDFTableLayoutManager.TableLayoutInfo resolveTableFixedLayout(TableArea area) {
        if (!$assertionsDisabled && this.parent == null) {
            throw new AssertionError();
        }
        int parentMaxWidth = this.parent.getMaxAvaWidth();
        IStyle style = area.getStyle();
        this.validateBoxProperty(style);
        int marginWidth = this.getDimensionValue(style.getProperty(31)) + this.getDimensionValue(style.getProperty(32));
        return new IPDFTableLayoutManager.TableLayoutInfo(this.columnWidthResolver.resolveFixedLayout(parentMaxWidth - marginWidth));
    }

    private IPDFTableLayoutManager.TableLayoutInfo resolveTableLayoutInfo(TableArea area) {
        if (!$assertionsDisabled && this.parent == null) {
            throw new AssertionError();
        }
        int avaWidth = this.parent.getMaxAvaWidth() - this.parent.getCurrentIP();
        int parentMaxWidth = this.parent.getMaxAvaWidth();
        IStyle style = area.getStyle();
        this.validateBoxProperty(style);
        int marginWidth = this.getDimensionValue(style.getProperty(31)) + this.getDimensionValue(style.getProperty(32));
        int specifiedWidth = this.getDimensionValue(this.tableContent.getWidth(), parentMaxWidth);
        if (specifiedWidth + marginWidth > parentMaxWidth) {
            specifiedWidth = 0;
        }
        boolean isInline = PropertyUtil.isInlineElement(this.content);
        if (specifiedWidth == 0) {
            this.tableWidth = isInline ? (avaWidth - marginWidth > parentMaxWidth / 4 ? avaWidth - marginWidth : parentMaxWidth - marginWidth) : avaWidth - marginWidth;
            return new IPDFTableLayoutManager.TableLayoutInfo(this.handleColummVisibity(this.columnWidthResolver.resolve(this.tableWidth, this.tableWidth)));
        }
        if (!isInline) {
            this.tableWidth = Math.min(specifiedWidth, avaWidth - marginWidth);
            return new IPDFTableLayoutManager.TableLayoutInfo(this.handleColummVisibity(this.columnWidthResolver.resolve(this.tableWidth, avaWidth - marginWidth)));
        }
        this.tableWidth = Math.min(specifiedWidth, parentMaxWidth - marginWidth);
        return new IPDFTableLayoutManager.TableLayoutInfo(this.handleColummVisibity(this.columnWidthResolver.resolve(this.tableWidth, parentMaxWidth - marginWidth)));
    }

    private int[] handleColummVisibity(int[] columns) {
        int[] colWidth = new int[this.columnNumber];
        for (int i = 0; i < this.columnNumber; ++i) {
            IColumn column = this.tableContent.getColumn(i);
            colWidth[i] = this.isColumnHidden(column) ? 0 : columns[i];
        }
        return colWidth;
    }

    public void updateRow(RowArea row, int specifiedHeight) {
        int i;
        ArrayList dropCells = this.dropList;
        CellWrapper[] cells = this.currentRowContent;
        Iterator iter = row.getChildren();
        int height = specifiedHeight;
        boolean[] hasCell = new boolean[this.columnNumber];
        while (iter.hasNext()) {
            CellArea cell = (CellArea)iter.next();
            int colID = cell.getColumnID();
            if (this.currentRowContent[colID] != null && this.currentRowContent[colID].rowSpan == 1) {
                height = Math.max(height, cell.getHeight());
            }
            for (i = colID; i < cell.getColumnID() + cell.getColSpan(); ++i) {
                hasCell[i] = true;
            }
            if (cells[colID] == null || cells[colID].rowSpan == 1) continue;
            dropCells.add(new DropCellInfo(cell, cells[colID].rowSpan));
        }
        Iterator iterator = dropCells.iterator();
        while (iterator.hasNext()) {
            DropCellInfo dropCell = (DropCellInfo)iterator.next();
            for (i = dropCell.cell.getColumnID(); i < dropCell.cell.getColumnID() + dropCell.cell.getColSpan(); ++i) {
                hasCell[i] = true;
            }
        }
        if (height > 0) {
            int i2;
            for (i2 = 0; i2 < dropCells.size(); ++i2) {
                DropCellInfo dropCell = (DropCellInfo)dropCells.get(i2);
                dropCell.leftHeight -= height;
                if (dropCell.leftHeight > 0) continue;
                dropCell.cell.setHeight(dropCell.cell.getHeight() - dropCell.leftHeight);
                dropCell.leftHeight = 0;
            }
            for (i2 = 0; i2 < this.columnNumber; ++i2) {
                if (hasCell[i2]) continue;
                ICellContent cellContent = null;
                if (cells[i2] != null) {
                    cellContent = cells[i2].cell;
                }
                if (cellContent == null) {
                    cellContent = this.tableContent.getReportContent().createCellContent();
                    cellContent.setColumn(i2);
                    cellContent.setColSpan(1);
                    cellContent.setRowSpan(1);
                    cellContent.setParent(this.currentRow.row);
                }
                int startColumn = cellContent.getColumn();
                int endColumn = cellContent.getColSpan() + startColumn;
                CellArea emptyCell = AreaFactory.createCellArea(cellContent);
                this.resolveBorderConflict(emptyCell);
                IStyle areaStyle = emptyCell.getStyle();
                areaStyle.setProperty(53, IStyle.NUMBER_0);
                emptyCell.setWidth(this.getCellWidth(startColumn, endColumn));
                emptyCell.setPosition(this.layoutInfo.getXPosition(i2), 0);
                row.addChild(emptyCell);
                emptyCell.setHeight(height);
                for (int j = startColumn; j < endColumn; ++j) {
                    hasCell[j] = true;
                }
                if (cells[i2] == null || cells[i2].rowSpan == 1) continue;
                this.dropList.add(new DropCellInfo(emptyCell, 0, cells[i2].rowSpan));
            }
            iter = row.getChildren();
            while (iter.hasNext()) {
                CellArea cell = (CellArea)iter.next();
                int colID = cell.getColumnID();
                if (this.currentRowContent[colID] == null || this.currentRowContent[colID].rowSpan != 1) continue;
                cell.setHeight(height);
                this.verticalAlign(cell);
            }
            row.setHeight(height);
        }
    }

    public int getXPos(int columnID) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getXPosition(columnID);
        }
        return 0;
    }

    public int getCellWidth(int startColumn, int endColumn) {
        if (this.layoutInfo != null) {
            return this.layoutInfo.getCellWidth(startColumn, endColumn);
        }
        return 0;
    }

    protected void verticalAlign(CellArea cell) {
        CSSValue align;
        Iterator iter;
        IContent content = cell.getContent();
        if (content == null) {
            return;
        }
        CSSValue verticalAlign = content.getComputedStyle().getProperty(30);
        if (IStyle.BOTTOM_VALUE.equals(verticalAlign) || IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
            int totalHeight = 0;
            iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea child = (AbstractArea)iter.next();
                totalHeight += child.getAllocatedHeight();
            }
            int offset = cell.getContentHeight() - totalHeight;
            if (offset > 0) {
                AbstractArea child;
                if (IStyle.BOTTOM_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset);
                    }
                } else if (IStyle.MIDDLE_VALUE.equals(verticalAlign)) {
                    iter = cell.getChildren();
                    while (iter.hasNext()) {
                        child = (AbstractArea)iter.next();
                        child.setAllocatedPosition(child.getAllocatedX(), child.getAllocatedY() + offset / 2);
                    }
                }
            }
        }
        if (IStyle.RIGHT_VALUE.equals(align = content.getComputedStyle().getProperty(26)) || IStyle.CENTER_VALUE.equals(align)) {
            iter = cell.getChildren();
            while (iter.hasNext()) {
                AbstractArea area = (AbstractArea)iter.next();
                int spacing = cell.getContentWidth() - area.getAllocatedWidth();
                if (spacing <= 0) continue;
                if (IStyle.RIGHT_VALUE.equals(align)) {
                    area.setAllocatedPosition(spacing + area.getAllocatedX(), area.getAllocatedY());
                    continue;
                }
                if (!IStyle.CENTER_VALUE.equals(align)) continue;
                area.setAllocatedPosition(spacing / 2 + area.getAllocatedX(), area.getAllocatedY());
            }
        }
    }

    protected void repeatHeader() {
        IContent content;
        if (this.isFirst) {
            this.isFirst = false;
            return;
        }
        ITableBandContent header = this.tableContent.getHeader();
        if (!this.repeatHeader || header == null) {
            return;
        }
        if (header.getChildren().isEmpty()) {
            return;
        }
        if (this.child != null && (content = this.child.getContent()) instanceof ITableBandContent && ((ITableBandContent)content).getBandType() == 1) {
            return;
        }
        PDFReportLayoutEngine engine = this.context.getLayoutEngine();
        PDFLayoutEngineContext con = new PDFLayoutEngineContext(engine);
        con.setFactory(new PDFLayoutManagerFactory(con));
        con.setFormat(this.context.getFormat());
        con.setReport(this.context.getReport());
        con.setMaxHeight(this.context.getMaxHeight());
        con.setAllowPageBreak(false);
        DOMReportItemExecutor headerExecutor = new DOMReportItemExecutor(header);
        headerExecutor.execute();
        PDFTableRegionLM regionLM = new PDFTableRegionLM(con, this.tableContent, this.layoutInfo);
        regionLM.initialize(header, null);
        regionLM.layout();
        TableArea tableRegion = (TableArea)this.tableContent.getExtension(1);
        if (tableRegion != null && tableRegion.getHeight() < this.getMaxAvaHeight() - this.currentBP) {
            Iterator iter = tableRegion.getChildren();
            RowArea row = null;
            while (iter.hasNext()) {
                row = (RowArea)iter.next();
                this.addArea(row);
                ++this.repeatRowCount;
            }
            if (row != null) {
                this.removeBottomBorder(row);
            }
        }
        this.tableContent.setExtension(1, null);
    }

    protected void addCaption(String caption) {
        if (caption == null || "".equals(caption)) {
            return;
        }
        IReportContent report = this.tableContent.getReportContent();
        ILabelContent captionLabel = report.createLabelContent();
        captionLabel.setText(caption);
        captionLabel.getStyle().setProperty(26, IStyle.CENTER_VALUE);
        ICellContent cell = report.createCellContent();
        cell.setColSpan(this.tableContent.getColumnCount());
        cell.setRowSpan(1);
        cell.setColumn(0);
        captionLabel.setParent(cell);
        cell.getChildren().add(captionLabel);
        IRowContent row = report.createRowContent();
        row.getChildren().add(cell);
        cell.setParent(row);
        ITableBandContent band = report.createTableBandContent();
        band.getChildren().add(row);
        row.setParent(band);
        band.setParent(this.tableContent);
        PDFLayoutEngineContext con = new PDFLayoutEngineContext(this.context.getLayoutEngine());
        con.setFactory(this.context.getFactory());
        con.setFormat(this.context.getFormat());
        con.setMaxHeight(this.context.getMaxHeight());
        con.setAllowPageBreak(false);
        PDFTableRegionLM regionLM = new PDFTableRegionLM(con, this.content, this.layoutInfo);
        regionLM.initialize(band, null);
        regionLM.layout();
        TableArea tableRegion = (TableArea)this.content.getExtension(1);
        if (tableRegion != null && tableRegion.getHeight() < this.getMaxAvaHeight() - this.currentBP) {
            Iterator iter = tableRegion.getChildren();
            while (iter.hasNext()) {
                RowArea rowArea = (RowArea)iter.next();
                this.root.addChild(rowArea);
                rowArea.setPosition(0, this.currentBP);
                this.setCurrentBP(this.currentBP + rowArea.getHeight());
                ++this.repeatRowCount;
            }
        }
        this.content.setExtension(1, null);
    }

    protected IReportItemExecutor createExecutor() {
        return this.executor;
    }

    protected boolean isRootEmpty() {
        return this.root == null || this.root.getChildrenCount() <= this.repeatRowCount;
    }

    static {
        $assertionsDisabled = !PDFTableLM.class.desiredAssertionStatus();
    }

    protected class RowWrapper {
        IRowContent row;
        int rowID;

        public RowWrapper(IRowContent row, int rowID) {
            this.row = row;
            this.rowID = rowID;
        }
    }

    protected class CellWrapper {
        ICellContent cell;
        int rowID;
        int rowSpan;

        public CellWrapper(ICellContent cell, int rowID, int rowSpan) {
            this.cell = cell;
            this.rowID = rowID;
            this.rowSpan = rowSpan;
        }
    }

    class DropCellInfo {
        CellArea cell;
        int leftHeight;
        int rowSpan;

        public DropCellInfo(CellArea cell, int rowSpan) {
            this.cell = cell;
            this.rowSpan = rowSpan;
            this.leftHeight = cell.getHeight();
        }

        public DropCellInfo(CellArea cell, int height, int rowSpan) {
            this.cell = cell;
            this.rowSpan = rowSpan;
            this.leftHeight = height;
        }
    }

    private class ColumnWidthResolver {
        ITableContent table;
        static final /* synthetic */ boolean $assertionsDisabled;

        public ColumnWidthResolver(ITableContent table) {
            this.table = table;
        }

        protected void formalize(DimensionType[] columns) {
            ArrayList<Integer> percentageList = new ArrayList<Integer>();
            ArrayList<Integer> unsetList = new ArrayList<Integer>();
            double total = 0.0;
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] == null) {
                    unsetList.add(new Integer(i));
                    continue;
                }
                if (!"%".equals(columns[i].getUnits())) continue;
                percentageList.add(new Integer(i));
                total += columns[i].getMeasure();
            }
            if (unsetList.isEmpty()) {
                double ratio = 100.0 / total;
                for (int i = 0; i < percentageList.size(); ++i) {
                    Integer index = (Integer)percentageList.get(i);
                    columns[index.intValue()] = new DimensionType(columns[index].getMeasure() * ratio, columns[index].getUnits());
                }
            } else if (total < 100.0) {
                double delta = 100.0 - total;
                for (int i = 0; i < unsetList.size(); ++i) {
                    Integer index = (Integer)unsetList.get(i);
                    columns[index.intValue()] = new DimensionType(delta / (double)unsetList.size(), "%");
                }
            } else {
                Integer index;
                int i;
                double ratio = 100.0 / total;
                for (i = 0; i < unsetList.size(); ++i) {
                    index = (Integer)unsetList.get(i);
                    columns[index.intValue()] = new DimensionType(0.0, "pt");
                }
                for (i = 0; i < percentageList.size(); ++i) {
                    index = (Integer)percentageList.get(i);
                    columns[index.intValue()] = new DimensionType(columns[index].getMeasure() * ratio, columns[index].getUnits());
                }
            }
        }

        protected int[] resolve(int tableWidth, DimensionType[] columns) {
            int i;
            int[] cols = new int[columns.length];
            int total = 0;
            for (i = 0; i < columns.length; ++i) {
                if ("%".equals(columns[i].getUnits())) continue;
                cols[i] = PDFTableLM.this.getDimensionValue(columns[i], tableWidth);
                total += cols[i];
            }
            if (total > tableWidth) {
                for (i = 0; i < columns.length; ++i) {
                    if (!"%".equals(columns[i].getUnits())) continue;
                    cols[i] = 0;
                }
            } else {
                int delta = tableWidth - total;
                for (int i2 = 0; i2 < columns.length; ++i2) {
                    if (!"%".equals(columns[i2].getUnits())) continue;
                    cols[i2] = (int)((double)delta * columns[i2].getMeasure() / 100.0);
                }
            }
            return cols;
        }

        public int[] resolveFixedLayout(int maxWidth) {
            int columnNumber = this.table.getColumnCount();
            DimensionType[] columns = new DimensionType[columnNumber];
            for (int i = 0; i < columnNumber; ++i) {
                IColumn column = this.table.getColumn(i);
                DimensionType w = column.getWidth();
                columns[i] = PDFTableLM.this.isColumnHidden(column) ? new DimensionType(0.0, "pt") : (w == null ? null : new DimensionType(w.getMeasure(), w.getUnits()));
            }
            this.formalize(columns);
            int specifiedWidth = PDFTableLM.this.getDimensionValue(PDFTableLM.this.tableContent.getWidth(), maxWidth);
            int tableWidth = Math.max(specifiedWidth, maxWidth);
            return this.resolve(tableWidth, columns);
        }

        public int[] resolve(int specifiedWidth, int maxWidth) {
            if (!$assertionsDisabled && specifiedWidth > maxWidth) {
                throw new AssertionError();
            }
            int columnNumber = this.table.getColumnCount();
            int[] columns = new int[columnNumber];
            int columnWithWidth = 0;
            int colSum = 0;
            for (int j = 0; j < this.table.getColumnCount(); ++j) {
                IColumn column = this.table.getColumn(j);
                int columnWidth = PDFTableLM.this.getDimensionValue(column.getWidth(), PDFTableLM.this.tableWidth);
                if (columnWidth > 0) {
                    columns[j] = columnWidth;
                    colSum += columnWidth;
                    ++columnWithWidth;
                    continue;
                }
                columns[j] = -1;
            }
            if (columnWithWidth == columnNumber) {
                if (colSum <= maxWidth) {
                    return columns;
                }
                float delta = colSum - maxWidth;
                for (int i = 0; i < columnNumber; ++i) {
                    int n = i;
                    columns[n] = columns[n] - (int)(delta * (float)columns[i] / (float)colSum);
                }
                return columns;
            }
            if (specifiedWidth == 0) {
                if (colSum < maxWidth) {
                    this.distributeLeftWidth(columns, (maxWidth - colSum) / (columnNumber - columnWithWidth));
                } else {
                    this.redistributeWidth(columns, colSum - maxWidth + (columnNumber - columnWithWidth) * maxWidth / columnNumber, maxWidth, colSum);
                }
            } else if (colSum < specifiedWidth) {
                this.distributeLeftWidth(columns, (specifiedWidth - colSum) / (columnNumber - columnWithWidth));
            } else if (colSum < maxWidth) {
                this.distributeLeftWidth(columns, (maxWidth - colSum) / (columnNumber - columnWithWidth));
            } else {
                this.redistributeWidth(columns, colSum - specifiedWidth + (columnNumber - columnWithWidth) * specifiedWidth / columnNumber, specifiedWidth, colSum);
            }
            return columns;
        }

        private void redistributeWidth(int[] cols, int delta, int sum, int currentSum) {
            int avaWidth = sum / cols.length;
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] < 0) {
                    cols[i] = avaWidth;
                    continue;
                }
                int n = i;
                cols[n] = cols[n] - (int)((float)cols[i] * (float)delta / (float)currentSum);
            }
        }

        private void distributeLeftWidth(int[] cols, int avaWidth) {
            for (int i = 0; i < cols.length; ++i) {
                if (cols[i] >= 0) continue;
                cols[i] = avaWidth;
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$report$engine$layout$pdf$PDFTableLM == null ? (class$org$eclipse$birt$report$engine$layout$pdf$PDFTableLM = PDFTableLM.class$("org.eclipse.birt.report.engine.layout.pdf.PDFTableLM")) : class$org$eclipse$birt$report$engine$layout$pdf$PDFTableLM).desiredAssertionStatus();
        }
    }

    static interface IBottomBorderResolverStrategy {
        public int resolveBottomBorder(CellArea var1);
    }

    public class TableTerminatedState
    implements IPDFTableLayoutManager.ITableCloseState {
        public void closeLayout() {
            PDFTableLM.this.closeTableLayout();
        }
    }

    public class AutoPageBreakState
    implements IPDFTableLayoutManager.ITableCloseState {
        public void closeLayout() {
            PDFTableLM.this.closeAutoPageBreak();
        }
    }

    public class ForcedPageBreakState
    implements IPDFTableLayoutManager.ITableCloseState {
        public void closeLayout() {
            PDFTableLM.this.closeForcedPageBreak();
        }
    }
}

