/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.area.impl.TemplateArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLeafItemLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFTemplateLM
extends PDFLeafItemLM {
    static final /* synthetic */ boolean $assertionsDisabled;

    public PDFTemplateLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        if (!$assertionsDisabled && !(content instanceof IAutoTextContent)) {
            throw new AssertionError();
        }
        this.handleAutoText((IAutoTextContent)content);
    }

    public boolean layoutChildren() {
        IAutoTextContent autoText = (IAutoTextContent)this.content;
        ContainerArea templateContainer = (ContainerArea)this.createInlineContainer(autoText, true, true);
        IStyle areaStyle = templateContainer.getStyle();
        int maxWidth = this.parent.getMaxAvaWidth();
        this.validateBoxProperty(areaStyle, maxWidth, this.context.getMaxHeight());
        int width = this.getDimensionValue(autoText.getWidth(), maxWidth);
        templateContainer.setAllocatedWidth(maxWidth - this.parent.getCurrentIP());
        int minContentWidth = this.getDimensionValue(areaStyle.getFontSize()) * 4;
        int maxContentWidth = templateContainer.getWidth();
        int preWidth = 0;
        preWidth = width >= maxContentWidth ? Math.max(maxContentWidth, minContentWidth) : Math.max(minContentWidth, width);
        templateContainer.setWidth(preWidth);
        int height = this.getDimensionValue(autoText.getHeight(), maxWidth);
        templateContainer.setContentHeight(Math.max((int)((double)this.getDimensionValue(areaStyle.getFontSize()) * 1.35), height));
        Dimension templateDimension = new Dimension();
        templateDimension.setDimension(templateContainer.getContentWidth(), templateContainer.getContentHeight());
        TemplateArea templateArea = this.createTemplateArea(autoText, templateDimension);
        templateContainer.addChild(templateArea);
        templateArea.setPosition(templateContainer.getContentX(), templateContainer.getContentY());
        this.parent.addArea(templateContainer);
        return false;
    }

    protected void handleAutoText(IAutoTextContent autoText) {
        if (0 == autoText.getType()) {
            this.context.addUnresolvedContent(autoText);
        }
        if (1 == autoText.getType()) {
            String originalPageNumber = autoText.getText();
            NumberFormatter nf = new NumberFormatter();
            String patternStr = autoText.getComputedStyle().getNumberFormat();
            nf.applyPattern(patternStr);
            autoText.setText(nf.format((long)Integer.parseInt(originalPageNumber)));
        }
    }

    private TemplateArea createTemplateArea(IAutoTextContent autoText, Dimension contentDimension) {
        TemplateArea templateArea = (TemplateArea)AreaFactory.createTemplateArea(autoText);
        templateArea.setWidth(contentDimension.getWidth());
        templateArea.setHeight(contentDimension.getHeight());
        return templateArea;
    }

    static {
        $assertionsDisabled = !PDFTemplateLM.class.desiredAssertionStatus();
    }
}

