/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.layout.pdf.font.FontConfigReader;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.font.FontMappingManager;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.css.CSSValueList;

public class FontHandler {
    private static FontMappingManager fontMappingManager;
    private CSSValueList fontFamilies = null;
    private int fontStyle = 0;
    private float fontSize = 0.0f;
    private BaseFont bf = null;
    private boolean isFontChanged = false;
    private boolean simulation = false;
    private static boolean prepared;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FontHandler(ITextContent textContent) {
        IStyle style = textContent.getComputedStyle();
        this.fontFamilies = (CSSValueList)style.getProperty(49);
        if ("oblique".equals(style.getFontStyle()) || "italic".equals(style.getFontStyle())) {
            this.fontStyle |= 2;
        }
        if (PropertyUtil.isBoldFont(style.getProperty(27))) {
            this.fontStyle |= 1;
        }
        this.fontSize = (float)PropertyUtil.getDimensionValue(style.getProperty(38)) / 1000.0f;
    }

    private static int registerDirectories() {
        int count = 0;
        count += FontFactory.registerDirectory((String)"C:/windows/fonts");
        count += FontFactory.registerDirectory((String)"d:/windows/fonts");
        count += FontFactory.registerDirectory((String)"e:/windows/fonts");
        count += FontFactory.registerDirectory((String)"f:/windows/fonts");
        count += FontFactory.registerDirectory((String)"g:/windows/fonts");
        count += FontFactory.registerDirectory((String)"C:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"d:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"e:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"f:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"g:/WINNT/fonts");
        count += FontFactory.registerDirectory((String)"/usr/X/lib/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/default/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/euro_fonts/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_2/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_5/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_7/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_8/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_9/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_13/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/iso_8859_15/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ar/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/hi_IN.UTF-8/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ja/X11/fonts/TT");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ko/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ko.UTF-8/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/KOI8-R/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/ru.ansi-1251/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/th_TH/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_TW/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_TW.BIG5/X11/fonts/TT");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_HK.BIG5HK/X11/fonts/TT");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh_CN.GB18030/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/openwin/lib/locale/zh.GBK/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/truetype");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/tt");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/TTF");
        count += FontFactory.registerDirectory((String)"/usr/X11R6/lib/X11/fonts/OTF");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/ja/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/truetype");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/ko/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/zh_CN/TrueType");
        count += FontFactory.registerDirectory((String)"/usr/share/fonts/zh_TW/TrueType");
        return count += FontFactory.registerDirectory((String)"/var/lib/defoma/x-ttcidfont-conf.d/dirs/TrueType");
    }

    public static synchronized void prepareFonts() {
        if (prepared) {
            return;
        }
        FontConfigReader fcr = new FontConfigReader();
        String embededFontPath = fcr.getEmbededFontPath();
        if (null != embededFontPath) {
            FontFactory.registerDirectory((String)embededFontPath);
        }
        fontMappingManager = fcr.getFontMappingManager();
        if (fcr.parseConfigFile()) {
            List fontPaths = fcr.getTrueTypeFontPaths();
            if (fontPaths.isEmpty()) {
                FontHandler.registerDirectories();
            } else {
                Iterator i = fontPaths.iterator();
                while (i.hasNext()) {
                    String fontPath = (String)i.next();
                    File file = new File(fontPath);
                    if (!file.exists()) continue;
                    if (file.isDirectory()) {
                        FontFactory.registerDirectory((String)fontPath);
                        continue;
                    }
                    FontFactory.register((String)fontPath);
                }
            }
        } else {
            FontHandler.registerDirectories();
        }
        prepared = true;
    }

    public FontInfo getFontInfo() {
        this.checkFontAvailability();
        return new FontInfo(this.bf, this.fontSize, this.fontStyle, this.simulation);
    }

    public boolean selectFont(char character) {
        BaseFont candidateFont = fontMappingManager.getMappedFont(character, this.fontFamilies, this.fontStyle);
        if (null == candidateFont) {
            this.checkFontStatus(fontMappingManager.getDefaultFont(this.fontStyle));
            return false;
        }
        this.checkFontStatus(candidateFont);
        return true;
    }

    private void checkFontStatus(BaseFont candidateFont) {
        if (!$assertionsDisabled && candidateFont == null) {
            throw new AssertionError();
        }
        if (this.bf == candidateFont) {
            this.isFontChanged = false;
        } else {
            this.isFontChanged = true;
            this.bf = candidateFont;
        }
    }

    public boolean isFontChanged() {
        return this.isFontChanged;
    }

    private String getEnglishName(String[][] names) {
        String tmp = null;
        for (int i = 0; i < names.length; ++i) {
            if ("0".equals(names[i][2])) {
                return names[i][3];
            }
            if ("1033".equals(names[i][2])) {
                tmp = names[i][3];
            }
            if (!"".equals(names[i][2])) continue;
            tmp = names[i][3];
        }
        return tmp;
    }

    private void checkFontAvailability() {
        this.simulation = this.fontStyle == 0 ? false : this.getEnglishName(this.bf.getFamilyFontName()).equals(this.getEnglishName(this.bf.getFullFontName()));
    }

    static {
        $assertionsDisabled = !FontHandler.class.desiredAssertionStatus();
        fontMappingManager = null;
        prepared = false;
    }
}

