/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.logging.Level;
import org.eclipse.birt.report.engine.api.script.eventhandler.IImageEventHandler;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.impl.ImageContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Image;
import org.eclipse.birt.report.engine.script.internal.instance.ImageInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;

public class ImageScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(ImageHandle imageHandle, ExecutionContext context) {
        try {
            Image image = new Image(imageHandle);
            if (ImageScriptExecutor.handleJS((Object)image, imageHandle.getOnPrepare(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageHandle, context);
            if (eh != null) {
                eh.onPrepare(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static void handleOnCreate(ImageContent content, ExecutionContext context) {
        try {
            ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
            ImageInstance image = new ImageInstance(content, context);
            if (ImageScriptExecutor.handleJS((Object)image, imageDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onCreate(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IImageContent content, ExecutionContext context) {
        try {
            ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
            ImageInstance image = new ImageInstance(content, context);
            if (ImageScriptExecutor.handleJS((Object)image, imageDesign.getOnRender(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onRender(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IImageContent content, ExecutionContext context) {
        try {
            ReportItemDesign imageDesign = (ReportItemDesign)content.getGenerateBy();
            ImageInstance image = new ImageInstance(content, context);
            if (ImageScriptExecutor.handleJS((Object)image, imageDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IImageEventHandler eh = ImageScriptExecutor.getEventHandler(imageDesign, context);
            if (eh != null) {
                eh.onPageBreak(image, context.getReportContext());
            }
        }
        catch (Exception e) {
            ImageScriptExecutor.addException(context, e);
        }
    }

    private static IImageEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        DesignElementHandle designHandle = design.getHandle();
        if (!(designHandle instanceof ImageHandle)) {
            return null;
        }
        ImageHandle handle = (ImageHandle)designHandle;
        if (handle == null) {
            return null;
        }
        return ImageScriptExecutor.getEventHandler(handle, context);
    }

    private static IImageEventHandler getEventHandler(ImageHandle handle, ExecutionContext context) {
        IImageEventHandler eh = null;
        try {
            eh = (IImageEventHandler)ImageScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            ImageScriptExecutor.addClassCastException(context, e, handle.getEventHandlerClass(), IImageEventHandler.class);
        }
        return eh;
    }
}

