/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IRowEventHandler;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Row;
import org.eclipse.birt.report.engine.script.internal.instance.RowInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.RowHandle;

public class RowScriptExecutor
extends ScriptExecutor {
    public static void handleOnPrepare(RowHandle rowHandle, ExecutionContext context) {
        try {
            Row row = new Row(rowHandle);
            if (RowScriptExecutor.handleJS((Object)row, rowHandle.getOnPrepare(), context).didRun()) {
                return;
            }
            IRowEventHandler eh = RowScriptExecutor.getEventHandler(rowHandle, context);
            if (eh != null) {
                eh.onPrepare(row, context.getReportContext());
            }
        }
        catch (Exception e) {
            RowScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(IRowContent content, ExecutionContext context) {
        try {
            ReportItemDesign rowDesign = (ReportItemDesign)content.getGenerateBy();
            RowInstance row = new RowInstance(content, context);
            if (RowScriptExecutor.handleJS((Object)row, rowDesign.getOnCreate(), context).didRun()) {
                return;
            }
            IRowEventHandler eh = RowScriptExecutor.getEventHandler(rowDesign, context);
            if (eh != null) {
                eh.onCreate(row, context.getReportContext());
            }
        }
        catch (Exception e) {
            RowScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(IRowContent content, ExecutionContext context) {
        try {
            ReportItemDesign rowDesign = (ReportItemDesign)content.getGenerateBy();
            RowInstance row = new RowInstance(content, context);
            if (RowScriptExecutor.handleJS((Object)row, rowDesign.getOnRender(), context).didRun()) {
                return;
            }
            IRowEventHandler eh = RowScriptExecutor.getEventHandler(rowDesign, context);
            if (eh != null) {
                eh.onRender(row, context.getReportContext());
            }
        }
        catch (Exception e) {
            RowScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(IRowContent content, ExecutionContext context) {
        try {
            ReportItemDesign rowDesign = (ReportItemDesign)content.getGenerateBy();
            RowInstance row = new RowInstance(content, context);
            if (RowScriptExecutor.handleJS((Object)row, rowDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            IRowEventHandler eh = RowScriptExecutor.getEventHandler(rowDesign, context);
            if (eh != null) {
                eh.onPageBreak(row, context.getReportContext());
            }
        }
        catch (Exception e) {
            RowScriptExecutor.addException(context, e);
        }
    }

    private static IRowEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        RowHandle handle = (RowHandle)design.getHandle();
        if (handle == null) {
            return null;
        }
        return RowScriptExecutor.getEventHandler(handle, context);
    }

    private static IRowEventHandler getEventHandler(RowHandle handle, ExecutionContext context) {
        IRowEventHandler eh = null;
        try {
            eh = (IRowEventHandler)RowScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            RowScriptExecutor.addClassCastException(context, e, handle.getEventHandlerClass(), IRowEventHandler.class);
        }
        return eh;
    }
}

