/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal.element;

import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IAction;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.Action;

public class ActionImpl
implements IAction {
    private ActionHandle action;
    private ReportItemHandle handle;

    private void init(ActionHandle action, ReportItemHandle handle) {
        this.action = action;
        this.handle = handle;
    }

    public ActionImpl(ActionHandle action, LabelHandle handle) {
        this.init(action, (ReportItemHandle)handle);
    }

    public ActionImpl(ActionHandle action, ImageHandle handle) {
        this.init(action, (ReportItemHandle)handle);
    }

    public ActionImpl(ActionHandle action, DataItemHandle handle) {
        this.init(action, (ReportItemHandle)handle);
    }

    public String getURI() {
        return this.action.getURI();
    }

    public String getTargetWindow() {
        return this.action.getTargetWindow();
    }

    public String getLinkType() {
        return this.action.getLinkType();
    }

    public void setLinkType(String type) throws ScriptException {
        try {
            this.checkAction();
            this.action.setLinkType(type);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setFormatType(String type) throws ScriptException {
        try {
            this.checkAction();
            this.action.setFormatType(type);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public String getFormatType() {
        return this.action.getFormatType();
    }

    public void setTargetWindow(String window) throws ScriptException {
        this.checkAction();
        try {
            this.action.setTargetWindow(window);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public void setURI(String uri) throws ScriptException {
        this.checkAction();
        try {
            this.action.setURI(uri);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public String getReportName() {
        return this.action.getReportName();
    }

    public void setReportName(String reportName) throws ScriptException {
        this.checkAction();
        try {
            this.action.setReportName(reportName);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    public String getTargetBookmark() {
        return this.action.getTargetBookmark();
    }

    public void setTargetBookmark(String bookmark) throws ScriptException {
        this.checkAction();
        try {
            this.action.setTargetBookmark(bookmark);
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }

    private void checkAction() throws ScriptException {
        if (this.action != null) {
            return;
        }
        Action a = new Action();
        try {
            if (this.handle instanceof LabelHandle) {
                ((LabelHandle)this.handle).setAction(a);
                this.action = ((LabelHandle)this.handle).getActionHandle();
            } else if (this.handle instanceof ImageHandle) {
                ((ImageHandle)this.handle).setAction(a);
                this.action = ((ImageHandle)this.handle).getActionHandle();
            } else if (this.handle instanceof DataItemHandle) {
                ((DataItemHandle)this.handle).setAction(a);
                this.action = ((DataItemHandle)this.handle).getActionHandle();
            }
        }
        catch (SemanticException e) {
            throw new ScriptException(e.getLocalizedMessage());
        }
    }
}

