/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import org.eclipse.aperi.TStorm.common.ColumnDescriptor;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class CustomReportDataAdjuster
extends ReportDataAdjuster {
    protected int[] translateTable;
    protected int[] standardHiddenColumns;
    protected int standardFrozenColumns;
    protected int standardFirstColumn;
    protected String[] standardColNames;
    public int[] hiddenColumns;
    public int frozenColumns;
    public int firstColumn;
    public boolean bHasTotalRow = false;
    public static final String NA = MessageLog.getMessageNoID("GEN0185T");

    public CustomReportDataAdjuster(GuiReportReq guiReportReq) {
        this.translateTable = guiReportReq.selectedColumns;
    }

    public abstract void adjustInit(Object[] var1, boolean var2);

    public abstract void adjustData();

    public boolean[] getSpannedColumns(String[] stringArray) {
        boolean[] blArray = new boolean[stringArray.length];
        int n = 1;
        while (n < stringArray.length) {
            if (stringArray[n].length() == 0) {
                blArray[n - 1] = true;
            }
            ++n;
        }
        return blArray;
    }

    public ColumnDescriptor getColumnDescriptors() {
        int n = this.standardColNames.length;
        int n2 = this.getNumberFrozenRows();
        boolean bl = false;
        ColumnDescriptor[] columnDescriptorArray = new ColumnDescriptor[n];
        boolean[] blArray = this.getSpannedColumns(this.standardColNames);
        int[] nArray = this.getRenderers();
        int n3 = 0;
        while (n3 < n) {
            ColumnDescriptor columnDescriptor;
            columnDescriptorArray[n3] = columnDescriptor = new ColumnDescriptor();
            columnDescriptor.cdID = (short)n3;
            columnDescriptor.cdIsFrozen = n3 < this.standardFrozenColumns;
            switch (nArray[n3]) {
                case 4: 
                case 7: 
                case 8: {
                    columnDescriptor.cdDataType = (short)5;
                    break;
                }
                case 2: {
                    int n4 = this.getScale();
                    while ((n4 /= 10) > 0) {
                        columnDescriptor.cdScale = (byte)(columnDescriptor.cdScale + 1);
                    }
                }
                case 5: 
                case 6: 
                case 9: {
                    columnDescriptor.cdDataType = (short)2;
                    break;
                }
                case 1: {
                    columnDescriptor.cdDataType = (short)3;
                    break;
                }
                case 3: {
                    columnDescriptor.cdDataType = (short)4;
                    break;
                }
                case 10: {
                    columnDescriptor.cdDataType = (short)2;
                    break;
                }
                default: {
                    columnDescriptor.cdDataType = 1;
                }
            }
            if (blArray[n3]) {
                bl = true;
                columnDescriptor.cdShortName = this.makeColName(n3, n2 - 1);
                columnDescriptor.cdReportName = String.valueOf(columnDescriptor.cdShortName) + ": " + this.getCellData(n2 - 1, n3);
            } else if (bl) {
                bl = false;
                ColumnDescriptor columnDescriptor2 = columnDescriptorArray[n3 - 1];
                columnDescriptor.cdShortName = columnDescriptor2.cdShortName;
                columnDescriptor.cdReportName = String.valueOf(columnDescriptor.cdShortName) + ": " + this.getCellData(n2 - 1, n3);
                columnDescriptor2.cdTwin = columnDescriptor;
                columnDescriptor.cdTwin = columnDescriptor2;
            } else {
                columnDescriptor.cdReportName = columnDescriptor.cdShortName = this.makeColName(n3, n2);
            }
            ++n3;
        }
        this.addValidValues(columnDescriptorArray);
        return this.makeColumnList(columnDescriptorArray);
    }

    protected String[] getCustomizedColNames(String[] stringArray) {
        this.standardHiddenColumns = this.hiddenColumns;
        this.standardFrozenColumns = this.frozenColumns;
        this.standardFirstColumn = this.firstColumn;
        this.standardColNames = stringArray;
        String[] stringArray2 = stringArray;
        if (this.translateTable != null) {
            stringArray2 = new String[this.translateTable.length];
            int n = 0;
            while (n < this.translateTable.length) {
                stringArray2[n] = stringArray[this.translateTable[n]];
                ++n;
            }
            if (this.frozenColumns > 0 && this.hiddenColumns != null) {
                this.frozenColumns -= this.hiddenColumns.length;
            }
            this.hiddenColumns = null;
            this.firstColumn = 0;
        }
        return stringArray2;
    }

    public int getColumnPosition(int n) {
        if (this.translateTable != null) {
            int n2 = 0;
            while (n2 < this.translateTable.length) {
                if (n == this.translateTable[n2]) {
                    return n2;
                }
                ++n2;
            }
            return -1;
        }
        return n;
    }

    protected void addValidValues(ColumnDescriptor[] columnDescriptorArray) {
    }

    public void undo() {
    }

    public String[] getLabels() {
        return this.standardColNames;
    }

    public int getFrozenColumns() {
        return this.frozenColumns;
    }

    public boolean columnsAreCustomized() {
        return this.translateTable != null;
    }

    public int translateColumn(int n) {
        return this.translateTable == null ? n : this.translateTable[n];
    }

    public int[] fixColumnArray(int[] nArray) {
        if (this.translateTable != null) {
            return this.translateTable;
        }
        return super.fixColumnArray(nArray);
    }

    private String makeColName(int n, int n2) {
        String string = this.standardColNames[n];
        int n3 = 0;
        while (n3 < n2) {
            String string2 = (String)this.getCellData(n3, n);
            if (!Util.isEmpty(string2)) {
                string = String.valueOf(string) + " " + string2;
            }
            ++n3;
        }
        return string;
    }

    private ColumnDescriptor makeColumnList(ColumnDescriptor[] columnDescriptorArray) {
        if (this.standardFirstColumn > 0) {
            int n = this.standardFirstColumn;
            ColumnDescriptor columnDescriptor = columnDescriptorArray[this.standardFirstColumn];
            while (n > this.standardFrozenColumns) {
                columnDescriptorArray[n--] = columnDescriptorArray[n];
            }
            columnDescriptorArray[n] = columnDescriptor;
        }
        ColumnDescriptor columnDescriptor = null;
        int n = columnDescriptorArray.length - 1;
        while (n >= 0) {
            block8: {
                ColumnDescriptor columnDescriptor2;
                block7: {
                    columnDescriptor2 = columnDescriptorArray[n];
                    if (this.standardHiddenColumns == null) break block7;
                    int n2 = this.standardHiddenColumns.length - 1;
                    while (n2 >= 0) {
                        if (this.standardHiddenColumns[n2] == columnDescriptor2.cdID) break;
                        --n2;
                    }
                    if (n2 >= 0) break block8;
                }
                columnDescriptor2.cdNext = columnDescriptor;
                columnDescriptor = columnDescriptor2;
            }
            --n;
        }
        return columnDescriptor;
    }

    public boolean hasTotalsRow() {
        return this.bHasTotalRow;
    }
}

