/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.util.Date;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.xmsg.MessageLog;

public class DiskHistAdjuster
extends ReportDataAdjuster {
    static final String PRIMARY_DEFECTS = MessageLog.getMessageNoID("STG1200L");
    static final String GROWN_DEFECTS = MessageLog.getMessageNoID("STG1201L");
    static final String REC_WRITE_ERRS = MessageLog.getMessageNoID("STG1202L");
    static final String UNREC_WRITE_ERRS = MessageLog.getMessageNoID("STG1203L");
    static final String BYTES_WRITTEN = MessageLog.getMessageNoID("STG1204L");
    static final String REC_READ_ERRS = MessageLog.getMessageNoID("STG1205L");
    static final String UNREC_READ_ERRS = MessageLog.getMessageNoID("STG1206L");
    static final String BYTES_READ = MessageLog.getMessageNoID("STG1207L");
    static final String REC_VERIFY_ERRS = MessageLog.getMessageNoID("STG1208L");
    static final String UNREC_VERIFY_ERRS = MessageLog.getMessageNoID("STG1209L");
    static final String NON_MEDIUM_ERRS = MessageLog.getMessageNoID("STG1210L");
    static final String TIMESTAMP = MessageLog.getMessageNoID("STG1211L");
    static final String TEMP = MessageLog.getMessageNoID("STG1212L");
    static final String UNALLOCATED = MessageLog.getMessageNoID("STG4131L");
    static final String RECORD_TYPE = MessageLog.getMessageNoID("STG1214L");
    static final int TIMESTAMP_COL = 0;
    static final int RECORD_TYPE_COL = 1;
    static final int BYTES_WRITTEN_COL = 2;
    static final int BYTES_READ_COL = 3;
    static final int GROWN_DEFECTS_COL = 4;
    static final int REC_WRITE_ERRS_COL = 5;
    static final int UNREC_WRITE_ERRS_COL = 6;
    static final int REC_READ_ERRS_COL = 7;
    static final int UNREC_READ_ERRS_COL = 8;
    static final int REC_VERIFY_ERRS_COL = 9;
    static final int UNREC_VERIFY_ERRS_COL = 10;
    static final int NON_MEDIUM_ERRS_COL = 11;
    static final int UNALLOCATED_COL = 12;
    static final int PRIMARY_DEFECTS_COL = 13;
    static final int TEMP_COL = 14;
    public static final String[] colNames = new String[]{TIMESTAMP, RECORD_TYPE, BYTES_WRITTEN, BYTES_READ, GROWN_DEFECTS, REC_WRITE_ERRS, UNREC_WRITE_ERRS, REC_READ_ERRS, UNREC_READ_ERRS, REC_VERIFY_ERRS, UNREC_VERIFY_ERRS, NON_MEDIUM_ERRS, UNALLOCATED, PRIMARY_DEFECTS, TEMP};
    private DiskHistory[] histArray;
    private int[] rendererArray;
    private Date[] mDate;
    private MutableInteger[] mInt;
    private MutableLong[] mLong;
    private short osType;

    public DiskHistAdjuster(short s) {
        this.osType = s;
    }

    public void adjust(Object[] objectArray, boolean bl) {
        this.histArray = (DiskHistory[])objectArray;
        int n = this.histArray.length;
        this.mDate = new Date[n];
        this.mInt = new MutableInteger[n];
        this.mLong = new MutableLong[n];
        int n2 = 0;
        while (n2 < n) {
            this.mDate[n2] = new Date();
            this.mInt[n2] = new MutableInteger();
            this.mLong[n2] = new MutableLong();
            this.histArray[n2].dkhFreeSpace *= 512L;
            ++n2;
        }
        this.rendererArray = new int[colNames.length];
        this.rendererArray[0] = 1;
        this.rendererArray[2] = 7;
        this.rendererArray[3] = 7;
        this.rendererArray[4] = 5;
        this.rendererArray[5] = 5;
        this.rendererArray[6] = 5;
        this.rendererArray[7] = 5;
        this.rendererArray[8] = 5;
        this.rendererArray[9] = 5;
        this.rendererArray[10] = 5;
        this.rendererArray[11] = 5;
        this.rendererArray[12] = 7;
        this.rendererArray[13] = 5;
        this.rendererArray[14] = 5;
    }

    public String[] getLabels() {
        return colNames;
    }

    public int getNumberRows() {
        return this.histArray.length;
    }

    public int getNumberColumns() {
        return colNames.length;
    }

    public int[] getRenderers() {
        return this.rendererArray;
    }

    public Object getArray() {
        return this.histArray;
    }

    public Object getCellData(int n, int n2) {
        switch (n2) {
            case 0: {
                this.mDate[n].setTime(this.histArray[n].dkhTimestamp);
                return this.mDate[n];
            }
            case 1: {
                return DiskHistory.TYPES[this.histArray[n].dkhType];
            }
            case 2: {
                this.mLong[n].value = this.histArray[n].dkhBytesWritten;
                return this.mLong[n];
            }
            case 3: {
                this.mLong[n].value = this.histArray[n].dkhBytesRead;
                return this.mLong[n];
            }
            case 4: {
                this.mInt[n].value = this.histArray[n].dkhGrownDefects;
                return this.mInt[n];
            }
            case 5: {
                this.mInt[n].value = this.histArray[n].dkhRecoveredWriteErrors;
                return this.mInt[n];
            }
            case 6: {
                this.mInt[n].value = this.histArray[n].dkhUnrecoveredWriteErrors;
                return this.mInt[n];
            }
            case 7: {
                this.mInt[n].value = this.histArray[n].dkhRecoveredReadErrors;
                return this.mInt[n];
            }
            case 8: {
                this.mInt[n].value = this.histArray[n].dkhUnrecoveredReadErrors;
                return this.mInt[n];
            }
            case 9: {
                this.mInt[n].value = this.histArray[n].dkhRecoveredVerifyErrors;
                return this.mInt[n];
            }
            case 10: {
                this.mInt[n].value = this.histArray[n].dkhUnrecoveredVerifyErrors;
                return this.mInt[n];
            }
            case 11: {
                this.mInt[n].value = this.histArray[n].dkhNonMediumErrors;
                return this.mInt[n];
            }
            case 12: {
                this.mLong[n].value = this.histArray[n].dkhFreeSpace;
                return this.mLong[n];
            }
            case 13: {
                this.mInt[n].value = this.histArray[n].dkhPrimaryDefects;
                return this.mInt[n];
            }
            case 14: {
                this.mInt[n].value = this.histArray[n].dkhTemperature;
                return this.mInt[n];
            }
        }
        return null;
    }

    public boolean hasTotalsRow() {
        return false;
    }
}

