/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.Serializable;
import org.eclipse.aperi.TStorm.common.Chunk;
import org.eclipse.aperi.TStorm.common.ChunkCollection;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LunWWN;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class LogicalDisk
implements Serializable {
    static final long serialVersionUID = -7333215328383301242L;
    public transient LogicalDisk ldNext;
    public transient LogicalDisk ldNextMirror;
    public transient ChunkCollection ldCollectionList;
    public Filesystem ldFilesystem;
    public transient Filesystem ldRepoFilesystem;
    public String ldPath;
    public String[] ldRanks;
    public transient String ldTruePath;
    public long ldCapacity;
    public long ldOverhead;
    public int ldParentLogicalDiskID;
    public int ldID;
    public short ldUseCount;
    public byte ldType;
    public short ldStorageType;
    public int ldRaid;
    public short ldCopyServices;
    public byte lun_identity = (byte)7;
    public byte ldMirrorCount;
    public transient boolean ldNewLogicalDisk;
    public boolean ldIsSwap;
    public LogicalDisk ldSnapSource;
    public int ldSnapSourceID;
    private short ldFlags;
    public transient short ldOldFlags;
    public Share[] ldHostPaths;
    public int ldVolgroupID;
    public transient int ldOldVolgroupID;
    public VolGroup ldVgroup;
    public LunWWN ldLunWWNs;
    public ChunkCollection[] ldPackedCollectionList;
    public LogicalDisk[] ldPackedMirrors;
    public LunWWN[] ldPackedLunWWNs;
    public String ldName;
    public String ldDeviceId;
    public String ldAggrName;
    public static final byte RAW = 0;
    public static final byte CONCATENATION = 1;
    public static final byte COLLECTION_MIRROR = 2;
    public static final byte LOGICAL_DISK_MIRROR = 3;
    public static final byte VIRTUAL_MEMORY = 4;
    public static final byte LOGICAL_DISK_STRIPE = 5;
    public static final byte LOGICAL_DISK_CONCAT = 6;
    public static final byte UNKNOWN = 7;
    public static final byte STRIPE_SET = 8;
    public static final byte IMAGE = 9;
    public static final byte ROUTER = 10;
    public static final byte TRADITIONAL = 11;
    public static final byte FLEXIBLE = 12;
    public static final byte LUN_IS_NOT_VIRTUALIZED = 0;
    public static final byte LUN_IS_VIRTUALIZED = 1;
    public static final byte LUN_IS_SVC_LUN = 2;
    public static final byte LUN_IDENTITY_NOT_KNOWN = 7;
    private static final String STRIPE_SET_STRING = MessageLog.getMessageNoID("GEN0170I");
    public static final String[] TYPES = new String[]{MessageLog.getMessageNoID("GEN0120I"), MessageLog.getMessageNoID("GEN0121I"), MessageLog.getMessageNoID("GEN0122I"), MessageLog.getMessageNoID("GEN0123I"), MessageLog.getMessageNoID("GEN0124I"), STRIPE_SET_STRING, MessageLog.getMessageNoID("GEN0171I"), MessageLog.getMessageNoID("GEN0183T"), STRIPE_SET_STRING, "", "", MessageLog.getMessageNoID("GEN7068I"), MessageLog.getMessageNoID("GEN7069I")};
    public static final String[] VDISK_TYPES = new String[]{MessageLog.getMessageNoID("GEN0251I"), MessageLog.getMessageNoID("GEN0252I"), MessageLog.getMessageNoID("GEN0183T"), "", "", "", "", "", "", MessageLog.getMessageNoID("GEN0253I")};
    private static final short SNAPSHOT = 1;
    private static final short VCM_DB = 2;
    private static final short REPLICATION_MASK = 12;
    private static final short REPLICATION_SHIFT = 2;
    private static final short NOT_EXPOSED = 16;
    public static final short NOT_REPLICATED = 0;
    public static final short REPLICATION_SOURCE = 1;
    public static final short REPLICATION_TARGET = 2;
    public static final short NO_COPY_RELATIONSHIP = 0;
    public static final short FC_SOURCE = 1;
    public static final short FC_TARGET = 2;
    public static final short UNKNOWN_TYPE = 0;
    public static final short FIXED_BLOCK = 1;
    public static final short VARIABLE_BLOCK = 2;
    public static final short CKD = 3;
    public static final String[] FORMATS = new String[]{VolGroup.FORMATS[0], VolGroup.FORMATS[1], VolGroup.FORMATS[2], VolGroup.FORMATS[3], VolGroup.FORMATS[4], VolGroup.FORMATS[5], VolGroup.FORMATS[6], VolGroup.FORMATS[7], VolGroup.FORMATS[8]};

    public static boolean isCKD(short s) {
        boolean bl = false;
        switch (s) {
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                bl = true;
            }
        }
        return bl;
    }

    public boolean equals(Object object) {
        LogicalDisk logicalDisk = (LogicalDisk)object;
        return logicalDisk.ldType == this.ldType && logicalDisk.ldRaid == this.ldRaid && logicalDisk.ldMirrorCount == this.ldMirrorCount && logicalDisk.ldCapacity == this.ldCapacity && logicalDisk.ldIsSwap == this.ldIsSwap && logicalDisk.ldOverhead == this.ldOverhead && logicalDisk.ldStorageType == this.ldStorageType && logicalDisk.ldCopyServices == this.ldCopyServices;
    }

    public boolean isSnapshot() {
        return (this.ldFlags & 1) != 0;
    }

    public boolean isVCMDB() {
        return (this.ldFlags & 2) != 0;
    }

    public byte getReplicationMode() {
        return (byte)((this.ldFlags & 0xC) >> 2);
    }

    public boolean notExposed() {
        return (this.ldFlags & 0x10) != 0;
    }

    public int setSnapSourceID() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogicalDisk.class.getName(), "setSnapSourceID", "");
        }
        this.ldSnapSourceID = !this.isSnapshot() ? -1 : (this.ldSnapSource != null ? this.ldSnapSource.ldID : 0);
        int n = this.ldSnapSourceID;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogicalDisk.class.getName(), "setSnapSourceID", n);
        }
        return n;
    }

    public short getFlags() {
        return this.ldFlags;
    }

    public void setFlags(short s, boolean bl, boolean bl2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogicalDisk.class.getName(), "setFlags", "replicationMode, pVCMDB, pNotExposed");
        }
        this.ldFlags = (short)(s << 2);
        if (this.ldSnapSourceID >= 0) {
            this.ldFlags = (short)(this.ldFlags | 1);
        }
        if (bl) {
            this.ldFlags = (short)(this.ldFlags | 2);
        }
        if (bl2) {
            this.ldFlags = (short)(this.ldFlags | 0x10);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogicalDisk.class.getName(), "setFlags");
        }
    }

    public void setFlags(short s) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(LogicalDisk.class.getName(), "setFlags", "opaque");
        }
        this.ldFlags = s;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(LogicalDisk.class.getName(), "setFlags");
        }
    }

    private void pack(boolean bl) {
        ChunkCollection chunkCollection = this.ldCollectionList;
        while (chunkCollection != null) {
            if (chunkCollection.ccPackedChunkList == null || chunkCollection.ccChunkList != null) {
                chunkCollection.ccPackedChunkList = Chunk.packByCollection(chunkCollection.ccChunkList);
                chunkCollection.ccChunkList = null;
            }
            chunkCollection = chunkCollection.ccNext;
        }
        this.ldPackedCollectionList = ChunkCollection.pack(this.ldCollectionList);
        this.ldCollectionList = null;
        this.ldPackedLunWWNs = (LunWWN[])Packer.pack(this.ldLunWWNs);
        this.ldLunWWNs = null;
        if (bl) {
            int n = 0;
            LogicalDisk logicalDisk = this.ldNextMirror;
            while (logicalDisk != null) {
                ++n;
                logicalDisk = logicalDisk.ldNextMirror;
            }
            this.ldPackedMirrors = new LogicalDisk[n];
            n = 0;
            logicalDisk = this.ldNextMirror;
            while (logicalDisk != null) {
                this.ldPackedMirrors[n] = logicalDisk;
                logicalDisk.pack(false);
                ++n;
                logicalDisk = logicalDisk.ldNextMirror;
            }
            this.ldNextMirror = null;
        }
    }

    public void pack() {
        this.pack(true);
    }

    private void unpack(boolean bl) {
        if (bl) {
            int n = this.ldPackedMirrors == null ? 0 : this.ldPackedMirrors.length;
            while (n > 0) {
                LogicalDisk logicalDisk = this.ldPackedMirrors[--n];
                logicalDisk.ldNextMirror = this.ldNextMirror;
                this.ldNextMirror = logicalDisk;
                logicalDisk.unpack(false);
            }
        }
        this.ldCollectionList = ChunkCollection.unpack(this.ldPackedCollectionList);
        this.ldPackedCollectionList = null;
        ChunkCollection chunkCollection = this.ldCollectionList;
        while (chunkCollection != null) {
            chunkCollection.ccChunkList = Chunk.unpackByCollection(chunkCollection.ccPackedChunkList);
            chunkCollection = chunkCollection.ccNext;
        }
        this.ldLunWWNs = (LunWWN)Packer.unpack(this.ldPackedLunWWNs);
    }

    public void unpack() {
        this.unpack(true);
    }

    public static LogicalDisk[] packLDs(LogicalDisk logicalDisk) {
        int n = 0;
        LogicalDisk logicalDisk2 = logicalDisk;
        while (logicalDisk2 != null) {
            ++n;
            logicalDisk2 = logicalDisk2.ldNext;
        }
        LogicalDisk[] logicalDiskArray = new LogicalDisk[n];
        n = 0;
        while (logicalDisk != null) {
            logicalDiskArray[n] = logicalDisk;
            ++n;
            logicalDisk2 = logicalDisk.ldNext;
            logicalDisk.ldNext = null;
            logicalDisk = logicalDisk2;
        }
        return logicalDiskArray;
    }

    public static LogicalDisk unpackLDs(LogicalDisk[] logicalDiskArray) {
        LogicalDisk logicalDisk;
        int n = 0;
        if (logicalDiskArray != null) {
            n = logicalDiskArray.length;
        }
        if (n == 0) {
            return null;
        }
        LogicalDisk logicalDisk2 = logicalDisk = logicalDiskArray[0];
        int n2 = 1;
        while (n2 < n) {
            LogicalDisk logicalDisk3;
            logicalDisk2.ldNext = logicalDisk3 = logicalDiskArray[n2];
            logicalDisk2 = logicalDisk3;
            ++n2;
        }
        return logicalDisk;
    }

    public boolean isComplex() {
        boolean bl = false;
        switch (this.ldType) {
            case 3: 
            case 5: 
            case 6: {
                bl = true;
            }
        }
        return bl;
    }
}

