/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.common;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import org.eclipse.aperi.TStorm.common.ReportDataAdjuster;
import org.eclipse.aperi.common.TableCellStrings;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.xmsg.MessageLog;

public class WriteReports {
    private static final String PRINTED_ON = MessageLog.getMessageNoID("GEN0193L");
    PrintWriter writer;
    DateFormat df = DateFormat.getDateTimeInstance(3, 3);
    DecimalFormat d0Fmt = new DecimalFormat();
    private static final DecimalFormat d2Fmt = new DecimalFormat("###0.00");
    static final String[] BLANKS;
    static final char[] CHARS;

    static {
        String[] stringArray = new String[11];
        stringArray[1] = " ";
        stringArray[2] = "  ";
        stringArray[3] = "   ";
        stringArray[4] = "    ";
        stringArray[5] = "     ";
        stringArray[6] = "      ";
        stringArray[7] = "       ";
        stringArray[8] = "        ";
        stringArray[9] = "         ";
        stringArray[10] = "          ";
        BLANKS = stringArray;
        CHARS = new char[]{' ', '/', '\\'};
    }

    public void writeCSV(ReportDataAdjuster reportDataAdjuster, PrintWriter printWriter, int[] nArray, boolean bl, boolean bl2, int[] nArray2) {
        String string;
        int n;
        int n2;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(WriteReports.class.getName(), "writeCSV", "adjuster, pWriter, columnArray, includeHeaders, includeTotals, rowMap");
        }
        d2Fmt.setMaximumFractionDigits(2);
        this.writer = printWriter;
        String[] stringArray = reportDataAdjuster.getLabels();
        int n3 = stringArray.length;
        int n4 = reportDataAdjuster.getNumberFrozenRows();
        int n5 = reportDataAdjuster.getNumberRows() + n4;
        int[] nArray3 = reportDataAdjuster.getRenderers();
        if (bl) {
            int n6;
            int n7;
            n2 = reportDataAdjuster.getNumberSpannedRows();
            boolean[] blArray = new boolean[n3];
            String string2 = "";
            if (n2 > 0) {
                n7 = 0;
                while (n7 < nArray.length) {
                    n = nArray[n7];
                    stringArray[n].length();
                    n6 = n + 1;
                    if (n6 < stringArray.length && stringArray[n6].length() == 0) {
                        blArray[n] = true;
                        ++n7;
                    }
                    ++n7;
                }
            }
            n6 = 0;
            n7 = 0;
            while (n7 < nArray.length) {
                if (n7 > 0) {
                    this.writer.print(",");
                }
                n = nArray[n7];
                boolean bl3 = false;
                string = Util.getTranslatedName(stringArray[n].trim());
                if (blArray[n]) {
                    n6 = 1;
                    string2 = string = String.valueOf(string) + Util.getString("COLON");
                }
                if (n6 != 0 && string.length() == 0 && !blArray[n]) {
                    n6 = 1;
                    string = string2;
                } else if (!blArray[n]) {
                    n6 = 0;
                }
                if (string.length() > 0) {
                    this.writer.print(string.trim());
                } else {
                    bl3 = true;
                }
                int n8 = 0;
                while (n8 < n4) {
                    string = Util.getTranslatedName(reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n8, nArray2), n).toString());
                    if (string.trim().length() > 0) {
                        if (!bl3) {
                            string = " " + string;
                        }
                        bl3 = false;
                        this.writer.print(string);
                    }
                    ++n8;
                }
                ++n7;
            }
            this.writer.println();
        }
        if (!bl2 && reportDataAdjuster.hasTotalsRow()) {
            ++n4;
        }
        n2 = n4;
        while (n2 < n5) {
            int n9 = 0;
            while (n9 < nArray.length) {
                StringBuffer stringBuffer;
                if (n9 > 0) {
                    this.writer.print(",");
                }
                n = nArray[n9];
                Object object = reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n2, nArray2), n);
                if (object == null) {
                    string = " ";
                } else if (Variables.spaceUnits != 0 && nArray3[n] == 7) {
                    long l = ((Number)object).longValue();
                    string = l == -2L || l == -1024L ? "" : (l < 0L ? MessageLog.getMessageNoID("STG0019T") : (Variables.spaceUnits == 1 ? Double.toString((double)l / 1024.0) : (Variables.spaceUnits == 2 ? Double.toString((double)l / 1048576.0) : (Variables.spaceUnits == 3 ? Double.toString((double)l / 1.073741824E9) : Double.toString((double)(l /= 0x100000L) / 1048576.0)))));
                } else if (object instanceof Date) {
                    string = TableCellStrings.DateRenderer(object, this.df);
                } else if (nArray3[n] == 6) {
                    if (((Number)object).longValue() == -2L) {
                        string = "";
                    } else if (((Number)object).longValue() < 0L) {
                        string = "-1";
                    } else {
                        ((Number)object).doubleValue();
                        int n10 = reportDataAdjuster.getScale();
                        n10 = 1;
                        if (object == null) {
                            string = "";
                        } else if (((Number)object).intValue() < 0) {
                            string = "-1";
                        } else {
                            stringBuffer = new StringBuffer();
                            stringBuffer.setLength(0);
                            stringBuffer.append(((Number)object).intValue() / n10);
                            stringBuffer.append('.');
                            stringBuffer.append(((Number)object).intValue() % n10);
                            string = stringBuffer.toString();
                        }
                    }
                } else if (nArray3[n] == 2) {
                    if (((Number)object).longValue() == -2L) {
                        string = "";
                    } else if (((Number)object).longValue() < 0L) {
                        string = "-1";
                    } else {
                        int n11 = reportDataAdjuster.getScale();
                        if (n11 == 0) {
                            n11 = 1;
                        }
                        if (object == null) {
                            string = "";
                        } else if (((Number)object).intValue() < 0) {
                            string = "-1";
                        } else {
                            stringBuffer = new StringBuffer();
                            stringBuffer.setLength(0);
                            stringBuffer.append(((Number)object).intValue() / n11);
                            stringBuffer.append('.');
                            stringBuffer.append(((Number)object).intValue() % n11);
                            string = stringBuffer.toString();
                        }
                    }
                } else {
                    string = object.toString();
                    if (!(object instanceof Number)) {
                        string = WriteReports.adjustString(string);
                    } else if (((Number)object).longValue() < 0L) {
                        string = "-1";
                    }
                }
                this.writer.print(string);
                ++n9;
            }
            this.writer.println();
            ++n2;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(WriteReports.class.getName(), "writeCSV");
        }
    }

    public static String adjustString(String string) {
        int n = string.indexOf(34);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(200);
            int n2 = 0;
            while (n >= 0) {
                stringBuffer.append(string.substring(n2, ++n));
                stringBuffer.append('\"');
                if (n > string.length()) break;
                n2 = n;
                n = string.indexOf(34, n2);
            }
            if (n < 0) {
                stringBuffer.append(string.substring(n2));
            }
            string = stringBuffer.toString();
        }
        if ((n = string.indexOf(44)) >= 0) {
            string = "\"" + string + "\"";
        }
        try {
            double d = new Double(string);
            if (d < 0.0) {
                string = "-1";
            }
        }
        catch (Exception exception) {}
        return string;
    }

    public void writeFormatted(ReportDataAdjuster reportDataAdjuster, PrintWriter printWriter, int[] nArray, int[] nArray2) {
        String string;
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(WriteReports.class.getName(), "writeFormatted", "adjuster, pWriter, columnArray, rowMap");
        }
        this.writer = printWriter;
        this.writer.print(PRINTED_ON);
        this.writer.print(" ");
        this.writer.println(DateFormat.getDateTimeInstance(2, 2).format(new Date()));
        this.writer.println();
        this.d0Fmt.setMaximumFractionDigits(2);
        StringBuffer stringBuffer = new StringBuffer(25);
        int n6 = reportDataAdjuster.getScale();
        String string2 = reportDataAdjuster.getSuffix();
        String[] stringArray = reportDataAdjuster.getLabels();
        int n7 = stringArray.length;
        int n8 = reportDataAdjuster.getNumberFrozenRows();
        int n9 = reportDataAdjuster.getNumberSpannedRows();
        int[] nArray3 = new int[n7];
        int[] nArray4 = reportDataAdjuster.getRenderers();
        int n10 = reportDataAdjuster.getNumberRows() + n8;
        int n11 = 0;
        if (n9 > 0) {
            n11 = n9 - 1;
        }
        int n12 = 0;
        while (n12 < nArray.length) {
            n5 = nArray[n12];
            n4 = nArray4[n5];
            int n13 = 0;
            n3 = n8;
            while (n3 < n10) {
                object = reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n3, nArray2), n5);
                switch (n4) {
                    case 0: {
                        if (object == null) {
                            n2 = 1;
                            break;
                        }
                        n2 = ((String)object).length();
                        break;
                    }
                    case 7: {
                        n2 = TableCellStrings.SpaceRenderer(object).length();
                        break;
                    }
                    case 1: {
                        n2 = TableCellStrings.DateRenderer(object, this.df).length();
                        break;
                    }
                    case 2: {
                        n2 = TableCellStrings.DecimalRenderer(n6, string2, object, stringBuffer).length();
                        break;
                    }
                    case 5: {
                        n2 = TableCellStrings.NumberRenderer(object, this.d0Fmt).length();
                        break;
                    }
                    case 4: {
                        n2 = TableCellStrings.MegabyteRenderer(object, this.d0Fmt).length();
                        break;
                    }
                    case 6: {
                        n2 = TableCellStrings.PercentRenderer(object, this.d0Fmt).length();
                        break;
                    }
                    case 3: {
                        n2 = TableCellStrings.DurationRenderer(object, stringBuffer).length();
                        break;
                    }
                    case 8: {
                        n2 = TableCellStrings.SpaceNoDecimalRenderer(object).length();
                        break;
                    }
                    case 9: {
                        n2 = Util.formatHertz(((Number)object).intValue()).length();
                        break;
                    }
                    default: {
                        n2 = 1;
                    }
                }
                if (n2 > n13) {
                    n13 = n2;
                }
                ++n3;
            }
            nArray3[n5] = n13;
            ++n12;
        }
        n12 = n11;
        while (n12 < n8) {
            n3 = 0;
            while (n3 < nArray.length) {
                n5 = nArray[n3];
                n2 = ((String)reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n12, nArray2), n5)).length();
                if (n2 > nArray3[n5]) {
                    nArray3[n5] = n2;
                }
                ++n3;
            }
            ++n12;
        }
        if (n9 > 0) {
            int n14;
            boolean[] blArray = new boolean[n7];
            int n15 = 0;
            while (n15 < nArray.length) {
                n5 = nArray[n15];
                n3 = stringArray[n5].length();
                n12 = n5 + 1;
                if (n12 < stringArray.length && stringArray[n12].length() == 0) {
                    n = nArray3[n5] + nArray3[n12];
                    if (n3 > n) {
                        n3 -= n;
                        ++n3;
                        int n16 = n5;
                        nArray3[n16] = nArray3[n16] + (n3 /= 2);
                        int n17 = n12;
                        nArray3[n17] = nArray3[n17] + n3;
                    }
                    blArray[n5] = true;
                    ++n15;
                } else if (n3 > nArray3[n5]) {
                    nArray3[n5] = n3;
                }
                ++n15;
            }
            n15 = 0;
            while (n15 < n9 - 1) {
                n14 = 0;
                while (n14 < nArray.length) {
                    n5 = nArray[n14];
                    n3 = ((String)reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n15, nArray2), n5)).length();
                    if (blArray[n5]) {
                        n12 = n5 + 1;
                        n = nArray3[n5] + nArray3[n12];
                        if (n3 > n) {
                            n3 -= n;
                            ++n3;
                            int n18 = n5;
                            nArray3[n18] = nArray3[n18] + (n3 /= 2);
                            int n19 = n12;
                            nArray3[n19] = nArray3[n19] + n3;
                        }
                        ++n14;
                    } else if (n3 > nArray3[n5]) {
                        nArray3[n5] = n3;
                    }
                    ++n14;
                }
                ++n15;
            }
            this.writer.print('|');
            n15 = 0;
            while (n15 < nArray.length) {
                n5 = nArray[n15];
                if (blArray[n5]) {
                    this.center(stringArray[n5], nArray3[n5] + nArray3[++n5] + 1);
                    ++n15;
                } else {
                    this.writer.print(stringArray[n5]);
                    this.pad(nArray3[n5] - stringArray[n5].length());
                }
                this.writer.print('|');
                ++n15;
            }
            this.writer.println();
            n15 = 0;
            while (n15 < n9 - 1) {
                this.writer.print('|');
                n14 = 0;
                while (n14 < nArray.length) {
                    n5 = nArray[n14];
                    string = (String)reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n15, nArray2), n5);
                    if (blArray[n5]) {
                        this.center(string, nArray3[n5] + nArray3[++n5] + 1);
                        ++n14;
                    } else {
                        this.writer.print(string);
                        this.pad(nArray3[n5] - string.length());
                    }
                    this.writer.print('|');
                    ++n14;
                }
                this.writer.println();
                ++n15;
            }
            n15 = n11;
            while (n15 < n8) {
                this.writer.print('|');
                n14 = 0;
                while (n14 < nArray.length) {
                    n5 = nArray[n14];
                    string = (String)reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n15, nArray2), n5);
                    this.writer.print(string);
                    this.pad(nArray3[n5] - string.length());
                    this.writer.print('|');
                    ++n14;
                }
                this.writer.println();
                ++n15;
            }
        } else {
            n12 = 0;
            while (n12 < nArray.length) {
                n5 = nArray[n12];
                if (stringArray[n5].length() > nArray3[n5]) {
                    nArray3[n5] = stringArray[n5].length();
                }
                ++n12;
            }
            this.writer.print('|');
            n12 = 0;
            while (n12 < nArray.length) {
                n5 = nArray[n12];
                this.writer.print(stringArray[n5]);
                this.pad(nArray3[n5] - stringArray[n5].length());
                this.writer.print('|');
                ++n12;
            }
            this.writer.println();
            if (n8 > 0) {
                n12 = 0;
                while (n12 < n8) {
                    this.writer.print('|');
                    n3 = 0;
                    while (n3 < nArray.length) {
                        n5 = nArray[n3];
                        string = (String)reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n12, nArray2), n5);
                        this.writer.print(string);
                        this.pad(nArray3[n5] - string.length());
                        this.writer.print('|');
                        ++n3;
                    }
                    this.writer.println();
                    ++n12;
                }
            }
        }
        this.writer.print('|');
        n3 = nArray.length - 1;
        n = 0;
        while (n < nArray.length) {
            n5 = nArray[n];
            n12 = nArray3[n5];
            while (n12 > 0) {
                this.writer.print("-");
                --n12;
            }
            if (n < n3) {
                this.writer.print('+');
            }
            ++n;
        }
        this.writer.print('|');
        this.writer.println();
        n = n8;
        while (n < n10) {
            this.writer.print('|');
            int n20 = 0;
            while (n20 < nArray.length) {
                n5 = nArray[n20];
                n4 = nArray4[n5];
                object = reportDataAdjuster.getCellData(reportDataAdjuster.getRowIndex(n, nArray2), n5);
                switch (n4) {
                    case 0: {
                        if (object == null) {
                            string = " ";
                            break;
                        }
                        string = object.toString();
                        break;
                    }
                    case 7: {
                        string = TableCellStrings.SpaceRenderer(object);
                        break;
                    }
                    case 1: {
                        string = TableCellStrings.DateRenderer(object, this.df);
                        break;
                    }
                    case 2: {
                        string = TableCellStrings.DecimalRenderer(n6, string2, object, stringBuffer);
                        break;
                    }
                    case 5: {
                        string = TableCellStrings.NumberRenderer(object, this.d0Fmt);
                        break;
                    }
                    case 4: {
                        string = TableCellStrings.MegabyteRenderer(object, this.d0Fmt);
                        break;
                    }
                    case 6: {
                        string = TableCellStrings.PercentRenderer(object, this.d0Fmt);
                        break;
                    }
                    case 3: {
                        string = TableCellStrings.DurationRenderer(object, stringBuffer);
                        break;
                    }
                    case 8: {
                        string = TableCellStrings.SpaceNoDecimalRenderer(object);
                        break;
                    }
                    case 9: {
                        string = Util.formatHertz(((Number)object).intValue());
                        break;
                    }
                    default: {
                        string = " ";
                    }
                }
                if (object instanceof Number) {
                    this.pad(nArray3[n5] - string.length());
                    this.writer.print(string);
                } else {
                    this.writer.print(string);
                    this.pad(nArray3[n5] - string.length());
                }
                this.writer.print('|');
                ++n20;
            }
            this.writer.println();
            ++n;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(WriteReports.class.getName(), "writeFormatted");
        }
    }

    public static String adjustFileName(String string) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry(WriteReports.class.getName(), "adjustFileName", "fileName");
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        int n = 0;
        while (n < CHARS.length) {
            int n2 = 0;
            int n3 = string.indexOf(CHARS[n]);
            while (n3 >= 0) {
                stringBuffer.append(string.substring(n2, n3));
                n2 = n3 + 1;
                n3 = string.indexOf(CHARS[n], n2);
            }
            if (n2 < string.length()) {
                stringBuffer.append(string.substring(n2));
            }
            string = stringBuffer.toString();
            stringBuffer.setLength(0);
            ++n;
        }
        String string2 = string;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit(WriteReports.class.getName(), "adjustFileName", string2);
        }
        return string2;
    }

    private void center(String string, int n) {
        int n2 = (n -= string.length()) % 2;
        this.pad(n /= 2);
        this.writer.print(string);
        this.pad(n += n2);
    }

    private void pad(int n) {
        while (n > 10) {
            this.writer.print(BLANKS[10]);
            n -= 10;
        }
        if (n > 0) {
            this.writer.print(BLANKS[n]);
        }
    }
}

