/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.ComputersAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerData
extends JPanel
implements GuiRequestor {
    private GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints gbcFill_1 = new GridBagConstraints();
    private GridBagConstraints gbcFill_2 = new GridBagConstraints();
    private GridBagConstraints gbcLabel = new GridBagConstraints();
    private GridBagConstraints gbcLast = new GridBagConstraints();
    private JLabel title = new JLabel(MessageLog.getMessageNoID("STG1101L"));
    private JLabel lComp = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1102L")) + "    ");
    private JLabel lGroup = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1103L")) + "    ");
    private JLabel lDomain = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1104L")) + "    ");
    private JLabel lCluster = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1136L")) + "    ");
    private JLabel lNodeHosting = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1139L")) + "    ");
    private JLabel lManuf = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1105L")) + "    ");
    private JLabel lModel = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1106L")) + "    ");
    private JLabel lSerNum = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1107L")) + "    ");
    private JLabel lOSType = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1108L")) + "    ");
    private JLabel lOSVersion = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1109L")) + "    ");
    private JLabel lCPUArch = new JLabel(String.valueOf(MessageLog.getMessageNoID("GEN0218T")) + "     ");
    private JLabel lProcType = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1110L")) + "    ");
    private JLabel lProcSpeed = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1111L")) + "    ");
    private JLabel lProcCount = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1112L")) + "    ");
    private JLabel lRAM = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1113L")) + "    ");
    private JLabel lSwapSpc = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1114L")) + "    ");
    private JLabel lDiskCap = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1115L")) + "    ");
    private JLabel lDiskFS = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1116L")) + "    ");
    private JLabel lOwnDiskCap = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG6003L")) + "    ");
    private JLabel lOwnFS = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG6004L")) + "    ");
    private JLabel lFileSFS = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1117L")) + "    ");
    private JLabel lLastBoot = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1118L")) + "    ");
    private JLabel lLastProbe = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1119L")) + "    ");
    private JLabel lProbeStatus = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1120L")) + "    ");
    private JLabel lNetworkaddr = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1281L")) + "    ");
    private JLabel lIPaddress = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1280L")) + "    ");
    private JLabel lTimezone = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1282L")) + "    ");
    private JLabel lDiscovered = new JLabel(String.valueOf(MessageLog.getMessageNoID("STG1134L")) + "    ");
    private JLabel dComp = new JLabel();
    private JLabel dNodeHosting = new JLabel();
    private JLabel dGroup = new JLabel();
    private JLabel dDomain = new JLabel();
    private JLabel dCluster = new JLabel();
    private JLabel dManuf = new JLabel();
    private JLabel dModel = new JLabel();
    private JLabel dSerNum = new JLabel();
    private JLabel dOSType = new JLabel();
    private JLabel dOSVersion = new JLabel();
    private JLabel dCPUArch = new JLabel();
    private JLabel dProcType = new JLabel();
    private JLabel dProcSpeed = new JLabel();
    private JLabel dProcCount = new JLabel();
    private JLabel dRAM = new JLabel();
    private JLabel dSwapSpc = new JLabel();
    private JLabel dDiskCap = new JLabel();
    private JLabel dDiskFS = new JLabel();
    private JLabel dOwnDiskCap = new JLabel();
    private JLabel dOwnFS = new JLabel();
    private JLabel dFileSFS = new JLabel();
    private JLabel dLastBoot = new JLabel();
    private JLabel dLastProbe = new JLabel();
    private JLabel dProbeStatus = new JLabel();
    private JLabel dNetworkaddr = new JLabel();
    private JLabel dIPaddress = new JLabel();
    private JLabel dTimezone = new JLabel();
    private JLabel dDiscovered = new JLabel();
    private JLabel blank1 = new JLabel(" ");
    private JLabel blank2 = new JLabel(" ");
    private JLabel blank3 = new JLabel(" ");
    private JLabel blank4 = new JLabel(" ");
    private JLabel blank5 = new JLabel(" ");
    private JLabel filler1 = new JLabel(" ");
    private JLabel filler2 = new JLabel(" ");
    private JLabel filler3 = new JLabel("                  ");
    private final String NOT_APPLICABLE = MessageLog.getMessageNoID("STG0019T");
    private final String NOT_AVAILABLE = MessageLog.getMessageNoID("GEN0185T");

    public ComputerData(int n) {
        Request request = new Request();
        GuiRequest.computerInfo(request, n);
        GuiClient.doRequest(this, request);
        this.setLayout(this.gridBag);
        this.gbcFill_1.gridheight = 35;
        this.gbcFill_1.weighty = 1.0;
        this.gbcFill_1.ipadx = 60;
        this.gbcFill_2.gridwidth = 2;
        this.gbcFill_2.weightx = 1.0;
        this.gbcLabel.anchor = 17;
        this.gbcLast.anchor = 17;
        this.gbcLast.gridwidth = 0;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        Computer computer = (Computer)response.responseData;
        boolean bl = Constants.isVirtualServer(computer.cmpOSType);
        this.dComp.setText(GuiUtil.getComputer((int)computer.cmpID).gcTSName);
        if (computer.cmpGroup.getGrpName() != null) {
            this.dGroup.setText(computer.cmpGroup.getGrpName());
        } else {
            this.dGroup.setText(this.NOT_APPLICABLE);
        }
        if (computer.cmpNodeHostedID > 0) {
            this.dNodeHosting.setText(GuiUtil.getComputer((int)computer.cmpNodeHostedID).gcTSName);
        }
        if (computer.cmpDomain.domName != null) {
            this.dDomain.setText(computer.cmpDomain.domName);
        } else {
            this.dDomain.setText(this.NOT_APPLICABLE);
        }
        if (computer.cmpManufacturer.toLowerCase().equals("unknown")) {
            this.dManuf.setText(MessageLog.getMessageNoID("STG1020L"));
        } else {
            this.dManuf.setText(computer.cmpManufacturer);
        }
        if (computer.cmpModel == null || computer.cmpModel.equals(" ") || computer.cmpModel.equals("")) {
            this.dModel.setText(this.NOT_APPLICABLE);
        } else {
            this.dModel.setText(computer.cmpModel);
        }
        if (computer.cmpSerialNumber == null || computer.cmpSerialNumber.equals(" ") || computer.cmpSerialNumber.equals("")) {
            this.dSerNum.setText(this.NOT_APPLICABLE);
        } else {
            this.dSerNum.setText(computer.cmpSerialNumber);
        }
        this.dOSType.setText(MessageLog.getMessageNoID(Constants.OSTYPES[computer.cmpOSType]));
        if (computer.cmpOSVersion == null || computer.cmpOSVersion.equals(" ") || computer.cmpOSVersion.equals("")) {
            this.dOSVersion.setText(this.NOT_APPLICABLE);
        } else {
            this.dOSVersion.setText(computer.cmpOSVersion);
        }
        this.dCPUArch.setText(Constants.getCPUArchDisplayName(computer.cmpCPUArchitecture));
        if (computer.cmpProcessorType == null || computer.cmpProcessorType.equals(" ") || computer.cmpProcessorType.equals("")) {
            this.dProcType.setText(this.NOT_APPLICABLE);
        } else {
            this.dProcType.setText(computer.cmpProcessorType);
        }
        this.dProcSpeed.setText(Util.formatHertz(computer.cmpProcessorSpeed));
        if (computer.cmpProcessorCount <= 0) {
            this.dProcCount.setText(this.NOT_AVAILABLE);
        } else {
            this.dProcCount.setText(Short.toString(computer.cmpProcessorCount));
        }
        this.dRAM.setText(Util.formatBytes((long)computer.cmpRAM * 1024L * 1024L, false));
        this.dSwapSpc.setText(Util.formatBytes((long)computer.cmpSwapSpace * 1024L * 1024L, false));
        this.dDiskCap.setText(Util.formatBytes(computer.cmpDiskCapacity * 512L));
        this.dDiskFS.setText(Util.formatBytes(computer.cmpDiskFreeSpace * 512L));
        this.dOwnDiskCap.setText(Util.formatBytes(computer.cmpOwnedDiskCap * 512L));
        this.dOwnFS.setText(Util.formatBytes(computer.cmpOwnedDiskFreeSp * 512L));
        this.dFileSFS.setText(Util.formatBytes(computer.cmpFilesystemFreeSpace * 512L));
        if (computer.cmpLastBootTime < 1L) {
            this.dLastBoot.setText(this.NOT_AVAILABLE);
        } else {
            this.dLastBoot.setText(DateFormat.getDateTimeInstance().format(new Date(computer.cmpLastBootTime)));
        }
        if (computer.cmpLastProbeTime < 1L) {
            this.dLastProbe.setText(this.NOT_AVAILABLE);
        } else {
            this.dLastProbe.setText(DateFormat.getDateTimeInstance().format(new Date(computer.cmpLastProbeTime)));
        }
        if (computer.cmpDiscoveredTime < 1L) {
            this.dDiscovered.setText(this.NOT_AVAILABLE);
        } else {
            this.dDiscovered.setText(DateFormat.getDateTimeInstance().format(new Date(computer.cmpDiscoveredTime)));
        }
        this.dProbeStatus.setText(ComputersAdjuster.probeStatus[computer.cmpProbeStatus]);
        GComputer gComputer = GuiUtil.getComputer(computer.cmpID);
        if (gComputer.gcNetworkName == null || gComputer.gcNetworkName.equals(" ")) {
            this.dNetworkaddr.setText(this.NOT_AVAILABLE);
        } else {
            this.dNetworkaddr.setText(Util.getDotName(gComputer.gcNetworkName, gComputer.gcDomainName));
        }
        if (gComputer.gcIpAddress == null || gComputer.gcIpAddress.equals("") || gComputer.gcIpAddress.equals(" ") || gComputer.gcIpAddress.charAt(0) == '0' && gComputer.gcIpAddress.charAt(1) == '.') {
            this.dIPaddress.setText(this.NOT_AVAILABLE);
        } else {
            this.dIPaddress.setText(gComputer.gcIpAddress);
        }
        this.dTimezone.setText(Util.formatTimeZone(gComputer.gcTimezoneID));
        this.add((Component)this.filler1, this.gbcFill_1);
        this.add((Component)this.filler2, this.gbcFill_2);
        this.add((Component)this.filler3, this.gbcLast);
        this.add((Component)this.title, this.gbcLast);
        if (bl) {
            this.title.setText(MessageLog.getMessageNoID("STG1138L"));
        }
        this.add((Component)this.blank1, this.gbcLast);
        this.add((Component)this.lComp, this.gbcLabel);
        if (bl) {
            this.lComp.setText(MessageLog.getMessageNoID("STG1034L"));
        }
        this.add((Component)this.dComp, this.gbcLast);
        if (computer.cmpCluster != null) {
            this.add((Component)this.lCluster, this.gbcLabel);
            this.dCluster.setText(computer.cmpCluster.clusterName);
            this.add((Component)this.dCluster, this.gbcLast);
        }
        if (bl) {
            this.add((Component)this.lNodeHosting, this.gbcLabel);
            this.add((Component)this.dNodeHosting, this.gbcLast);
        }
        this.add((Component)this.lGroup, this.gbcLabel);
        this.add((Component)this.dGroup, this.gbcLast);
        this.add((Component)this.lDomain, this.gbcLabel);
        this.add((Component)this.dDomain, this.gbcLast);
        this.add((Component)this.blank2, this.gbcLast);
        this.add((Component)this.lNetworkaddr, this.gbcLabel);
        this.add((Component)this.dNetworkaddr, this.gbcLast);
        this.add((Component)this.lIPaddress, this.gbcLabel);
        this.add((Component)this.dIPaddress, this.gbcLast);
        if (!bl) {
            this.add((Component)this.lTimezone, this.gbcLabel);
            this.add((Component)this.dTimezone, this.gbcLast);
            this.add((Component)new JLabel(" "), this.gbcLast);
            this.add((Component)this.lManuf, this.gbcLabel);
            this.add((Component)this.dManuf, this.gbcLast);
            this.add((Component)this.lModel, this.gbcLabel);
            this.add((Component)this.dModel, this.gbcLast);
            this.add((Component)this.lSerNum, this.gbcLabel);
            this.add((Component)this.dSerNum, this.gbcLast);
            this.add((Component)this.lProcType, this.gbcLabel);
            this.add((Component)this.dProcType, this.gbcLast);
            this.add((Component)this.lProcSpeed, this.gbcLabel);
            this.add((Component)this.dProcSpeed, this.gbcLast);
            this.add((Component)this.lProcCount, this.gbcLabel);
            this.add((Component)this.dProcCount, this.gbcLast);
            this.add((Component)this.lRAM, this.gbcLabel);
            this.add((Component)this.dRAM, this.gbcLast);
        }
        this.add((Component)this.blank3, this.gbcLast);
        this.add((Component)this.lOSType, this.gbcLabel);
        this.add((Component)this.dOSType, this.gbcLast);
        if (!bl) {
            this.add((Component)this.lOSVersion, this.gbcLabel);
            this.add((Component)this.dOSVersion, this.gbcLast);
            this.add((Component)this.lCPUArch, this.gbcLabel);
            this.add((Component)this.dCPUArch, this.gbcLast);
            this.add((Component)this.lSwapSpc, this.gbcLabel);
            this.add((Component)this.dSwapSpc, this.gbcLast);
        }
        this.add((Component)this.blank4, this.gbcLast);
        this.add((Component)this.lDiskCap, this.gbcLabel);
        this.add((Component)this.dDiskCap, this.gbcLast);
        this.add((Component)this.lDiskFS, this.gbcLabel);
        this.add((Component)this.dDiskFS, this.gbcLast);
        this.add((Component)this.lOwnDiskCap, this.gbcLabel);
        this.add((Component)this.dOwnDiskCap, this.gbcLast);
        this.add((Component)this.lOwnFS, this.gbcLabel);
        this.add((Component)this.dOwnFS, this.gbcLast);
        this.add((Component)this.lFileSFS, this.gbcLabel);
        this.add((Component)this.dFileSFS, this.gbcLast);
        this.add((Component)this.blank5, this.gbcLast);
        if (!bl) {
            this.add((Component)this.lLastBoot, this.gbcLabel);
            this.add((Component)this.dLastBoot, this.gbcLast);
        }
        this.add((Component)this.lDiscovered, this.gbcLabel);
        this.add((Component)this.dDiscovered, this.gbcLast);
        this.add((Component)this.lLastProbe, this.gbcLabel);
        this.add((Component)this.dLastProbe, this.gbcLast);
        this.add((Component)this.lProbeStatus, this.gbcLabel);
        this.add((Component)this.dProbeStatus, this.gbcLast);
        this.revalidate();
        this.repaint();
    }
}

