/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeExpansionEvent;
import org.eclipse.aperi.TStorm.gui.ComputerTreeNode;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ComputerTreeLabel
extends BaseTreeNode
implements GuiRequestor,
ActionListener {
    protected NameList[] computerList;
    private int osType;
    private int clusterID = 0;

    public ComputerTreeLabel(String string, int n) {
        super(MessageLog.getMessageNoID(string));
        this.osType = n;
    }

    public ComputerTreeLabel(String string, int n, int n2) {
        super(MessageLog.getMessageNoID(string));
        this.osType = n;
        this.clusterID = n2;
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        JPopupMenu jPopupMenu = super.getPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(MessageLog.getMessageNoID("STG0003L"));
        jMenuItem.setToolTipText(MessageLog.getMessageNoID("STG0004L"));
        jMenuItem.addActionListener(this);
        jPopupMenu.add(jMenuItem);
        super.showPopupMenu(jPopupMenu, mouseEvent);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.computerList = null;
        this.removeAllChildren();
        this.makeRequest();
    }

    public void expand(TreeExpansionEvent treeExpansionEvent) {
        if (this.computerList == null || this.computerList.length == 0) {
            this.makeRequest();
        }
    }

    private void makeRequest() {
        Request request = new Request();
        GuiRequest.computerList(request);
        GuiListReq guiListReq = (GuiListReq)request.requestData;
        if (this.clusterID < 1) {
            if (this.osType == 22) {
                guiListReq.computerID = this.clusterID;
                guiListReq.listRequested = 10099;
            } else {
                guiListReq.listRequested = 10001;
            }
        } else {
            guiListReq.listRequested = Constants.isVirtualServer(this.osType) ? (this.getUserObject().toString().equals(MessageLog.getMessageNoID("STG1032L")) ? 100 : 10001) : 101;
            guiListReq.computerID = this.clusterID;
        }
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            NameList nameList = (NameList)response.responseData;
            int n = 0;
            while (nameList != null) {
                ++n;
                nameList = nameList.nlNext;
            }
            this.computerList = new NameList[n];
            int n2 = 0;
            nameList = (NameList)response.responseData;
            while (nameList != null) {
                NameList nameList2 = nameList.nlNext;
                nameList.nlNext = null;
                this.computerList[n2++] = nameList;
                nameList = nameList2;
            }
            this.createNodes();
        }
    }

    public void createNodes() {
        int n = 0;
        while (n < this.computerList.length) {
            if (this.osType == -2 || this.osType == this.computerList[n].nlID2 || this.osType == -1) {
                this.addSorted(new ComputerTreeNode(this.computerList[n]));
            }
            ++n;
        }
        BaseTree.MyTree.nodeStructureChanged(this);
        guiMain.getBaseTree().repaint();
    }
}

