/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.event.ActionEvent;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTable;
import org.eclipse.aperi.TStorm.gui.ReportingSelectionTableDialog;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.TStorm.server.guireq.GuiSelectionReq;
import org.eclipse.aperi.TStorm.server.guireq.RespSelectionObject;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class DataReportingSelectionTable
extends ReportingSelectionTable {
    short quotaType;
    short members;
    GuiSelectionReq gsr;
    RespSelectionObject[] nodeArray;
    RespSelectionObject node;
    boolean byNetwork;

    public DataReportingSelectionTable(ReportingSelectionTableDialog reportingSelectionTableDialog, GuiReportReq guiReportReq, int n, Object[] objectArray) {
        super(reportingSelectionTableDialog, guiReportReq, n, objectArray);
        switch (n) {
            case 10: {
                this.objectType = 3;
                break;
            }
            case 11: {
                this.objectType = 4;
                break;
            }
            case 12: {
                if (guiReportReq.reportType == 5) {
                    this.objectType = 29;
                    break;
                }
                this.objectType = 5;
                break;
            }
            case 13: {
                this.objectType = 6;
                break;
            }
            case 82: {
                this.objectType = 28;
                break;
            }
            case 14: {
                this.objectType = 7;
                break;
            }
            case 27: {
                this.objectType = 11;
                break;
            }
            case 74: {
                this.objectType = 24;
                break;
            }
            case 77: 
            case 89: 
            case 90: {
                this.objectType = 24;
                break;
            }
            case 75: {
                this.objectType = 25;
                break;
            }
            case 109: {
                this.objectType = 31;
                break;
            }
            case 76: {
                this.objectType = 26;
                break;
            }
            case 73: {
                this.objectType = 27;
            }
        }
        if (this.objectType == -1) {
            this.status = -1;
        }
    }

    protected Request getRequest() {
        Request request = new Request();
        GuiRequest.selectionList(request);
        this.gsr = (GuiSelectionReq)request.requestData;
        this.gsr.objectType = this.objectType;
        this.gsr.reportType = this.grr.reportType;
        this.gsr.quotaType = this.quotaType;
        this.gsr.productCode = this.grr.productCode;
        this.gsr.dbmsType = this.grr.dbmsType;
        this.gsr.quotaMembers = this.members;
        return request;
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            this.status = -1;
        } else {
            int n = 0;
            this.gsr = (GuiSelectionReq)response.responseData;
            this.nodeArray = this.gsr.objectHdr;
            if (this.nodeArray != null) {
                while (n < this.nodeArray.length) {
                    this.node = this.nodeArray[n];
                    ++n;
                    if (this.gsr.computerColumn <= 0 || this.node.CID <= 0) continue;
                    this.node.stringArray[this.gsr.computerColumn] = this.gsr.appendUserComputerColumn > 0 ? String.valueOf(this.node.stringArray[this.gsr.computerColumn]) + " @ " + GuiUtil.getComputer((int)this.node.CID).gcTSName : GuiUtil.getComputer((int)this.node.CID).gcTSName;
                }
            }
            if (n != 0) {
                this.status = 2;
            } else {
                this.status = -1;
                GuiUtil.displayErrorMessage(MessageLog.getMessageNoTS("STG5011L", this.objectName));
            }
        }
        this.dialog.show();
    }

    protected int getCountValue() {
        return this.nodeArray.length;
    }

    protected void sortData() {
        if (this.gsr.sortColumns > 0) {
            int[] nArray = new int[this.gsr.sortColumns];
            int[] nArray2 = new int[this.gsr.sortColumns];
            int n = 0;
            while (n < this.gsr.sortColumns) {
                nArray[n] = n + 1;
                nArray2[n] = 1;
                ++n;
            }
            this.table.sortByColumn(nArray[0], nArray2[0]);
        }
    }

    public void selectRows(boolean bl) {
        if (this.reportSubtype == 30 || this.reportSubtype == 31 || this.reportSubtype == 88) {
            this.selectRows(this.grr.selectedUsers, this.grr.isUserInList);
        } else {
            this.selectRows(this.grr.selectedResources, this.grr.isResourceInList);
        }
        if (bl) {
            this.dataModel.fireTableDataChanged();
        }
    }

    protected void selectRows(int[] nArray, boolean bl) {
        if (nArray == null) {
            bl = false;
        }
        int n = 0;
        while (n < this.nodeArray.length) {
            boolean bl2 = this.nodeArray[n].selected = !bl;
            if (nArray != null) {
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] == this.nodeArray[n].ID) {
                        this.nodeArray[n].selected = bl;
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    public void setArray() throws GeneralException {
        int[] nArray = null;
        boolean bl = false;
        boolean bl2 = true;
        if (this.nodeArray == null) {
            bl = true;
        } else {
            int n = 0;
            int n2 = 0;
            while (n2 < this.nodeArray.length) {
                if (this.nodeArray[n2].selected) {
                    ++n;
                }
                ++n2;
            }
            if (n == 0) {
                bl = true;
            } else if (n < this.nodeArray.length) {
                n2 = this.nodeArray.length - n;
                bl2 = n <= 100 || n < n2;
                nArray = new int[bl2 ? n : n2];
                int n3 = 0;
                int n4 = 0;
                while (n4 < this.nodeArray.length) {
                    if (this.nodeArray[n4].selected == bl2) {
                        nArray[n3] = this.nodeArray[n4].ID;
                        ++n3;
                    }
                    ++n4;
                }
            }
        }
        if (bl) {
            String string = MessageLog.getMessageNoTS("STG5038L", this.objectName);
            throw new GeneralException(string);
        }
        if (this.reportSubtype == 30 || this.reportSubtype == 31 || this.reportSubtype == 88) {
            this.grr.selectedUsers = nArray;
            this.grr.isUserInList = bl2;
        } else {
            this.grr.selectedResources = nArray;
            this.grr.isResourceInList = bl2;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.selectButton) {
            int n = 0;
            while (n < this.nodeArray.length) {
                this.nodeArray[n].selected = true;
                ++n;
            }
        } else if (object == this.clearButton) {
            int n = 0;
            while (n < this.nodeArray.length) {
                this.nodeArray[n].selected = false;
                ++n;
            }
        }
        this.dataModel.fireTableDataChanged();
    }

    protected BaseTableModel getDataModel() {
        return new SelectionModel();
    }

    protected boolean isSelectedRow(int n) {
        return this.nodeArray[n].selected;
    }

    protected void setSelectedRow(int n, boolean bl) {
        this.nodeArray[n].selected = bl;
    }

    public boolean selectionChanged() {
        return this.grr.selectedResources != null || this.grr.selectedUsers != null;
    }

    class SelectionModel
    extends BaseTableModel {
        public SelectionModel() {
            this.columnNames = DataReportingSelectionTable.this.gsr.nameArray;
            this.rowCount = DataReportingSelectionTable.this.nodeArray.length;
        }

        public Object getTableDataItem(int n, int n2) {
            if (n2 == 0) {
                return new Boolean(DataReportingSelectionTable.this.nodeArray[n].selected);
            }
            if (DataReportingSelectionTable.this.gsr.typeArray[n2] == 1) {
                return Util.getTranslatedName(DataReportingSelectionTable.this.nodeArray[n].stringArray[n2]);
            }
            if (DataReportingSelectionTable.this.gsr.typeArray[n2] == 2) {
                DataReportingSelectionTable.this.mLong[n].value = DataReportingSelectionTable.this.nodeArray[n].longArray[n2];
                return DataReportingSelectionTable.this.mLong[n];
            }
            if (DataReportingSelectionTable.this.gsr.typeArray[n2] == 3) {
                DataReportingSelectionTable.this.mInt[n].value = (int)DataReportingSelectionTable.this.nodeArray[n].longArray[n2];
                return DataReportingSelectionTable.this.mInt[n];
            }
            return null;
        }
    }
}

