/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.xmsg.MessageLog;

class IPListEditor
extends EditableList {
    private JComponent panel;
    private NameList ips;
    private String desc;
    private static String invalidFormatTitle = MessageLog.getMessageNoID("GUI8214T");
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public IPListEditor(NameList nameList, String string) {
        super(" ", null, 5);
        this.ips = nameList;
        this.desc = string;
    }

    public JComponent getComponent() {
        while (this.ips != null) {
            this.addObject(this.ips.nlName);
            this.ips = this.ips.nlNext;
        }
        this.panel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.desc);
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.panel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        this.panel.add(Box.createHorizontalStrut(100), gridBagConstraints);
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        this.panel.add((Component)this, gridBagConstraints);
        return this.panel;
    }

    public void addObject(Object object) {
        String string = object.toString().trim();
        int n = this.listModel.size();
        boolean bl = true;
        while (bl && n > 0) {
            String string2;
            if (!(string2 = this.listModel.get(--n).toString()).equals(string)) continue;
            bl = false;
        }
        if (bl && this.simpleIPValidator(string)) {
            super.addObject(string);
        }
    }

    private boolean simpleIPValidator(String string) {
        String string2;
        if (string.indexOf(46) != -1 && !string.matches(string2 = "^[\\w]+\\.[\\w]+\\.[\\w]+\\.[\\w].*$")) {
            String string3 = MessageLog.getMessage("GUI8215E", string);
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), string3, invalidFormatTitle, 0);
            return false;
        }
        return true;
    }

    private static NameList makeNameList(Object object) {
        NameList nameList = new NameList();
        nameList.nlName = object.toString();
        return nameList;
    }

    public NameList getData() {
        NameList nameList = null;
        Object[] objectArray = this.getElements();
        if (objectArray != null && objectArray.length > 0) {
            NameList nameList2 = nameList = IPListEditor.makeNameList(objectArray[0]);
            int n = 1;
            while (n < objectArray.length) {
                NameList nameList3;
                nameList2.nlNext = nameList3 = IPListEditor.makeNameList(objectArray[n]);
                nameList2 = nameList3;
                ++n;
            }
        }
        return nameList;
    }

    protected void actionAdd() {
        String string = String.valueOf(this.editor.getObject());
        if (GuiUtil.isIPFormatValid(string)) {
            this.addObject(string);
        } else {
            String string2 = Util.getString("GUI8210E");
            String string3 = Util.getString("GUI8211T");
            JOptionPane.showMessageDialog(this.guiMain.getFrame(), string2, string3, 1);
        }
    }
}

