/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.Report;
import org.eclipse.aperi.TStorm.gui.FileMaskEditor;
import org.eclipse.aperi.TStorm.gui.ReportCreateOrEdit;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiRequest;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.gui.ChartInfo;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiManager;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IGuiMain;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialog;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationDialogCallbackInterface;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationKey;
import org.eclipse.aperi.gui.charting.AperiChartCustomizationManager;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class ReportOptions
extends JPanel
implements GuiRequestor,
ItemListener,
ActionListener,
AperiChartCustomizationDialogCallbackInterface {
    GridBagConstraints gbcRegular = new GridBagConstraints();
    Insets insetA = new Insets(0, 5, 0, 0);
    JPanel reportTypePanel;
    JCheckBox runScript;
    JLabel scriptLabel;
    JTextField scriptName;
    JCheckBox includeHeaders;
    JCheckBox includeTotals;
    JCheckBox includeHistHeaders;
    JComboBox computerBox;
    JComboBox historyReportBox;
    JComboBox historyTypeBox;
    JComboBox chartReportBox;
    FileMaskEditor fileMaskEditor;
    JRadioButton csvButton;
    JRadioButton formattedButton;
    JRadioButton htmlButton;
    JRadioButton historyButton;
    JRadioButton pdfChartButton;
    JRadioButton htmlChartButton;
    Report report;
    NameList computerList;
    NameList computerNode;
    NameList resetAgent = null;
    byte[] histLabelArray;
    byte[] histReportArray;
    byte[] histRangeArray;
    byte[] chartReportArray;
    boolean fieldsSet;
    boolean computersAre21;
    static final String COMPUTER_TITLE = MessageLog.getMessageNoID("STG5147L");
    static final String SCRIPT_TITLE = MessageLog.getMessageNoID("GUI2069L");
    static final String FILE_MASK_TITLE = MessageLog.getMessageNoID("STG5148L");
    static final String REPORT_TYPE_TITLE = MessageLog.getMessageNoID("STG5149L");
    static final String COMPUTER_BOX_LABEL = MessageLog.getMessageNoID("STG5154L");
    static final String COMPUTER_BOX_LABEL2 = MessageLog.getMessageNoID("STG5157L");
    static final String REPORT_TYPE_LABEL = MessageLog.getMessageNoID("STG5155L");
    static final String CSV_BUTTON = MessageLog.getMessageNoID("STG5150L");
    static final String FORMATTED_BUTTON = MessageLog.getMessageNoID("STG5151L");
    static final String HTML_BUTTON = MessageLog.getMessageNoID("STG5256L");
    static final String HISTORY_BUTTON = MessageLog.getMessageNoID("STG5257L");
    static final String PDF_CHART_BUTTON = MessageLog.getMessageNoID("STG5267L");
    static final String HTML_CHART_BUTTON = MessageLog.getMessageNoID("STG5268L");
    static final String INCLUDE_HEADERS = MessageLog.getMessageNoID("GUI5084L");
    static final String INCLUDE_TOTALS = MessageLog.getMessageNoID("GUI5085L");
    static final String[] HISTORY_TYPES = new String[]{MessageLog.getMessageNoID("STG1193T"), MessageLog.getMessageNoID("STG1194T"), MessageLog.getMessageNoID("STG1195T")};
    static final String CHART_CUST_BUTTON = Util.getString("CUSTOMIZE_THIS_CHART");
    private JButton chartCustButton;
    private ChartOptions defaultSettings = null;
    private ChartOptions currentSettings = null;
    private int reportSubtype;
    private int chartId;
    private int chartSubtype = 0;
    private ReportCreateOrEdit rcoe;
    private IGuiMain guiMain = GuiManager.getGuiManager().getGuiMain();

    public ReportOptions(Report report) {
        this(report, null);
    }

    public ReportOptions(Report report, ReportCreateOrEdit reportCreateOrEdit) {
        this.report = report;
        this.rcoe = reportCreateOrEdit;
        this.getAgents();
        this.gbcRegular.anchor = 17;
        this.gbcRegular.gridwidth = 0;
        this.gbcRegular.insets = this.insetA;
        this.reportTypePanel = this.makeReportTypePanel();
    }

    private void getAgents() {
        GuiListReq guiListReq = new GuiListReq();
        guiListReq.listRequested = 12;
        guiListReq.excludeNAS = true;
        guiListReq.excludeVS = true;
        if (this.report.batchReport.reportType == 8 || this.report.batchReport.reportType == 9) {
            guiListReq.excludeUnder21 = true;
            this.computersAre21 = true;
        } else {
            this.computersAre21 = false;
        }
        Request request = GuiRequest.newRequest("org.eclipse.aperi.server.handler.gui.GuiListHndlr", guiListReq);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s <= 4) {
            this.computerList = (NameList)response.responseData;
            if (this.fieldsSet) {
                this.computerBox.removeAllItems();
                this.replaceComputers();
            } else {
                this.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.fill = 1;
                this.add((Component)this.makeComputerPanel(), gridBagConstraints);
                this.buildPanel(gridBagConstraints);
                if (this.rcoe != null && this.rcoe.ddi.oldCreateHeader == null) {
                    this.rcoe.getData();
                    this.rcoe.ddi.oldCreateHeader = (Report)this.rcoe.report.clone();
                }
            }
        }
    }

    private void buildPanel(GridBagConstraints gridBagConstraints) {
        this.add((Component)this.reportTypePanel, gridBagConstraints);
        this.add(this.makeScriptPanel(), gridBagConstraints);
        this.fileMaskEditor = new FileMaskEditor(128);
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.fileMaskEditor.build(), gridBagConstraints);
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weighty = 1.0;
        this.add(Box.createVerticalStrut(1), gridBagConstraints);
        this.setFields();
        this.addListeners();
    }

    private JPanel makeComputerPanel() {
        this.computerBox = new TComboBox();
        this.replaceComputers();
        JPanel jPanel = GuiUtil.getTitledBorderedPanel(COMPUTER_TITLE);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(COMPUTER_BOX_LABEL);
        JLabel jLabel2 = new JLabel(COMPUTER_BOX_LABEL2);
        jPanel2.add((Component)jLabel, "North");
        jPanel2.add((Component)jLabel2, "South");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = this.gbcRegular.anchor;
        gridBagConstraints.insets.left = this.insetA.left;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.gridheight = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 12;
        jPanel.add((Component)this.computerBox, gridBagConstraints);
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    private void replaceComputers() {
        NameList nameList = new NameList();
        nameList.nlName = " ";
        this.computerBox.addItem(nameList);
        this.computerNode = this.computerList;
        while (this.computerNode != null) {
            this.computerBox.addItem(this.computerNode);
            this.computerNode = this.computerNode.nlNext;
        }
        if (this.resetAgent != null) {
            this.computerBox.setSelectedIndex(0);
            int n = 1;
            this.computerNode = this.computerList;
            while (this.computerNode != null) {
                if (this.computerNode.nlID == this.resetAgent.nlID) {
                    this.computerBox.setSelectedIndex(n);
                    break;
                }
                ++n;
                this.computerNode = this.computerNode.nlNext;
            }
            this.resetAgent = null;
        }
    }

    private Component makeScriptPanel() {
        String string = MessageLog.getMessageNoID("GUI2071L");
        this.runScript = new JCheckBox(string);
        string = MessageLog.getMessageNoID("GUI2077L");
        this.scriptLabel = new JLabel(string);
        this.scriptLabel.setEnabled(false);
        GuiUtil.setAccessible(this.runScript, this.runScript.getText(), this.runScript.getText());
        this.scriptName = TTextField.newTTextField(10, 64, false);
        this.scriptName.setEnabled(false);
        GuiUtil.setAccessibleLabel(this.scriptLabel, this.scriptName, "MNEMONIC_SCRIPTNAME", string, "DESCRIPTION_SCRIPTNAME");
        JPanel jPanel = GuiUtil.getTitledBorderedPanel(SCRIPT_TITLE);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.insets.left = this.insetA.left;
        gridBagConstraints.insets.bottom = 6;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.runScript, gridBagConstraints);
        gridBagConstraints.insets.left = 15;
        jPanel.add((Component)this.scriptLabel, gridBagConstraints);
        gridBagConstraints.insets.left = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.scriptName, gridBagConstraints);
        return jPanel;
    }

    private JPanel makeReportTypePanel() {
        JPanel jPanel = GuiUtil.getTitledBorderedPanel(REPORT_TYPE_TITLE);
        JLabel jLabel = new JLabel(REPORT_TYPE_LABEL);
        this.csvButton = new JRadioButton(CSV_BUTTON);
        this.formattedButton = new JRadioButton(FORMATTED_BUTTON);
        this.htmlButton = new JRadioButton(HTML_BUTTON);
        this.historyButton = new JRadioButton(HISTORY_BUTTON);
        this.pdfChartButton = new JRadioButton(PDF_CHART_BUTTON);
        this.htmlChartButton = new JRadioButton(HTML_CHART_BUTTON);
        this.chartCustButton = new JButton(CHART_CUST_BUTTON);
        GuiUtil.setAccessible(this.csvButton, CSV_BUTTON, CSV_BUTTON);
        GuiUtil.setAccessible(this.formattedButton, FORMATTED_BUTTON, FORMATTED_BUTTON);
        GuiUtil.setAccessible(this.htmlButton, HTML_BUTTON, HTML_BUTTON);
        GuiUtil.setAccessible(this.historyButton, HISTORY_BUTTON, HISTORY_BUTTON);
        GuiUtil.setAccessible(this.htmlChartButton, HISTORY_BUTTON, HISTORY_BUTTON);
        GuiUtil.setAccessible(this.htmlChartButton, CHART_CUST_BUTTON, CHART_CUST_BUTTON);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.csvButton);
        buttonGroup.add(this.formattedButton);
        buttonGroup.add(this.htmlButton);
        buttonGroup.add(this.historyButton);
        buttonGroup.add(this.htmlChartButton);
        this.includeHeaders = new JCheckBox(INCLUDE_HEADERS);
        this.includeHeaders.setEnabled(false);
        GuiUtil.setAccessible(this.includeHeaders, INCLUDE_HEADERS, INCLUDE_HEADERS);
        this.includeTotals = new JCheckBox(INCLUDE_TOTALS);
        this.includeTotals.setEnabled(false);
        GuiUtil.setAccessible(this.includeTotals, INCLUDE_TOTALS, INCLUDE_TOTALS);
        this.includeHistHeaders = new JCheckBox(INCLUDE_HEADERS);
        this.includeHistHeaders.setEnabled(false);
        GuiUtil.setAccessible(this.includeHistHeaders, INCLUDE_HEADERS, INCLUDE_HEADERS);
        this.historyReportBox = new TComboBox();
        this.historyReportBox.setEnabled(false);
        this.historyTypeBox = new TComboBox(HISTORY_TYPES);
        this.historyTypeBox.setEnabled(false);
        this.chartReportBox = new TComboBox();
        this.chartReportBox.setEnabled(false);
        jPanel.add((Component)jLabel, this.gbcRegular);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        Insets insets = new Insets(0, 0, 0, 5);
        Insets insets2 = new Insets(0, 0, 0, 4);
        Insets insets3 = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = insets;
        gridBagConstraints2.gridwidth = 17;
        gridBagConstraints2.insets = insets2;
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.insets = insets3;
        JPanel jPanel2 = GuiUtil.getPanel();
        JPanel jPanel3 = GuiUtil.getPanel();
        JPanel jPanel4 = GuiUtil.getPanel();
        JPanel jPanel5 = GuiUtil.getPanel();
        jPanel2.add((Component)this.csvButton, gridBagConstraints);
        jPanel2.add((Component)this.includeHeaders, gridBagConstraints2);
        jPanel2.add((Component)this.includeTotals, gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints3);
        jPanel2.add((Component)this.formattedButton, gridBagConstraints);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints3);
        jPanel2.add((Component)this.htmlButton, gridBagConstraints);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints3);
        jPanel2.add((Component)this.historyButton, gridBagConstraints);
        jPanel2.add((Component)this.includeHistHeaders, gridBagConstraints2);
        jPanel2.add((Component)this.historyReportBox, gridBagConstraints2);
        jPanel2.add((Component)this.historyTypeBox, gridBagConstraints2);
        jPanel2.add((Component)new JLabel(" "), gridBagConstraints3);
        jPanel4.add((Component)new JLabel(" "), gridBagConstraints3);
        jPanel4.add((Component)this.htmlChartButton, gridBagConstraints);
        jPanel4.add((Component)new JLabel(" "), gridBagConstraints3);
        jPanel5.add((Component)this.chartReportBox, gridBagConstraints2);
        jPanel5.add((Component)this.chartCustButton, gridBagConstraints2);
        jPanel5.add((Component)new JLabel(" "), gridBagConstraints3);
        GuiUtil.completePanel(jPanel4);
        GuiUtil.completePanel(jPanel5);
        jPanel3.add((Component)jPanel4, gridBagConstraints);
        jPanel3.add((Component)jPanel5, gridBagConstraints3);
        GuiUtil.completePanel(jPanel2);
        GuiUtil.completePanel(jPanel3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = this.gbcRegular.anchor;
        gridBagConstraints4.insets.left = 5;
        gridBagConstraints4.insets.bottom = 0;
        gridBagConstraints4.gridwidth = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints4);
        gridBagConstraints4.insets.left = 0;
        jPanel.add((Component)jPanel3, gridBagConstraints4);
        GuiUtil.completePanel(jPanel);
        return jPanel;
    }

    private void setFields() {
        int n;
        this.fieldsSet = true;
        this.computerBox.setSelectedIndex(0);
        if (this.report.computerID > 0) {
            n = 1;
            this.computerNode = this.computerList;
            while (this.computerNode != null) {
                if (this.computerNode.nlID == this.report.computerID) {
                    this.computerBox.setSelectedIndex(n);
                    break;
                }
                ++n;
                this.computerNode = this.computerNode.nlNext;
            }
        }
        if ((n = Util.isEmpty(this.report.batchReport.scriptName)) != 0) {
            this.report.batchReport.scriptName = "";
        }
        this.scriptName.setText(this.report.batchReport.scriptName);
        this.runScript.setSelected(n == 0);
        this.scriptName.setEnabled(n == 0);
        this.scriptLabel.setEnabled(n == 0);
        String string = null;
        if (this.report.batchReport.fileMask != null) {
            string = this.report.batchReport.maskToText(null, null);
        }
        this.fileMaskEditor.setData(string);
        if (this.report.batchReport.reportType == 2) {
            this.formattedButton.setSelected(true);
        } else if (this.report.batchReport.reportType == 6) {
            this.htmlButton.setSelected(true);
        } else if (this.report.batchReport.reportType == 7) {
            this.historyButton.setSelected(true);
            this.includeHistHeaders.setSelected(this.report.batchReport.includeHeaders);
            this.includeHistHeaders.setEnabled(true);
            this.historyReportBox.setEnabled(true);
            this.historyTypeBox.setEnabled(true);
        } else if (this.report.batchReport.reportType == 1) {
            this.csvButton.setSelected(true);
            this.includeHeaders.setSelected(this.report.batchReport.includeHeaders);
            this.includeTotals.setSelected(this.report.batchReport.includeTotals);
            this.includeHeaders.setEnabled(true);
            this.includeTotals.setEnabled(true);
        } else if (this.report.batchReport.reportType != 8) {
            this.htmlChartButton.setSelected(true);
            this.chartReportBox.setEnabled(true);
            this.chartCustButton.setEnabled(true);
        }
    }

    private void addListeners() {
        this.runScript.addItemListener(this);
        this.csvButton.addItemListener(this);
        this.historyButton.addItemListener(this);
        this.htmlChartButton.addItemListener(this);
        this.chartCustButton.addActionListener(this);
        this.historyReportBox.addItemListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.chartCustButton) {
            Serializable serializable;
            boolean bl = false;
            this.getData();
            if (this.report.batchReport.grr.chartSubtype <= 0) {
                bl = true;
                this.chartId = this.report.batchReport.grr.histSubtype;
                this.chartSubtype = this.report.batchReport.grr.histSubtypeRange;
            } else {
                this.chartId = this.report.batchReport.grr.chartSubtype;
            }
            this.reportSubtype = this.report.batchReport.grr.reportSubtype;
            ChartInfo chartInfo = new ChartInfo();
            this.defaultSettings = chartInfo.getChartDefaults(this.report.batchReport.grr.reportType, this.reportSubtype, bl, this.chartId, this.chartSubtype);
            if (this.report.batchReport.saveChartSettingsReq != null && this.chartId == ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).chartId && this.chartSubtype == ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).chartSubtype) {
                this.currentSettings = ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).options;
            } else {
                serializable = new GuiChartSettingsReq();
                ((GuiChartSettingsReq)serializable).reportId = this.report.batchReport.grr.reportType;
                ((GuiChartSettingsReq)serializable).chartId = this.chartId;
                ((GuiChartSettingsReq)serializable).chartSubtype = this.chartSubtype;
                ((GuiChartSettingsReq)serializable).reportSubtype = this.reportSubtype;
                ((GuiChartSettingsReq)serializable).creator = GuiUtil.getUserName();
                ((GuiChartSettingsReq)serializable).batchId = this.report.batchReport.reportID;
                ((GuiChartSettingsReq)serializable).reqType = 4;
                ((GuiChartSettingsReq)serializable).options = null;
                ChartOptions chartOptions = null;
                if (AperiChartCustomizationManager.getManager() != null) {
                    chartOptions = AperiChartCustomizationManager.getManager().getChartCustomization(new AperiChartCustomizationKey((GuiChartSettingsReq)serializable));
                }
                this.currentSettings = chartOptions != null ? (ChartOptions)chartOptions.clone() : (ChartOptions)this.defaultSettings.clone();
            }
            serializable = new AperiChartCustomizationDialog(this.guiMain.getFrame(), this, Util.getString("CHART_CUSTOMIZATION"), null, this.currentSettings, this.defaultSettings, true, true, this.report.batchReport.grr.chartSubtype > 0, true, this.report.batchReport.grr.chartSubtype <= 0);
            GuiUtil.centerDialog((Component)serializable);
            ((Dialog)serializable).setVisible(true);
        }
    }

    public void getData() {
        GuiReportReq guiReportReq = this.report.batchReport.grr;
        this.report.batchReport.includeTotals = false;
        this.report.batchReport.includeHeaders = false;
        guiReportReq.histType = 0;
        guiReportReq.histSubtype = 0;
        guiReportReq.histSubtypeRange = 0;
        guiReportReq.chartSubtype = 0;
        guiReportReq.chartLabelType = 0;
        NameList nameList = (NameList)this.computerBox.getSelectedItem();
        this.report.computerID = nameList.nlID;
        this.report.batchReport.scriptName = this.runScript.isSelected() ? this.scriptName.getText() : "";
        this.report.batchReport.fileMask = this.fileMaskEditor.getData();
        this.report.batchReport.fileMask = this.report.batchReport.maskToIDs(null);
        if (this.csvButton.isSelected()) {
            this.report.batchReport.reportType = 1;
            this.report.batchReport.includeHeaders = this.includeHeaders.isSelected();
            this.report.batchReport.includeTotals = this.includeTotals.isSelected();
        } else if (this.formattedButton.isSelected()) {
            this.report.batchReport.reportType = (byte)2;
        } else if (this.htmlButton.isSelected()) {
            this.report.batchReport.reportType = (byte)6;
        } else if (this.historyButton.isSelected()) {
            this.report.batchReport.reportType = (byte)7;
            if (!this.historyButton.isEnabled()) {
                guiReportReq.histType = (byte)-1;
            } else {
                guiReportReq.histType = (byte)this.historyTypeBox.getSelectedIndex();
                int n = this.historyReportBox.getSelectedIndex();
                if (this.histRangeArray == null) {
                    guiReportReq.histSubtype = this.histReportArray[n];
                    guiReportReq.chartLabelType = this.histLabelArray[n];
                } else {
                    int n2 = this.histRangeArray.length;
                    guiReportReq.chartLabelType = this.histLabelArray[n / n2];
                    guiReportReq.histSubtype = this.histReportArray[n / n2];
                    guiReportReq.histSubtypeRange = this.histRangeArray[n % n2];
                }
                this.report.batchReport.includeHeaders = this.includeHistHeaders.isSelected();
                this.report.batchReport.historyHeader = (String)this.historyReportBox.getSelectedItem();
            }
        } else if (!this.pdfChartButton.isSelected() && this.htmlChartButton.isSelected()) {
            this.report.batchReport.reportType = (byte)9;
            this.getChartStuff(guiReportReq, this.htmlChartButton);
        }
    }

    private void getChartStuff(GuiReportReq guiReportReq, JRadioButton jRadioButton) {
        if (!jRadioButton.isEnabled()) {
            guiReportReq.histType = (byte)-1;
        } else {
            int n = this.chartReportBox.getSelectedIndex();
            if (this.chartReportArray != null && n < this.chartReportArray.length) {
                guiReportReq.chartSubtype = this.chartReportArray[n];
            } else {
                if (this.chartReportArray != null) {
                    n -= this.chartReportArray.length;
                }
                if (this.histRangeArray == null) {
                    guiReportReq.histSubtype = this.histReportArray[n];
                    guiReportReq.chartLabelType = this.histLabelArray[n];
                } else {
                    int n2 = this.histRangeArray.length;
                    guiReportReq.histSubtype = this.histReportArray[n / n2];
                    guiReportReq.histSubtypeRange = this.histRangeArray[n % n2];
                    guiReportReq.chartLabelType = this.histLabelArray[n / n2];
                }
            }
        }
        this.report.batchReport.historyHeader = (String)this.chartReportBox.getSelectedItem();
    }

    public void validateData(boolean bl) throws GeneralException {
        if (this.report.computerID < 1) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG5158E"));
        }
        if (this.runScript.isSelected() && Util.isEmpty(this.report.batchReport.scriptName)) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG3253E"));
        }
        if (this.report.batchReport.grr.histType == -1) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG5261L"));
        }
        if (bl && (this.report.batchReport.reportType == 7 || this.report.batchReport.reportType == 8 || this.report.batchReport.reportType == 9)) {
            throw new GeneralException(MessageLog.getMessageNoTS("STG5261L"));
        }
        String string = null;
        if (this.report.batchReport.fileMask != null) {
            string = this.report.batchReport.maskToText(null, null);
        }
        this.fileMaskEditor.validateData(string);
    }

    public void replace(Report report) {
        this.report = report;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl = itemEvent.getStateChange() == 1;
        GuiReportReq cfr_ignored_0 = this.report.batchReport.grr;
        if (itemEvent.getSource() == this.runScript) {
            this.scriptLabel.setEnabled(bl);
            this.scriptName.setEnabled(bl);
            this.resetAgents(bl);
        } else if (itemEvent.getSource() == this.csvButton) {
            this.includeHeaders.setEnabled(bl);
            this.includeTotals.setEnabled(bl);
            this.resetAgents(bl);
        } else if (itemEvent.getSource() == this.historyButton) {
            this.includeHistHeaders.setEnabled(bl);
            this.historyReportBox.setEnabled(bl);
            this.historyTypeBox.setEnabled(bl);
            this.resetAgents(bl);
        } else {
            this.chartReportBox.setEnabled(bl);
            this.chartCustButton.setEnabled(bl);
            if (bl && !this.computersAre21) {
                this.resetAgent = (NameList)this.computerBox.getSelectedItem();
                if (this.resetAgent.nlID > 0 && this.resetAgent.nlID2 < SoftwareVersion.VERSION_2_1_0) {
                    String string = MessageLog.getMessageNoID("STG5567E", this.resetAgent.nlName);
                    JOptionPane.showMessageDialog(this.guiMain.getFrame(), string, "STG5567E", 0);
                }
                if (this.resetAgent.nlID < 1) {
                    this.resetAgent = null;
                }
                this.report.batchReport.reportType = (byte)8;
                this.getAgents();
            }
        }
    }

    private void resetAgents(boolean bl) {
        if (bl && this.computersAre21) {
            this.resetAgent = (NameList)this.computerBox.getSelectedItem();
            if (this.resetAgent.nlID < 1) {
                this.resetAgent = null;
            }
            this.report.batchReport.reportType = 0;
            this.getAgents();
        }
    }

    public void disableHistory() {
        this.historyButton.setEnabled(false);
        this.includeHistHeaders.setEnabled(false);
        this.historyReportBox.setEnabled(false);
        this.historyTypeBox.setEnabled(false);
        this.historyReportBox.removeAllItems();
        this.pdfChartButton.setEnabled(false);
        this.htmlChartButton.setEnabled(false);
        this.chartReportBox.setEnabled(false);
        this.chartCustButton.setEnabled(false);
        this.chartReportBox.removeAllItems();
    }

    public void replaceHistoryArrays(String[] stringArray, byte[] byArray, byte[] byArray2, String[] stringArray2, byte[] byArray3, boolean bl, String[] stringArray3, byte[] byArray4) {
        int n;
        int n2;
        int n3;
        this.histLabelArray = byArray;
        this.histReportArray = byArray2;
        this.histRangeArray = byArray3;
        this.chartReportArray = byArray4;
        GuiReportReq guiReportReq = this.report.batchReport.grr;
        byte by = this.report.batchReport.reportType;
        this.disableHistory();
        if (stringArray != null) {
            if (byArray3 == null) {
                int n4 = 0;
                while (n4 < stringArray.length) {
                    this.historyReportBox.addItem(stringArray[n4]);
                    ++n4;
                }
            } else {
                n3 = 0;
                while (n3 < stringArray.length) {
                    n2 = 0;
                    while (n2 < stringArray2.length) {
                        String string = stringArray[n3].endsWith("%") ? String.valueOf(stringArray[n3]) + "  " + stringArray2[n2] : String.valueOf(stringArray[n3]) + " " + stringArray2[n2];
                        this.historyReportBox.addItem(string);
                        ++n2;
                    }
                    ++n3;
                }
            }
            this.historyButton.setEnabled(true);
            n = 0;
            n3 = 0;
            n2 = 0;
            if (this.fieldsSet) {
                if (this.historyButton.isSelected()) {
                    n2 = 1;
                }
            } else if (by == 7) {
                n2 = 1;
            }
            if (n2 != 0) {
                this.includeHistHeaders.setEnabled(true);
                this.historyReportBox.setEnabled(true);
                this.historyTypeBox.setEnabled(true);
                if (bl) {
                    int n5 = 0;
                    while (n5 < byArray2.length) {
                        if (byArray2[n5] == guiReportReq.histSubtype) {
                            n = n5;
                            break;
                        }
                        ++n5;
                    }
                    if (byArray3 != null) {
                        n *= byArray3.length;
                        n5 = 0;
                        while (n5 < byArray3.length) {
                            if (byArray3[n5] == guiReportReq.histSubtypeRange) {
                                n += n5;
                                break;
                            }
                            ++n5;
                        }
                    }
                    n3 = guiReportReq.histType;
                }
            }
            this.historyReportBox.setSelectedIndex(n);
            this.historyTypeBox.setSelectedIndex(n3);
        }
        if (stringArray != null || stringArray3 != null) {
            if (stringArray3 != null) {
                n = 0;
                while (n < stringArray3.length) {
                    this.chartReportBox.addItem(stringArray3[n]);
                    ++n;
                }
            }
            if (stringArray != null) {
                if (byArray3 == null) {
                    n = 0;
                    while (n < stringArray.length) {
                        this.chartReportBox.addItem(stringArray[n]);
                        ++n;
                    }
                } else {
                    n3 = 0;
                    while (n3 < stringArray.length) {
                        n2 = 0;
                        while (n2 < stringArray2.length) {
                            String string = stringArray[n3].endsWith("%") ? String.valueOf(stringArray[n3]) + "  " + stringArray2[n2] : String.valueOf(stringArray[n3]) + " " + stringArray2[n2];
                            this.chartReportBox.addItem(string);
                            ++n2;
                        }
                        ++n3;
                    }
                }
            }
            this.htmlChartButton.setEnabled(true);
            int n6 = 0;
            n3 = 0;
            if (this.fieldsSet) {
                if (this.htmlChartButton.isSelected()) {
                    n3 = 1;
                }
            } else if (by == 8 || by == 9) {
                n3 = 1;
            }
            if (n3 != 0) {
                this.chartReportBox.setEnabled(true);
                this.chartCustButton.setEnabled(true);
                if (bl) {
                    if (guiReportReq.chartSubtype > 0) {
                        n2 = 0;
                        while (n2 < byArray4.length) {
                            if (byArray4[n2] == guiReportReq.chartSubtype) {
                                n6 = n2;
                                break;
                            }
                            ++n2;
                        }
                    } else {
                        n2 = 0;
                        while (n2 < byArray2.length) {
                            if (byArray2[n2] == guiReportReq.histSubtype) {
                                n6 = n2;
                                break;
                            }
                            ++n2;
                        }
                        if (byArray3 != null) {
                            n6 *= byArray3.length;
                            n2 = 0;
                            while (n2 < byArray3.length) {
                                if (byArray3[n2] == guiReportReq.histSubtypeRange) {
                                    n6 += n2;
                                    break;
                                }
                                ++n2;
                            }
                        }
                        if (stringArray3 != null) {
                            n6 += stringArray3.length;
                        }
                    }
                }
            }
            this.chartReportBox.setSelectedIndex(n6);
        }
    }

    public void storeChartSaveRequest(Request request) {
        this.report.batchReport.saveChartSettingsReq = request;
    }

    public void setCustomOptions(ChartOptions chartOptions) {
    }

    public void saveCustomOptions(ChartOptions chartOptions) {
        if (this.report.batchReport.saveChartSettingsReq == null) {
            GuiChartSettingsReq guiChartSettingsReq = new GuiChartSettingsReq();
            guiChartSettingsReq.reportId = this.report.batchReport.grr.reportType;
            guiChartSettingsReq.reportSubtype = this.reportSubtype;
            guiChartSettingsReq.chartId = this.chartId;
            guiChartSettingsReq.chartSubtype = this.chartSubtype;
            guiChartSettingsReq.batchId = this.report.batchReport.reportID;
            guiChartSettingsReq.creator = GuiUtil.getUserName();
            guiChartSettingsReq.options = (ChartOptions)chartOptions.clone();
            Request request = new Request();
            request.typeCode = "org.eclipse.aperi.server.svp.GuiSvp";
            request.serviceName = RequestTypeManager.getInternalName(request.typeCode);
            request.subType = "org.eclipse.aperi.server.handler.gui.ChartSettingsHndlr";
            request.userName = GuiUtil.getUserName();
            request.flags = (byte)4;
            request.requestData = guiChartSettingsReq;
            this.report.batchReport.saveChartSettingsReq = request;
        } else {
            ((GuiChartSettingsReq)this.report.batchReport.saveChartSettingsReq.requestData).options = (ChartOptions)chartOptions.clone();
        }
    }
}

