/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.eclipse.aperi.TStorm.common.SpaceUsedAdjuster;
import org.eclipse.aperi.TStorm.common.SpaceUsedGrapher;
import org.eclipse.aperi.TStorm.gui.DisplaysChartPopupInterface;
import org.eclipse.aperi.TStorm.gui.ReportingDDI;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportRequest;
import org.eclipse.aperi.TStorm.server.guireq.RespFSspace;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.MutableLongExt;
import org.eclipse.aperi.common.MutableShort;
import org.eclipse.aperi.gui.AskForRowIconInterface;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.HistoryChoiceInterface;
import org.eclipse.aperi.gui.TJCTableMouseAdapter;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.xmsg.MessageLog;

public class SpaceUsedTable
extends JPanel
implements GuiRequestor,
DisplaysChartPopupInterface,
HistoryChoiceInterface {
    private MegaTable table = new MegaTable();
    private GuiReportReq grr;
    private ReportingDDI ddi;
    private RespFSspace[] data;
    private String actionCommand;
    private SpaceUsedAdjuster adjuster;
    private SpaceUsedGrapher grapher;
    SpaceUsedModel spaceUsedModel;
    private TJCTableMouseInterface myMouseListener = new selectListener();

    public SpaceUsedTable(GuiReportReq guiReportReq, ReportingDDI reportingDDI) {
        this.grr = guiReportReq;
        this.ddi = reportingDDI;
        GuiReportRequest guiReportRequest = new GuiReportRequest(guiReportReq);
        GuiClient.doRequest(this, guiReportRequest);
        this.setLayout(new BorderLayout());
        this.adjuster = new SpaceUsedAdjuster(guiReportReq);
        this.grapher = new SpaceUsedGrapher();
    }

    public void handleResponse(short s, Response response) {
        this.data = s <= 4 ? (RespFSspace[])response.responseData : null;
        int n = this.data != null ? this.data.length : 0;
        if (n == 0) {
            this.add((Component)this.ddi.getNoDataMessage_instance(this.grr), "Center");
            this.ddi.jumpToChart = false;
            return;
        }
        this.adjuster.adjust(this.data, false);
        this.data = (RespFSspace[])this.adjuster.getArray();
        this.table.setMouseListener(this.myMouseListener);
        this.spaceUsedModel = new SpaceUsedModel();
        this.table.setCellRenderer(MutableLongExt.class, TableCellRenderers.number);
        this.table.setCellRenderer(MutableLong.class, TableCellRenderers.space);
        this.table.setCellRenderer(MutableShort.class, TableCellRenderers.percent);
        this.table.setRowIcon(11, this.grr.reportSubtype != 10);
        this.table.iconChanger = this.spaceUsedModel;
        this.table.setBaseTableModel(this.spaceUsedModel);
        this.table.setFrozenColumns(this.adjuster.frozenColumns);
        this.table.setFrozenRows(this.adjuster.frozenRows);
        if (this.grr.selectedColumns == null) {
            switch (this.grr.reportSubtype) {
                case 12: {
                    this.table.setColumnHidden(this.adjuster.QUAL_COL, true);
                    break;
                }
                case 14: {
                    this.table.setColumnHidden(this.adjuster.QUAL_COL, true);
                    break;
                }
                case 15: {
                    this.table.setColumnHidden(this.adjuster.QUAL_COL, true);
                    this.table.setColumnHidden(this.adjuster.NAME_COL, true);
                }
            }
            if (this.grr.reportType == 9) {
                this.table.setAsFirstColumn(this.adjuster.USED_COL);
            } else if (this.grr.reportType == 10) {
                this.table.setAsFirstColumn(this.adjuster.FREE_COL);
            } else {
                this.table.setAsFirstColumn(this.adjuster.CAPACITY_COL);
            }
        }
        this.ddi.addRowCount(this.adjuster);
        this.add((Component)this.table, "Center");
        this.validate();
        if (this.ddi.jumpToChart) {
            this.ddi.jumpToChart = false;
            this.showJumpChart();
        }
    }

    public TJCTableMouseInterface getShowsPopup() {
        return this.myMouseListener;
    }

    public void showJumpChart() {
        ActionEvent actionEvent = new ActionEvent(this, 777, "STG1276T");
        ((ActionListener)((Object)this.myMouseListener)).actionPerformed(actionEvent);
    }

    public SpaceUsedTable(String string, String string2, String string3, String string4) {
    }

    public Object[] getChoices(int n, int n2) {
        Object[] objectArray = new Object[3];
        String[] stringArray = new String[]{"STG7536L", "STG7530L", "STG7531L", "STG7537L", "STG7538L", "STG7539L"};
        byte[] byArray = new byte[]{6, 1, 8, 1, 8, 1};
        byte[] byArray2 = new byte[6];
        byArray2[1] = 1;
        byArray2[2] = 2;
        byArray2[3] = 3;
        byArray2[4] = 4;
        byArray2[5] = 5;
        byte[] byArray3 = byArray2;
        objectArray[0] = stringArray;
        objectArray[1] = byArray;
        objectArray[2] = byArray3;
        return objectArray;
    }

    public Object[] getCharts(int n, int n2) {
        Object[] objectArray = new Object[2];
        String[] stringArray = new String[]{"STG7528L"};
        byte[] byArray = new byte[]{101};
        objectArray[0] = stringArray;
        objectArray[1] = byArray;
        return objectArray;
    }

    public int[] getGraphID(String string) {
        int[] nArray = new int[2];
        nArray[0] = string == "STG1251T" ? 101 : (string == "STG1276T" ? 102 : (string == "STG5104L" ? 0 : (string == "STG5105L" ? 1 : (string == "STG5106L" ? 2 : (string == "STG5107L" ? 3 : (string == "STG5108L" ? 4 : 5))))));
        return nArray;
    }

    private class SpaceUsedModel
    extends BaseTableModel
    implements AskForRowIconInterface {
        SpaceUsedModel() {
            this.columnNames = ((SpaceUsedTable)SpaceUsedTable.this).adjuster.colNames;
            this.rowCount = SpaceUsedTable.this.data.length;
            this.commonAdjuster = SpaceUsedTable.this.adjuster;
        }

        public boolean changeIcon(int n) {
            return n < ((SpaceUsedTable)SpaceUsedTable.this).adjuster.frozenRows;
        }

        public Object getTableDataItem(int n, int n2) {
            n2 = SpaceUsedTable.this.adjuster.translateColumn(n2);
            return SpaceUsedTable.this.adjuster.getCellData(n, n2);
        }
    }

    public class selectListener
    extends TJCTableMouseAdapter
    implements ActionListener {
        public boolean select(int n, int n2) {
            return n >= ((SpaceUsedTable)SpaceUsedTable.this).adjuster.frozenRows;
        }

        public void doubleClick(int n, int n2) {
            if (((SpaceUsedTable)SpaceUsedTable.this).grr.reportSubtype != 10) {
                GuiReportReq guiReportReq = SpaceUsedTable.this.grr.explode(((SpaceUsedTable)SpaceUsedTable.this).data[n].id);
                if (((SpaceUsedTable)SpaceUsedTable.this).grr.reportSubtype == 82) {
                    SpaceUsedTable.this.ddi.addReport(SpaceUsedTable.this.grr, guiReportReq, SpaceUsedTable.this.data[n].getName());
                } else {
                    SpaceUsedTable.this.ddi.addReport(SpaceUsedTable.this.grr, guiReportReq, String.valueOf(((SpaceUsedTable)SpaceUsedTable.this).data[n].creator.equals(" ") ? "" : String.valueOf(((SpaceUsedTable)SpaceUsedTable.this).data[n].creator) + ".") + SpaceUsedTable.this.data[n].getName());
                }
            }
        }

        public void showPopup(int n, int n2, Component component, int n3, int n4) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            boolean bl = SpaceUsedTable.this.data != null && SpaceUsedTable.this.data.length > 0;
            JMenuItem jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG1251T"));
            jMenuItem.setActionCommand("STG1251T");
            jMenuItem.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG1276T"));
            jMenuItem.setEnabled(bl);
            jMenuItem.setActionCommand("STG1276T");
            jMenuItem.addActionListener(this);
            jPopupMenu.addSeparator();
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5105L"));
            jMenuItem.setActionCommand("STG5105L");
            jMenuItem.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5106L"));
            jMenuItem.setActionCommand("STG5106L");
            jMenuItem.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5107L"));
            jMenuItem.setActionCommand("STG5107L");
            jMenuItem.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5108L"));
            jMenuItem.setActionCommand("STG5108L");
            jMenuItem.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            jMenuItem.addActionListener(this);
            jMenuItem = jPopupMenu.add(MessageLog.getMessageNoID("STG5109L"));
            jMenuItem.setActionCommand("STG5109L");
            jMenuItem.setEnabled(SpaceUsedTable.this.table.rowsSelected());
            jMenuItem.addActionListener(this);
            jPopupMenu.show(component, n3, n4);
            jPopupMenu.requestFocus();
        }

        public void showDefaultChart(int n) {
            int[] nArray = new int[]{n};
            int[] nArray2 = SpaceUsedTable.this.getGraphID("STG1251T");
            ((SpaceUsedTable)SpaceUsedTable.this).grr.chartSubtype = (byte)nArray2[0];
            SpaceUsedTable.this.grapher.createChart(SpaceUsedTable.this.grr, SpaceUsedTable.this.data, nArray, SpaceUsedTable.this.adjuster, SpaceUsedTable.this.ddi, null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray;
            SpaceUsedTable.this.actionCommand = actionEvent.getActionCommand();
            if (SpaceUsedTable.this.actionCommand == "STG1276T") {
                nArray = new int[SpaceUsedTable.this.data.length];
                int n = 0;
                while (n < SpaceUsedTable.this.data.length) {
                    nArray[n] = SpaceUsedTable.this.table.getDataRow(n);
                    ++n;
                }
            } else {
                nArray = SpaceUsedTable.this.table.getSelectedRows();
            }
            if (SpaceUsedTable.this.actionCommand == "STG1276T" || SpaceUsedTable.this.actionCommand == "STG1251T") {
                int[] nArray2 = SpaceUsedTable.this.getGraphID(SpaceUsedTable.this.actionCommand);
                ((SpaceUsedTable)SpaceUsedTable.this).grr.chartSubtype = (byte)nArray2[0];
                SpaceUsedTable.this.grapher.createChart(SpaceUsedTable.this.grr, SpaceUsedTable.this.data, nArray, SpaceUsedTable.this.adjuster, SpaceUsedTable.this.ddi, null);
            } else {
                GuiReportReq guiReportReq = SpaceUsedTable.this.grapher.createHistory(SpaceUsedTable.this.grr, SpaceUsedTable.this.data, nArray, SpaceUsedTable.this.actionCommand);
                SpaceUsedTable.this.ddi.addObject(SpaceUsedTable.this.grr, "org.eclipse.aperi.TStorm.gui.SpaceHistChart", guiReportReq, MessageLog.getMessageNoID("STG1279T"), MessageLog.getMessageNoID(guiReportReq.historyTitle), SpaceUsedTable.this);
            }
        }
    }
}

