/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui;

import java.util.Date;
import org.eclipse.aperi.TStorm.gui.BaseAlertLogTableData;
import org.eclipse.aperi.constants.metadata.AlertConditionManager;
import org.eclipse.aperi.gui.AlertLogDDI;
import org.eclipse.aperi.gui.AlertLogDetailPanel;
import org.eclipse.aperi.gui.AlertLogTable;
import org.eclipse.aperi.gui.CreateOrEditDDI;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.server.guireq.AlertLogReq;
import org.eclipse.aperi.server.guireq.ExtAlertLog;
import org.eclipse.aperi.xmsg.MessageLog;

public class TapeLibraryAlertLogTableData
extends BaseAlertLogTableData {
    private static final int ACTIVE_COLUMN = 0;
    private static final int OBJ_TYPE_COLUMN = 1;
    private static final int OBJ_NAME_COLUMN = 2;
    private static final int CONDITION_COLUMN = 3;
    private static final int FIRST_LOGGED_COLUMN = 4;
    private static final int LAST_LOGGED_COLUMN = 5;
    private static final int N_VIOLATIONS_COLUMN = 6;
    private static final int CREATOR_COLUMN = 7;
    private static final int NAME_COLUMN = 8;
    private static final int N_COLUMNS = 9;
    private static final String[] msgIDs;
    private boolean hasObjectNameColumn = true;
    private boolean hasObjectTypeColumn = true;
    private int[] hiddenColumns;

    static {
        String[] stringArray = new String[9];
        stringArray[1] = "GUI2021L";
        stringArray[2] = "GUI2022L";
        stringArray[3] = "GUI2023L";
        stringArray[4] = "GUI2024L";
        stringArray[5] = "GUI2025L";
        stringArray[6] = "GUI2026L";
        stringArray[7] = "GUI2027L";
        stringArray[8] = "GUI2028L";
        msgIDs = stringArray;
    }

    public TapeLibraryAlertLogTableData(AlertLogTable alertLogTable, ExtAlertLog[] extAlertLogArray, AlertLogReq alertLogReq) {
        super(alertLogTable, extAlertLogArray);
        this.columnNames = new String[9];
        this.columnNames[0] = " ";
        int n = 1;
        while (n < 9) {
            this.columnNames[n] = n != 2 || this.hasObjectTypeColumn || !this.hasObjectNameColumn ? MessageLog.getMessageNoID(msgIDs[n]) : CreateOrEditDDI.getObjectTypeName(alertLogReq.objectType);
            ++n;
        }
    }

    public Object getTableDataItem(int n, int n2) {
        ExtAlertLog extAlertLog = this.array[n];
        Object object = null;
        switch (n2) {
            case 0: {
                object = this.byteToObject(n, extAlertLog.alState);
                break;
            }
            case 1: {
                if (extAlertLog.getAlObjectName() == null) break;
                object = CreateOrEditDDI.getObjectTypeName(extAlertLog.alResourceType);
                break;
            }
            case 2: {
                object = extAlertLog.getAlObjectName();
                break;
            }
            case 3: {
                object = MessageLog.getMessageNoID(AlertConditionManager.getConditionMessageId(extAlertLog.alAlertCondition));
                break;
            }
            case 4: {
                object = new Date(extAlertLog.alFirstAlertTime);
                break;
            }
            case 5: {
                object = new Date(extAlertLog.alLastAlertTime);
                break;
            }
            case 6: {
                object = this.intToObject(n, extAlertLog.alAlertCount);
                break;
            }
            case 7: {
                object = extAlertLog.alCreator;
                break;
            }
            case 8: {
                object = extAlertLog.getAlName();
            }
        }
        if (object == null) {
            object = AlertLogDDI.notApplicableText;
        }
        return object;
    }

    public static void addResourceDescription(ExtAlertLog extAlertLog, AlertLogDetailPanel alertLogDetailPanel) {
        String string;
        if (extAlertLog.alResourceType >= 0 && (string = CreateOrEditDDI.getObjectTypeName(extAlertLog.alResourceType)) != null) {
            alertLogDetailPanel.addPair(string, extAlertLog.getAlObjectName());
        }
    }

    public void hideColumns(MegaTable megaTable) {
        int[] nArray = new int[3];
        int n = 0;
        this.hiddenColumns = null;
        if (!this.hasObjectTypeColumn) {
            megaTable.setColumnHidden(1, true);
            nArray[n] = 1;
            ++n;
            if (!this.hasObjectNameColumn) {
                megaTable.setColumnHidden(2, true);
                nArray[n] = 2;
                ++n;
            }
        }
        if (n > 0) {
            this.hiddenColumns = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.hiddenColumns[n2] = nArray[n2];
                ++n2;
            }
        }
    }

    public int getNumberColumns() {
        return 9;
    }

    public int[] getRenderers() {
        int[] nArray = new int[9];
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 5;
        return nArray;
    }

    public int[] getHiddenColumns() {
        return this.hiddenColumns;
    }
}

