/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageFreeForm;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class FreeForm {
    public static final int MINIMUM_WIDTH = 100;
    protected static final int DEFAULT_DISPLAY_COLUMNS = 20;
    protected JTextField textField;
    protected ColumnFilter filter;
    protected boolean onDialog;

    protected void createTextField() {
        this.textField = TTextField.newTTextField(20, Short.MAX_VALUE, false);
        Dimension dimension = this.textField.getPreferredSize();
        dimension.width = 100;
        this.textField.setMinimumSize(dimension);
    }

    public abstract void refresh();

    public abstract void getData() throws GeneralException;

    public FreeForm(ColumnFilter columnFilter, boolean bl) {
        this.filter = columnFilter;
        this.onDialog = bl;
        this.createTextField();
    }

    public FreeForm(ColumnFilter columnFilter) {
        this(columnFilter, false);
    }

    public Component getComponent() {
        return this.textField;
    }

    public ColumnFilter getFilter() {
        return this.filter;
    }

    protected void ensureNonEmpty() throws GeneralException {
        String string = this.textField.getText();
        if (Util.isEmpty(string)) {
            string = MessageLog.getMessageNoTS("STG3265E");
            throw new GeneralException(string);
        }
    }

    public MutableLong adjustForRounding(MutableLong mutableLong) {
        short s = this.filter.clfValueList.fvInputUnit;
        if (s > 0) {
            double d = StorageFreeForm.addAmt;
            double d2 = mutableLong.value;
            mutableLong.value = (long)(d2 += d * (double)FreeForm.longFromUnit(s));
        }
        return mutableLong;
    }

    protected static long longFromUnit(short s) {
        long l = 1L;
        return l <<= s * 10;
    }
}

