/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.TStorm.gui.rptfilter;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.ColumnFilterValue;
import org.eclipse.aperi.TStorm.gui.rptfilter.FreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.StorageFreeForm;
import org.eclipse.aperi.TStorm.gui.rptfilter.ValueEditor;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.MutableInteger;
import org.eclipse.aperi.common.MutableLong;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.xmsg.MessageLog;

public class StorageEditor
extends FreeForm
implements ValueEditor {
    private static final String[] UNITS = new String[]{MessageLog.getMessageNoID("STG6063L"), MessageLog.getMessageNoID("STG6064L"), MessageLog.getMessageNoID("STG6065L"), MessageLog.getMessageNoID("STG6066L"), MessageLog.getMessageNoID("STG6067L")};
    private JComboBox combo = new TComboBox(UNITS);
    private Container panel;

    protected void createTextField() {
        this.textField = TTextField.newTTextField("", 20, Short.MAX_VALUE, false, this.onDialog);
    }

    public StorageEditor(ColumnFilter columnFilter, boolean bl) {
        super(columnFilter, bl);
        this.combo.setSelectedIndex(1);
        this.panel = new JPanel();
        this.panel.add(this.textField);
        this.panel.add(this.combo);
        this.refresh();
    }

    public StorageEditor(ColumnFilter columnFilter) {
        this(columnFilter, true);
    }

    public Component getWholeComponent() {
        return this.panel;
    }

    public void setFocus() {
        this.textField.requestFocus();
    }

    public void refresh() {
        ColumnFilterValue columnFilterValue = this.filter.clfValueList;
        MutableLong mutableLong = columnFilterValue == null ? null : (MutableLong)columnFilterValue.fvValue;
        if (mutableLong == null) {
            this.textField.setText("");
        } else {
            String string = StorageFreeForm.format(mutableLong, columnFilterValue.fvInputUnit);
            String string2 = columnFilterValue.fvInputUnit == 0 ? string : string.substring(0, string.length() - 1);
            this.textField.setText(string2);
            this.textField.select(0, string2.length());
            this.combo.setSelectedIndex(columnFilterValue.fvInputUnit);
        }
    }

    public void getData() throws GeneralException {
        this.ensureNonEmpty();
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append(this.textField.getText());
        stringBuffer.append(this.combo.getSelectedItem());
        this.filter.clfValueList = StorageFreeForm.parse(stringBuffer.toString(), new MutableInteger(), false);
    }
}

