/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.common.identifier;

import org.eclipse.aperi.common.identifier.ComponentId;
import org.eclipse.aperi.common.identifier.DeviceId;

public class SubsysControllerId
extends ComponentId {
    private short sContrNum;
    static final long serialVersionUID = -1010612661086789170L;

    public SubsysControllerId(DeviceId deviceId, short s) throws IllegalArgumentException {
        this(deviceId, s, null);
    }

    public SubsysControllerId(DeviceId deviceId, short s, String string) throws IllegalArgumentException {
        super(deviceId, Short.toString(s), string);
        this.setControllerNumber(s);
    }

    public final short getControllerNumber() {
        return this.sContrNum;
    }

    public synchronized void setControllerNumber(short s) {
        this.sContrNum = s;
        super.setInternalName(Short.toString(s));
    }

    public synchronized void setInternalName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The specified internal identifier is invalid (null.)");
        }
        try {
            this.sContrNum = Short.parseShort(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("The specified internal identifier is invalid (" + string + ").  It must represent an integer between 0 and 32,767.");
        }
        super.setInternalName(string);
    }

    public boolean equals(Object object) {
        if (object instanceof SubsysControllerId) {
            return super.equals(object) && this.sContrNum == ((SubsysControllerId)object).sContrNum;
        }
        return false;
    }

    public int compareTo(Object object) {
        int n = super.compareTo(object);
        if (n == 0) {
            n = this.sContrNum - ((SubsysControllerId)object).sContrNum;
        }
        return n == 0 ? 0 : (n < 0 ? -1 : 1);
    }

    public boolean isIdentical(Object object) {
        return object instanceof SubsysControllerId && this.sContrNum == ((SubsysControllerId)object).sContrNum && super.isIdentical(object);
    }

    public int hashCode() {
        String string = this.getDeviceId().getInternalName();
        int n = string.length();
        return (this.sContrNum << 24) + (n < 3 ? 0 : string.charAt(n - 3) << 16) + (n < 2 ? 0 : string.charAt(n - 2) << 8) + (n < 1 ? 0 : (int)string.charAt(n - 1));
    }

    public String toString() {
        return this.getInternalName();
    }
}

