/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.InvalidParameterException;
import org.eclipse.aperi.common.api.MissingParameterException;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.interfaces.CIMExceptionResponse;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.discovery.DiscoveryException;

public final class DiskMessageHelper {
    public static SRMMessage getSRMMessage(String string, Object object, Object object2, LogTraceHelper logTraceHelper) {
        SRMMessage sRMMessage = new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2)});
        logTraceHelper.logMsg(string, sRMMessage.getMsgInserts());
        logTraceHelper.traceHigh(sRMMessage.getMessage());
        return sRMMessage;
    }

    public static SRMMessage getSRMMessage(String string, Object object, Object object2, Object object3, LogTraceHelper logTraceHelper) {
        SRMMessage sRMMessage = new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2), DiskMessageHelper.toMsgString(object3)});
        logTraceHelper.logMsg(string, sRMMessage.getMsgInserts());
        logTraceHelper.traceHigh(sRMMessage.getMessage());
        return sRMMessage;
    }

    public static SRMMessage getSRMMessage(String string, Object object, Object object2, Object object3, Object object4, LogTraceHelper logTraceHelper) {
        SRMMessage sRMMessage = new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2), DiskMessageHelper.toMsgString(object3), DiskMessageHelper.toMsgString(object4)});
        logTraceHelper.logMsg(string, sRMMessage.getMsgInserts());
        logTraceHelper.traceHigh(sRMMessage.getMessage());
        return sRMMessage;
    }

    public static SRMMessage getSRMMessage(String string, Object object, Object object2, Object object3, Object object4, Object object5, LogTraceHelper logTraceHelper) {
        SRMMessage sRMMessage = new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2), DiskMessageHelper.toMsgString(object3), DiskMessageHelper.toMsgString(object4), DiskMessageHelper.toMsgString(object5)});
        logTraceHelper.logMsg(string, sRMMessage.getMsgInserts());
        logTraceHelper.traceHigh(string);
        return sRMMessage;
    }

    public static ServerException getServerException(String string, Object object, LogTraceHelper logTraceHelper) {
        ServerException serverException = new ServerException(new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object)}));
        logTraceHelper.traceError(string, serverException);
        logTraceHelper.logMsg(string, serverException.getSRMMessage().getMsgInserts());
        return serverException;
    }

    public static ServerException getServerException(String string, Object object, Throwable throwable, LogTraceHelper logTraceHelper) {
        ServerException serverException = new ServerException(new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object)}), throwable);
        logTraceHelper.traceError(string, serverException);
        logTraceHelper.logMsg(string, serverException.getSRMMessage().getMsgInserts());
        return serverException;
    }

    public static ServerException getServerException(String string, Object object, Object object2, Throwable throwable, LogTraceHelper logTraceHelper) {
        ServerException serverException = new ServerException(new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2)}), throwable);
        logTraceHelper.traceError(string, serverException);
        logTraceHelper.logMsg(string, serverException.getSRMMessage().getMsgInserts());
        return serverException;
    }

    public static ServerException getServerException(String string, Object object, Object object2, Object object3, Throwable throwable, LogTraceHelper logTraceHelper) {
        ServerException serverException = new ServerException(new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2), DiskMessageHelper.toMsgString(object3)}), throwable);
        logTraceHelper.logMsg(string, serverException.getSRMMessage().getMsgInserts());
        logTraceHelper.traceError(string, serverException);
        return serverException;
    }

    public static MissingParameterException getMissingParameterException(int n, String string, Object object, LogTraceHelper logTraceHelper) {
        MissingParameterException missingParameterException = new MissingParameterException(n, new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object)}));
        logTraceHelper.traceError(string, missingParameterException);
        logTraceHelper.logMsg(string, missingParameterException.getSRMMessage().getMsgInserts());
        return missingParameterException;
    }

    public static InvalidParameterException getInvalidParameterException(int n, String string, Object object, LogTraceHelper logTraceHelper) {
        InvalidParameterException invalidParameterException = new InvalidParameterException(n, new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object)}));
        logTraceHelper.traceError(string, invalidParameterException);
        logTraceHelper.logMsg(string, invalidParameterException.getSRMMessage().getMsgInserts());
        return invalidParameterException;
    }

    public static DiscoveryException getDiscoveryException(String string, String string2, String[] stringArray, JobInfo jobInfo, LogTraceHelper logTraceHelper) {
        Object object;
        Exception exception = null;
        if (jobInfo.getResponse() != null && jobInfo.getResponse() instanceof CIMExceptionResponse && (object = ((CIMExceptionResponse)jobInfo.getResponse()).getData()) instanceof Exception) {
            exception = (Exception)object;
        }
        object = exception != null ? new DiscoveryException(string, string2, stringArray, exception) : new DiscoveryException(string, string2);
        logTraceHelper.traceError("HWN021503E", exception);
        return object;
    }

    public static ServerException getServerException(String string, Object object, Object object2, LogTraceHelper logTraceHelper) {
        ServerException serverException = new ServerException(new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2)}));
        logTraceHelper.logMsg(string, serverException.getSRMMessage().getMsgInserts());
        logTraceHelper.traceError(string, serverException);
        return serverException;
    }

    public static ServerException getServerException(String string, Object object, Object object2, Object object3, LogTraceHelper logTraceHelper) {
        ServerException serverException = new ServerException(new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2), DiskMessageHelper.toMsgString(object3)}));
        logTraceHelper.logMsg(string, serverException.getSRMMessage().getMsgInserts());
        logTraceHelper.traceError(string, serverException);
        return serverException;
    }

    public static ServerException getServerException(String string, Object object, Object object2, Object object3, Object object4, LogTraceHelper logTraceHelper) {
        ServerException serverException = new ServerException(new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2), DiskMessageHelper.toMsgString(object3), DiskMessageHelper.toMsgString(object4)}));
        logTraceHelper.logMsg(string, serverException.getSRMMessage().getMsgInserts());
        logTraceHelper.traceError(string, serverException);
        return serverException;
    }

    public static ServerException getServerException(String string, Object object, Object object2, Object object3, Object object4, Object object5, LogTraceHelper logTraceHelper) {
        ServerException serverException = new ServerException(new SRMMessage(string, new String[]{DiskMessageHelper.toMsgString(object), DiskMessageHelper.toMsgString(object2), DiskMessageHelper.toMsgString(object3), DiskMessageHelper.toMsgString(object4), DiskMessageHelper.toMsgString(object5)}));
        logTraceHelper.logMsg(string, serverException.getSRMMessage().getMsgInserts());
        logTraceHelper.traceError(string, serverException);
        return serverException;
    }

    public static String toMsgString(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass().isArray()) {
            return DiskMessageHelper.handleArray(object);
        }
        if (object instanceof List) {
            return DiskMessageHelper.handleList((List)object);
        }
        if (object instanceof Map) {
            return DiskMessageHelper.handleMap((Map)object);
        }
        if (object instanceof Result) {
            return DiskMessageHelper.handleResult((Result)object);
        }
        return object.toString();
    }

    private static String handleMap(Map map) {
        if (map == null) {
            return "null";
        }
        if (map.size() == 0) {
            return "{}";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (Object k : map.keySet()) {
            stringBuffer.append(DiskMessageHelper.toMsgString(k));
            stringBuffer.append("=");
            stringBuffer.append(DiskMessageHelper.toMsgString(map.get(k)));
            stringBuffer.append(", ");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private static String handleArray(Object object) {
        if (Array.getLength(object) == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < Array.getLength(object)) {
            Object object2 = Array.get(object, n);
            if (object.getClass().isPrimitive()) {
                stringBuffer.append("" + object2);
                stringBuffer.append(", ");
            } else {
                stringBuffer.append(DiskMessageHelper.toMsgString(object2));
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String handleList(List list) {
        if (list.size() == 0) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(DiskMessageHelper.toMsgString(iterator.next()));
            stringBuffer.append(", ");
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static String handleResult(Result result) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n====================================================================");
        stringBuffer.append(result instanceof AsyncResult ? "\nAsyncResult: " : "\nResult: ");
        stringBuffer.append(result.getMessage());
        stringBuffer.append("(");
        stringBuffer.append("RC: ");
        stringBuffer.append(result.getRc());
        if (result instanceof AsyncResult) {
            stringBuffer.append(", Status: ");
            stringBuffer.append(DiskMessageHelper.resolveResultStatus((AsyncResult)result));
            stringBuffer.append(", Job: ");
            stringBuffer.append(((AsyncResult)result).getJobId());
        }
        stringBuffer.append(") ");
        if (result.getResults() != null) {
            stringBuffer.append("\nResults:");
            stringBuffer.append(DiskMessageHelper.toMsgString(result.getResults()));
        }
        if (result instanceof AsyncResult) {
            if (((AsyncResult)result).getSubJobResults() != null) {
                stringBuffer.append("\nSubJob Results:");
                stringBuffer.append(DiskMessageHelper.toMsgString(((AsyncResult)result).getSubJobResults()));
            }
            if (((AsyncResult)result).getReturnException() != null) {
                stringBuffer.append(((AsyncResult)result).getReturnException().toString());
            }
        }
        stringBuffer.append("\n====================================================================");
        return stringBuffer.toString();
    }

    private static String resolveResultStatus(AsyncResult asyncResult) {
        switch (asyncResult.getStatus()) {
            case 5: {
                return "cancelled";
            }
            case 0: {
                return "failed";
            }
            case 4: {
                return "partial failure";
            }
            case 2: {
                return "running";
            }
            case -1: {
                return "submitted";
            }
            case 1: {
                return "successful";
            }
            case -2: {
                return "waiting";
            }
            case 3: {
                return "warning";
            }
        }
        return "unknown (" + asyncResult.getStatus();
    }
}

