/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.disk.common.util.MapableReusable;

public abstract class MapPool {
    private Map cPoolMap = new HashMap();
    private int cUnusedThreshold = 5;
    private List cOutOfPoolInstances = new LinkedList();

    protected MapPool(int n) {
        this.cUnusedThreshold = n;
    }

    protected final synchronized MapableReusable getClearInstance(Object object) {
        List list = (List)this.cPoolMap.get(object);
        if (list == null) {
            return null;
        }
        if (!list.isEmpty()) {
            MapableReusable mapableReusable = (MapableReusable)list.get(list.size() - 1);
            if (mapableReusable == null) {
                return null;
            }
            mapableReusable.clearInstance();
            mapableReusable.setIsInPool(false);
            this.cOutOfPoolInstances.add(mapableReusable);
            return mapableReusable;
        }
        return null;
    }

    protected final synchronized boolean returnInst(MapableReusable mapableReusable) {
        if (mapableReusable == null) {
            throw new IllegalArgumentException("instance must not be null");
        }
        Object object = mapableReusable.getMappingKey();
        this.cOutOfPoolInstances.remove(mapableReusable);
        ArrayList<MapableReusable> arrayList = (ArrayList<MapableReusable>)this.cPoolMap.get(object);
        if (arrayList == null) {
            arrayList = new ArrayList<MapableReusable>(this.cUnusedThreshold + 1);
            this.cPoolMap.put(object, arrayList);
        }
        if (arrayList.size() < this.cUnusedThreshold) {
            mapableReusable.clearInstance();
            mapableReusable.setIsInPool(true);
            arrayList.add(mapableReusable);
            return true;
        }
        return false;
    }

    public final synchronized void clear() {
        Iterator iterator = this.cPoolMap.entrySet().iterator();
        List list = null;
        MapableReusable mapableReusable = null;
        Iterator iterator2 = null;
        while (iterator.hasNext()) {
            list = (List)iterator.next().getValue();
            iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                mapableReusable = (MapableReusable)iterator2.next();
                mapableReusable.releaseInstance();
                iterator2.remove();
            }
            iterator.remove();
        }
        iterator2 = this.cOutOfPoolInstances.iterator();
        while (iterator2.hasNext()) {
            mapableReusable = (MapableReusable)iterator2.next();
            mapableReusable.releaseInstance();
            iterator2.remove();
        }
    }
}

