/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.common.util.thread;

import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.InstancePool;
import org.eclipse.aperi.disk.common.util.thread.DiskMgrThread;
import org.eclipse.aperi.disk.common.util.thread.DiskThreadManager;

public final class DiskThreadPool
extends InstancePool {
    public DiskThreadPool() {
        super(DiskManagerConfigSvc.getIntConfigValue("DiskThread.PoolSize", 50));
    }

    public DiskMgrThread getThread(DiskThreadManager diskThreadManager) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "getThread", new Object[]{diskThreadManager});
        DiskMgrThread diskMgrThread = null;
        try {
            diskMgrThread = (DiskMgrThread)this.getClearInstance();
            if (diskMgrThread != null) {
                logTraceHelper.traceHigh("Returning thread from pool.");
                DiskMgrThread diskMgrThread2 = diskMgrThread;
                return diskMgrThread2;
            }
            diskMgrThread = new DiskMgrThread(diskThreadManager);
            diskMgrThread.start();
            logTraceHelper.traceHigh("Returning new thread.");
            DiskMgrThread diskMgrThread3 = diskMgrThread;
            return diskMgrThread3;
        }
        finally {
            logTraceHelper.exit(diskMgrThread);
        }
    }

    public void returnThread(DiskMgrThread diskMgrThread) {
        LogTraceHelper logTraceHelper = LogTraceHelper.entry(this, "returnThread", new Object[]{diskMgrThread});
        try {
            if (!diskMgrThread.cIsExecutionComplete()) {
                logTraceHelper.traceWarning("Thread execution of " + diskMgrThread.getName() + " is not yet complete. Thread will be taken out of the thread management");
                diskMgrThread.releaseThread();
                diskMgrThread.interrupt();
                this.removeInst(diskMgrThread);
                return;
            }
            if (!this.returnInst(diskMgrThread)) {
                logTraceHelper.traceHigh("Thread " + diskMgrThread.getName() + " returned to pool");
                diskMgrThread.releaseThread();
            }
        }
        finally {
            logTraceHelper.exit("void");
        }
    }
}

