/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import com.tivoli.tec.event_delivery.TECEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.AlertEmailEditor;
import org.eclipse.aperi.gui.EditableList;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IntToString;
import org.eclipse.aperi.gui.ScriptDefinitionDialog;
import org.eclipse.aperi.gui.SizeLimitedDocument;
import org.eclipse.aperi.gui.TComboBox;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.TextUtil;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.server.guireq.AlertEmail;
import org.eclipse.aperi.server.guireq.GComputer;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class AbstractAlertEditor
extends JPanel
implements ActionListener,
GuiRequestor {
    private static final int LOGINID_LENGTH = 32;
    private static final int DEFAULT_LOG_FACILITY = 0;
    private static final int DEFAULT_LOG_LEVEL = 0;
    protected static final int MAX_VALUE_LENGTH = 7;
    protected static final int MAX_PERCENT_LENGTH = 2;
    protected static final int MAX_MB_LENGTH = 6;
    protected static final int MAX_GB_LENGTH = 3;
    protected static final int VERTICAL_INSET = 4;
    protected AlertDefinition alert;
    protected NameList computers;
    private Component alertEditPanel;
    private boolean doDbmsType = false;
    protected JComboBox conditionList;
    protected JComboBox thresholdUnits;
    protected JComboBox dbmsList;
    protected TTextField thresholdValue;
    protected JLabel lConditions;
    protected JLabel lUnits;
    protected JLabel lValue;
    protected JLabel lDbmsType;
    protected SizeLimitedDocument valueDocument;
    protected IntToString[] conditions;
    protected JCheckBox snmpTrap;
    protected JCheckBox tecTrap;
    protected JCheckBox loginNotification;
    protected JLabel lLoginID;
    protected TTextField loginID;
    protected JCheckBox osLog;
    protected JComboBox logLevel;
    protected JComboBox logFacility;
    protected JLabel lLogLevel;
    protected JLabel lLogFacility;
    protected JCheckBox runScript;
    protected JButton scriptSettings;
    protected JCheckBox email;
    protected EditableList emailRecipientList;
    protected JCheckBox emailQuotaViolator;
    protected JRadioButton directoryName;
    protected JRadioButton directoryOwner;
    protected JButton editEmail;
    protected String emailSubject;
    protected String emailText;
    protected IntToString[] emailParms = new IntToString[0];
    private int emailCond = -1;
    private IntToString logError = new IntToString(3, "GUI0230L");
    private IntToString logWarning = new IntToString(2, "GUI0229L");
    protected String changeText;
    protected String defineText;
    private IntToString[] winLogLevels = new IntToString[]{this.logWarning, this.logError};
    private IntToString[] unixLogLevels = new IntToString[]{new IntToString(0, "GUI0227L"), new IntToString(1, "GUI0228L"), this.logWarning, this.logError, new IntToString(4, "GUI0231L"), new IntToString(5, "GUI0232L"), new IntToString(6, "GUI0233L")};
    private IntToString[] unixLogFacilitys = new IntToString[]{new IntToString(8, "GUI0242L"), new IntToString(0, "GUI0234L"), new IntToString(1, "GUI0235L"), new IntToString(2, "GUI0236L"), new IntToString(3, "GUI0237L"), new IntToString(4, "GUI0238L"), new IntToString(5, "GUI0239L"), new IntToString(6, "GUI0240L"), new IntToString(7, "GUI0241L")};

    public AbstractAlertEditor() {
        this.alert = new AlertDefinition();
        this.initAlert();
    }

    public AbstractAlertEditor(boolean bl) {
        this();
        this.doDbmsType = bl;
    }

    public AbstractAlertEditor(AlertDefinition alertDefinition) {
        this.alert = alertDefinition;
    }

    public AbstractAlertEditor(AlertDefinition alertDefinition, boolean bl) {
        this(alertDefinition);
        this.doDbmsType = bl;
    }

    public Component getComponent() {
        if (this.alertEditPanel != null) {
            return this.alertEditPanel;
        }
        this.setLayout(new BoxLayout(this, 1));
        this.add(this.buildConditionPanel());
        this.add(this.buildActionPanel());
        this.add(Box.createVerticalGlue());
        this.setConditionData();
        this.setActionData();
        this.conditionList.addActionListener(this);
        this.thresholdUnits.addActionListener(this);
        this.loginNotification.addActionListener(this);
        this.osLog.addActionListener(this);
        this.runScript.addActionListener(this);
        this.scriptSettings.addActionListener(this);
        this.email.addActionListener(this);
        this.editEmail.addActionListener(this);
        if (this.thresholdUnits.isEnabled()) {
            this.thresholdUnitChange();
        }
        this.alertEditPanel = this;
        return this.alertEditPanel;
    }

    public AlertDefinition getData() {
        if (this.alertEditPanel != null) {
            this.getActionData();
            this.getConditionData();
        }
        return this.alert;
    }

    public void validateData() throws GeneralException {
        if (this.alertEditPanel == null) {
            return;
        }
        this.validateConditionData();
        if (this.alert.aldEmail && !this.haveRecipient()) {
            this.throwException("GUI0246M");
        }
        if (this.alert.aldNotifyOnLogin != null && this.alert.aldNotifyOnLogin.equals("")) {
            this.throwException("GUI0244M");
        }
        if (this.runScript.isSelected() && !this.scriptDefined()) {
            this.throwException("GUI2076E");
        }
        this.validateAlertSpecificActionData();
    }

    protected void throwException(String string) throws GeneralException {
        throw new GeneralException(MessageLog.getMessageNoTS(string, null));
    }

    protected boolean haveRecipient() {
        return !TextUtil.isNull(this.alert.aldEmailDef.aleRecipients);
    }

    protected void validateConditionData() throws GeneralException {
        if (this.thresholdValue.isEnabled() && this.alert.aldThresholdValue == -1) {
            this.throwException("STG4020E");
        }
    }

    protected void validateAlertSpecificActionData() throws GeneralException {
    }

    protected void initAlert() {
        this.alert.aldCreator = GuiUtil.getUserName();
        this.alert.aldEnabled = true;
        this.alert.aldThresholdType = 0;
        this.alert.aldThresholdValue = 0;
        this.alert.aldScriptComputerID = -1;
    }

    protected JPanel buildConditionPanel() {
        String string = MessageLog.getMessageNoID("GUI0205T");
        JPanel jPanel = GuiUtil.getTitledBorderedPanel(string);
        string = MessageLog.getMessageNoID("GUI0206L");
        this.lConditions = new JLabel(string);
        string = MessageLog.getMessageNoID("GUI0207L");
        this.lUnits = new JLabel(string);
        string = MessageLog.getMessageNoID("GUI0208L");
        this.lValue = new JLabel(string);
        this.conditionList = new TComboBox();
        this.conditionList.setPreferredSize(new Dimension(425, 20));
        this.thresholdUnits = new TComboBox();
        this.thresholdUnits.setPreferredSize(new Dimension(190, 20));
        this.thresholdValue = TTextField.newTTextField(9, 7, true);
        this.valueDocument = (SizeLimitedDocument)this.thresholdValue.getDocument();
        GuiUtil.setAccessibleLabel(this.lConditions, this.conditionList, "MNEMONIC_CONDITION", MessageLog.getMessageNoID("GUI0206L"), "DESCRIPTION_CONDITION");
        GuiUtil.setAccessibleLabel(this.lValue, this.thresholdValue, "MNEMONIC_VALUE", MessageLog.getMessageNoID("GUI0207L"), "DESCRIPTION_VALUE");
        GuiUtil.setAccessibleLabel(this.lUnits, this.thresholdUnits, "MNEMONIC_UNITS", MessageLog.getMessageNoID("GUI0208L"), "DESCRIPTION_UNITS");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 16);
        gridBagConstraints.anchor = 17;
        if (this.doDbmsType) {
            this.lDbmsType = new JLabel(MessageLog.getMessageNoID("DBG0578L"));
            this.dbmsList = new TComboBox();
            GuiUtil.setAccessibleLabel(this.lDbmsType, this.dbmsList, "MNEMONIC_TYPE", MessageLog.getMessageNoID("DBG0578L"), MessageLog.getMessageNoID("DBG0578L"));
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)this.lDbmsType, gridBagConstraints);
            jPanel.add((Component)this.dbmsList, gridBagConstraints);
        }
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.lConditions, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.lValue, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.lUnits, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        jPanel.add((Component)this.conditionList, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.thresholdValue, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.thresholdUnits, gridBagConstraints);
        GuiUtil.completePanel(jPanel);
        this.setPanelSize(jPanel);
        return jPanel;
    }

    protected void setPanelSize(JPanel jPanel) {
        int n = (int)jPanel.getMaximumSize().getWidth();
        int n2 = (int)jPanel.getMinimumSize().getHeight();
        jPanel.setMaximumSize(new Dimension(n, n2));
    }

    private boolean scriptDefined() {
        return this.alert.aldScriptComputerID >= 0 && !Util.isEmpty(this.alert.aldScriptName);
    }

    private JPanel buildActionPanel() {
        Insets insets;
        boolean bl;
        String string = MessageLog.getMessageNoID("GUI0209T");
        JPanel jPanel = GuiUtil.getTitledBorderedPanel(string);
        string = MessageLog.getMessageNoID("GUI0210L");
        this.snmpTrap = new JCheckBox(string);
        GuiUtil.setAccessibleDescription(this.snmpTrap, string);
        string = Util.getString("LABEL_TEC_TRAP");
        this.tecTrap = new JCheckBox(string);
        GuiUtil.setAccessibleDescription(this.tecTrap, string);
        string = MessageLog.getMessageNoID("GUI0211L");
        this.loginNotification = new JCheckBox(string);
        GuiUtil.setAccessible(this.loginNotification, string, "DESCRIPTION_LOGINNOTIFICATIONDESCRIPTION_LOGINNOTIFICATION");
        string = MessageLog.getMessageNoID("GUI0212L");
        this.lLoginID = new JLabel(string);
        this.loginID = TTextField.newTTextField(24, 32, false);
        GuiUtil.setAccessibleLabel(this.lLoginID, this.loginID, "MNEMONIC_lOGINID", string, "DESCRIPTION_LOGINID");
        if (Constants.isWindows(GuiClient.serverStatusResp.osType)) {
            bl = true;
            string = MessageLog.getMessageNoID("GUI0213L");
            this.osLog = new JCheckBox(string);
            GuiUtil.setAccessibleDescription(this.osLog, string);
            string = MessageLog.getMessageNoID("GUI0214L");
            this.lLogLevel = new JLabel(string);
            IntToString.resolveNames(this.winLogLevels);
            this.logLevel = new TComboBox(this.winLogLevels);
            GuiUtil.setAccessibleLabel(this.lLogLevel, this.logLevel, "MNEMONIC_EVENTTYPE", string, "DESCRIPTION_EVENTTYPE");
        } else {
            bl = false;
            string = MessageLog.getMessageNoID("GUI0215L");
            this.osLog = new JCheckBox(string);
            string = MessageLog.getMessageNoID("GUI0216L");
            this.lLogLevel = new JLabel(string);
            IntToString.resolveNames(this.unixLogLevels);
            this.logLevel = new TComboBox(this.unixLogLevels);
            GuiUtil.setAccessibleLabel(this.lLogLevel, this.logLevel, "MNEMONIC_EVENTTYPE", string, "DESCRIPTION_EVENTTYPE");
            string = MessageLog.getMessageNoID("GUI0217L");
            this.lLogFacility = new JLabel(string);
            IntToString.resolveNames(this.unixLogFacilitys);
            this.logFacility = new TComboBox(this.unixLogFacilitys);
            GuiUtil.setAccessibleLabel(this.lLogFacility, this.logFacility, "MNEMONIC_EVENTTYPE", string, "DESCRIPTION_EVENTTYPE");
        }
        string = MessageLog.getMessageNoID("GUI2071L");
        this.runScript = new JCheckBox(string);
        GuiUtil.setAccessible(this.runScript, string, string);
        if (this.changeText == null) {
            this.changeText = MessageLog.getMessageNoID("GUI2072L");
            this.defineText = MessageLog.getMessageNoID("GUI2073L");
        }
        string = this.scriptDefined() ? this.changeText : this.defineText;
        this.scriptSettings = new JButton(string);
        GuiUtil.setAccessible(this.scriptSettings, string, string);
        JPanel jPanel2 = this.buildEmailPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets = new Insets(0, 0, 4, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.snmpTrap, gridBagConstraints);
        if (this.realEvdJarInstalled()) {
            jPanel.add((Component)this.tecTrap, gridBagConstraints);
        }
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.loginNotification, gridBagConstraints);
        jPanel.add((Component)this.lLoginID, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.loginID, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.osLog, gridBagConstraints);
        if (!bl) {
            jPanel.add((Component)this.lLogFacility, gridBagConstraints);
            jPanel.add((Component)this.logFacility, gridBagConstraints);
        }
        jPanel.add((Component)this.lLogLevel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.logLevel, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.runScript, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.scriptSettings, gridBagConstraints);
        Component[] componentArray = this.buildAlertSpecificActionControls();
        if (componentArray != null) {
            gridBagConstraints.gridwidth = 1;
            int n = componentArray.length - 1;
            int n2 = 0;
            while (n2 <= n) {
                if (n2 == n) {
                    gridBagConstraints.gridwidth = 0;
                }
                jPanel.add(componentArray[n2], gridBagConstraints);
                ++n2;
            }
        }
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GuiUtil.completePanel(jPanel);
        this.setPanelSize(jPanel);
        return jPanel;
    }

    private JPanel buildEmailPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        String string = MessageLog.getMessageNoID("GUI0220L");
        this.email = new JCheckBox(string);
        GuiUtil.setAccessible(this.email, string, string);
        string = MessageLog.getMessageNoID("GUI0221L");
        this.emailRecipientList = new EditableList(string, null, 5);
        JPanel jPanel2 = this.buildEmailButtonPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        jPanel.add((Component)this.email, gridBagConstraints);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.insets = new Insets(4, 16, 0, 5);
        gridBagConstraints.gridheight = 5;
        jPanel.add((Component)this.emailRecipientList, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 20, 0, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    protected JPanel buildEmailButtonPanel() {
        String string = MessageLog.getMessageNoID("GUI0226L");
        this.editEmail = new JButton(string);
        GuiUtil.setAccessible(this.editEmail, string, string);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.editEmail);
        return jPanel;
    }

    protected Component[] buildAlertSpecificActionControls() {
        return null;
    }

    protected abstract void setConditionData();

    protected void setThresholdValue() {
        if (this.alert.aldThresholdValue != -1) {
            int n = this.alert.aldThresholdValue;
            if (this.alert.aldThresholdType == 4) {
                n /= 1024;
            } else if (this.alert.aldThresholdType == 5) {
                n /= 0x100000;
            }
            this.thresholdValue.setText(String.valueOf(n));
        }
    }

    protected void setActionData() {
        this.snmpTrap.setSelected(this.alert.aldSnmpTrap);
        this.tecTrap.setSelected(this.alert.aldTecEvent);
        this.loginNotification.setSelected(this.alert.aldNotifyOnLogin != null && !this.alert.aldNotifyOnLogin.equals(" "));
        TextUtil.setText(this.loginID, this.alert.aldNotifyOnLogin);
        this.loginNotificationChange();
        this.osLog.setSelected(this.alert.aldOsLog);
        if (this.alert.aldOsLog) {
            this.setComboBoxSelection(this.logLevel, this.alert.aldOsLogSeverity);
            if (this.logFacility != null) {
                this.setComboBoxSelection(this.logFacility, this.alert.aldSyslogFacility);
            }
        }
        this.osLogChange();
        boolean bl = this.scriptDefined();
        this.runScript.setSelected(bl);
        this.scriptSettings.setEnabled(bl);
        this.setAlertSpecificActionData();
        this.setEmailData();
    }

    protected void setAlertSpecificActionData() {
    }

    protected void setEmailData() {
        this.email.setSelected(this.alert.aldEmail);
        if (this.alert.aldEmail && this.alert.aldEmailDef != null) {
            this.emailRecipientList.removeAllObjects();
            ArrayList arrayList = this.alert.aldEmailDef.parseRecipients();
            int n = 0;
            while (n < arrayList.size()) {
                String string = (String)arrayList.get(n);
                this.emailRecipientList.addObject(string);
                ++n;
            }
            this.emailSubject = this.alert.aldEmailDef.aleSubject;
            this.emailText = this.alert.aldEmailDef.aleText;
            this.emailCond = this.alert.aldCondition;
        }
        this.emailChange();
    }

    protected void getConditionData() {
        IntToString intToString = (IntToString)this.conditionList.getSelectedItem();
        this.alert.aldCondition = (short)intToString.value;
        intToString = (IntToString)this.thresholdUnits.getSelectedItem();
        this.alert.aldThresholdType = intToString == null ? (byte)0 : (byte)intToString.value;
        String string = this.thresholdValue.getText();
        if (TextUtil.isNull(string)) {
            this.alert.aldThresholdValue = -1;
        } else {
            this.alert.aldThresholdValue = Integer.parseInt(string);
            if (this.alert.aldThresholdType == 4) {
                this.alert.aldThresholdValue *= 1024;
            } else if (this.alert.aldThresholdType == 5) {
                this.alert.aldThresholdValue *= 0x100000;
            }
        }
    }

    protected void getActionData() {
        this.alert.aldSnmpTrap = this.snmpTrap.isSelected();
        this.alert.aldTecEvent = this.tecTrap.isSelected();
        this.alert.aldNotifyOnLogin = this.loginNotification.isSelected() ? TextUtil.getTrimmedText(this.loginID) : null;
        this.alert.aldOsLog = this.osLog.isSelected();
        if (this.alert.aldOsLog) {
            IntToString intToString = (IntToString)this.logLevel.getSelectedItem();
            this.alert.aldOsLogSeverity = (byte)intToString.value;
            if (this.logFacility != null) {
                intToString = (IntToString)this.logFacility.getSelectedItem();
                this.alert.aldSyslogFacility = (byte)intToString.value;
            }
        }
        this.getAlertSpecificActionData();
        this.getEmailData();
    }

    protected void getAlertSpecificActionData() {
    }

    protected void getEmailData() {
        this.alert.aldEmail = this.email.isSelected();
        if (this.alert.aldEmail) {
            if (this.alert.aldEmailDef == null) {
                this.alert.aldEmailDef = new AlertEmail();
            }
            Object[] objectArray = this.emailRecipientList.getElements();
            this.alert.aldEmailDef.setRecipients(objectArray);
            this.alert.aldEmailDef.aleSubject = this.emailSubject;
            this.alert.aldEmailDef.aleText = this.emailText;
        } else {
            this.alert.aldEmailDef = null;
        }
    }

    protected Dialog makeScriptDialog() {
        return new ScriptDefinitionDialog(this.alert, this.computers);
    }

    private void showDialog() {
        this.getConditionData();
        if (Util.isEmpty(this.alert.aldScriptName)) {
            this.alert.aldScriptName = "";
        }
        Dialog dialog = this.makeScriptDialog();
        dialog.show();
        if (this.scriptDefined()) {
            this.scriptSettings.setText(this.changeText);
        }
    }

    private void submitRequest() {
        Request request = new Request();
        ServerRequest.guiInfo(request, 2, -2);
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            return;
        }
        TreeMap<String, NameList> treeMap = new TreeMap<String, NameList>();
        NameList nameList = this.computers = (NameList)response.responseData;
        while (nameList != null) {
            GComputer gComputer = GuiUtil.getComputer(nameList.nlID);
            nameList.nlName = gComputer.gcTSName;
            treeMap.put(nameList.nlName, nameList);
            nameList = nameList.nlNext;
        }
        Iterator iterator = treeMap.values().iterator();
        this.computers = null;
        NameList nameList2 = null;
        while (iterator.hasNext()) {
            nameList = (NameList)iterator.next();
            nameList.nlNext = null;
            if (nameList2 != null) {
                nameList2.nlNext = nameList;
            } else {
                this.computers = nameList;
            }
            nameList2 = nameList;
        }
        treeMap = null;
        iterator = null;
        this.showDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.loginNotification) {
            this.loginNotificationChange();
        } else if (object == this.osLog) {
            this.osLogChange();
        } else if (object == this.runScript) {
            boolean bl = this.runScript.isSelected();
            this.scriptSettings.setEnabled(bl);
            if (!bl) {
                this.alert.aldScriptComputerID = -1;
                this.scriptSettings.setText(this.defineText);
            }
        } else if (object == this.scriptSettings) {
            if (this.computers != null) {
                this.showDialog();
            } else {
                this.submitRequest();
            }
        } else if (object == this.email) {
            this.emailChange();
        } else if (object == this.editEmail) {
            this.updateEmail();
        } else if (object == this.dbmsList) {
            this.dbmsChange();
        } else if (object == this.conditionList) {
            this.conditionChange();
            IntToString intToString = (IntToString)this.conditionList.getSelectedItem();
            int n = intToString.value;
            if (n != this.emailCond) {
                if (n == this.alert.aldCondition) {
                    this.setEmailData();
                } else {
                    this.emailSubject = null;
                    this.emailText = null;
                    this.emailCond = n;
                }
            }
        } else if (object == this.thresholdUnits) {
            this.thresholdUnitChange();
        }
    }

    private void loginNotificationChange() {
        boolean bl = this.loginNotification.isSelected();
        this.lLoginID.setEnabled(bl);
        this.loginID.setEnabled(bl);
        if (!bl) {
            this.loginID.setText(null);
        }
    }

    private void osLogChange() {
        boolean bl = this.osLog.isSelected();
        this.lLogLevel.setEnabled(bl);
        this.logLevel.setEnabled(bl);
        if (!bl) {
            this.logLevel.setSelectedIndex(0);
        }
        if (this.lLogFacility != null) {
            this.lLogFacility.setEnabled(bl);
            this.logFacility.setEnabled(bl);
            if (!bl) {
                this.logFacility.setSelectedIndex(0);
            }
        }
    }

    protected void emailChange() {
        boolean bl = this.email.isSelected();
        this.editEmail.setEnabled(bl);
        this.emailRecipientList.setEnabled(bl);
    }

    protected void dbmsChange() {
        IntToString intToString = (IntToString)this.dbmsList.getSelectedItem();
        if (intToString == null) {
            return;
        }
        this.alert.aldDbmsType = (byte)intToString.value;
        this.conditionList.removeActionListener(this);
        this.setConditionData();
        this.conditionList.addActionListener(this);
    }

    protected void conditionChange() {
    }

    protected void thresholdUnitChange() {
        IntToString intToString = (IntToString)this.thresholdUnits.getSelectedItem();
        if (intToString == null) {
            return;
        }
        int n = intToString.value;
        switch (n) {
            case 1: {
                this.valueDocument.setMaxSize(7);
                break;
            }
            case 2: {
                this.valueDocument.setMaxSize(2);
                break;
            }
            case 3: {
                this.valueDocument.setMaxSize(7);
                break;
            }
            case 4: {
                this.valueDocument.setMaxSize(6);
                break;
            }
            case 5: {
                this.valueDocument.setMaxSize(3);
            }
        }
    }

    protected void updateEmail() {
        short s = this.alert.aldCondition;
        IntToString intToString = (IntToString)this.conditionList.getSelectedItem();
        this.alert.aldCondition = (short)intToString.value;
        AlertEmailEditor alertEmailEditor = new AlertEmailEditor();
        alertEmailEditor.edit(this.emailSubject, this.emailText, this.alert);
        this.emailSubject = alertEmailEditor.subject;
        this.emailText = alertEmailEditor.text;
        alertEmailEditor = null;
        this.alert.aldCondition = s;
    }

    protected void initComboBox(JComboBox jComboBox, IntToString[] intToStringArray, int n) {
        IntToString.resolveNames(intToStringArray);
        this.setComboBoxChoices(jComboBox, intToStringArray, n);
    }

    protected void setComboBoxChoices(JComboBox jComboBox, IntToString[] intToStringArray, int n) {
        jComboBox.removeAllItems();
        int n2 = 0;
        while (n2 < intToStringArray.length) {
            jComboBox.addItem(intToStringArray[n2]);
            ++n2;
        }
        this.setComboBoxSelection(jComboBox, n);
    }

    protected void setComboBoxSelection(JComboBox jComboBox, int n) {
        int n2 = jComboBox.getItemCount() - 1;
        while (n2 >= 0) {
            IntToString intToString = (IntToString)jComboBox.getItemAt(n2);
            if (intToString.value == n) {
                jComboBox.setSelectedIndex(n2);
                break;
            }
            --n2;
        }
    }

    protected void setConditions(IntToString[] intToStringArray) {
        this.conditions = intToStringArray;
    }

    protected void setValueEnabled(boolean bl) {
        this.thresholdValue.setEnabled(bl);
        this.lValue.setEnabled(bl);
    }

    protected void setUnitEnabled(boolean bl) {
        this.thresholdUnits.setEnabled(bl);
        this.lUnits.setEnabled(bl);
        if (!bl) {
            this.thresholdUnits.removeAllItems();
        }
    }

    public AlertHeader getAlertHeader() {
        return null;
    }

    private boolean realEvdJarInstalled() {
        boolean bl = false;
        Method[] methodArray = new TECEvent().getClass().getMethods();
        int n = 0;
        while (n < methodArray.length) {
            if (methodArray[n].getName().equals("normalizeEvEnd")) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }
}

