/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.ObjectChangeListener;

public class ChangeManager {
    private static Map<Integer, List<ObjectChangeListener>> listenerListMap = new HashMap<Integer, List<ObjectChangeListener>>();

    public static void removeListener(ObjectChangeListener objectChangeListener) {
        for (List<ObjectChangeListener> list : listenerListMap.values()) {
            Iterator<ObjectChangeListener> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next() != objectChangeListener) continue;
                iterator.remove();
            }
        }
    }

    public static void addListener(ObjectChangeListener objectChangeListener, short s) {
        List<ObjectChangeListener> list = listenerListMap.get(s);
        if (list == null) {
            list = new LinkedList<ObjectChangeListener>();
            listenerListMap.put(Integer.valueOf(s), list);
        }
        list.add(objectChangeListener);
    }

    public static void signalChange(int n, NameList nameList) {
        List<ObjectChangeListener> list = listenerListMap.get(nameList.nlInfo);
        if (list != null) {
            for (ObjectChangeListener objectChangeListener : list) {
                objectChangeListener.changeOccurred(n, nameList);
            }
        }
    }
}

