/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.net.Socket;
import javax.swing.SwingUtilities;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiGotResponse;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.SocketTransceiver;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiSendRequest
extends Thread {
    private Request request;
    private GuiClient.RequestNode node;
    private static int timeout = 30;

    static {
        try {
            String string = System.getProperty("gui.timeout");
            if (string != null) {
                timeout = Integer.parseInt(string);
            }
        }
        catch (Throwable throwable) {}
    }

    public GuiSendRequest(Request request, GuiClient.RequestNode requestNode) {
        this.request = request;
        this.node = requestNode;
    }

    public void run() {
        int n = 12;
        String string = null;
        Response response = null;
        if (response == null) {
            try {
                Socket socket = new Socket(GuiClient.server, GuiClient.port);
                SocketTransceiver socketTransceiver = new SocketTransceiver(socket, GuiClient.server, timeout * 60);
                response = socketTransceiver.transmitRequest(this.request, null);
                socketTransceiver.close();
                if (response == null) {
                    n = 12;
                    string = MessageLog.getMessage("GUI0022M", null);
                } else {
                    n = response.status;
                    string = response.getErrorMessage();
                    if (response.responseData instanceof NameList[]) {
                        response.responseData = NameList.unpackList((NameList[])response.responseData);
                    }
                }
            }
            catch (Exception exception) {
                n = 12;
                string = MessageLog.getMessage("GUI0023M", null);
            }
        }
        SwingUtilities.invokeLater(new GuiGotResponse((short)n, response, string, this.node));
    }
}

