/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.eclipse.aperi.gui.GuiMain;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.IconFactory;
import org.eclipse.aperi.xmsg.MessageLog;

public class HelpMessage
extends JDialog
implements HyperlinkListener,
ActionListener {
    private String title = MessageLog.getMessageNoID("GUI0071T");
    private static HelpMessage pHelpMessage;
    private JToolBar toolBar = new JToolBar();
    private JButton backButton = new JButton();
    private JButton nextButton = new JButton();
    private static final int MAX_URL = 50;
    private URL[] urlChain = new URL[50];
    private int currentURL = -1;
    private int lastURL = 0;
    private JScrollPane scrollPane = new JScrollPane();
    private JEditorPane editorPane = new JEditorPane();
    private int helpType = -1;
    public static final int TREE_HELP = 0;
    public static final int PANEL_HELP = 1;

    private HelpMessage() {
        super((Frame)GuiMain.pGuiMain, false);
        this.backButton.setToolTipText("   " + MessageLog.getMessageNoID("GUI0007L", null) + "   ");
        this.backButton.setIcon(IconFactory.getBackIcon());
        this.backButton.setRolloverIcon(IconFactory.getRolloverBackIcon());
        this.backButton.setVerticalTextPosition(3);
        this.backButton.setHorizontalTextPosition(0);
        this.backButton.setMargin(new Insets(2, 2, 2, 2));
        this.backButton.setFocusPainted(false);
        this.backButton.addActionListener(this);
        this.toolBar.add(this.backButton);
        this.nextButton.setToolTipText(MessageLog.getMessageNoID("GUI0008L", null));
        this.nextButton.setIcon(IconFactory.getNextIcon());
        this.nextButton.setRolloverIcon(IconFactory.getRolloverNextIcon());
        this.nextButton.setVerticalTextPosition(3);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setMargin(new Insets(2, 2, 2, 2));
        this.nextButton.setFocusPainted(false);
        this.nextButton.addActionListener(this);
        this.toolBar.add(this.nextButton);
        this.editorPane.setEditable(false);
        this.editorPane.addHyperlinkListener(this);
        this.scrollPane.getViewport().add(this.editorPane);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                pHelpMessage.dispose();
                pHelpMessage = null;
            }
        });
    }

    private void setDialogSize(int n) {
        if (n > this.helpType) {
            this.helpType = n;
            if (n == 0) {
                this.setSize(420, 400);
                GuiUtil.centerDialog(this);
            } else {
                this.setBounds(0, 0, 600, 600);
            }
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.addURL(hyperlinkEvent.getURL());
            if (!this.showMsg(hyperlinkEvent.getDescription())) {
                --this.currentURL;
            }
            this.lastURL = this.currentURL;
            this.setButtons();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.backButton) {
            --this.currentURL;
            if (this.showMsg(null)) {
                this.backButton.getModel().setRollover(this.currentURL > 0);
            } else {
                ++this.currentURL;
            }
        } else {
            ++this.currentURL;
            if (this.showMsg(null)) {
                this.nextButton.getModel().setRollover(this.currentURL < this.lastURL);
            } else {
                --this.currentURL;
            }
        }
        this.backButton.setEnabled(this.currentURL > 0);
        this.nextButton.setEnabled(this.currentURL < this.lastURL);
    }

    public static void showMsg(String string, int n) {
        if (pHelpMessage == null) {
            pHelpMessage = new HelpMessage();
        }
        pHelpMessage.newMessage(string, n);
    }

    private void newMessage(String string, int n) {
        this.addURL(HelpMessage.class.getResource("help/" + string + ".html"));
        if (!this.showMsg(string)) {
            --this.currentURL;
        }
        if (this.currentURL < 0) {
            pHelpMessage = null;
            this.dispose();
            return;
        }
        this.setDialogSize(n);
        this.show();
        this.lastURL = this.currentURL;
        this.setButtons();
    }

    private boolean showMsg(String string) {
        URL uRL = this.urlChain[this.currentURL];
        if (uRL == null) {
            JOptionPane.showMessageDialog(this, String.valueOf(MessageLog.getMessageNoID("GUI0069T")) + "   " + string, this.title, 0);
            return false;
        }
        try {
            this.editorPane.setPage(uRL);
            String string2 = uRL.getFile();
            int n = string2.length() - 12;
            String string3 = string2.substring(n, n + 7);
            this.setTitle(String.valueOf(this.title) + string3);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, String.valueOf(MessageLog.getMessageNoID("GUI0070T")) + "\n     " + iOException.getMessage(), this.title, 0);
            return false;
        }
        return true;
    }

    private void addURL(URL uRL) {
        if (this.currentURL == 49) {
            int n = 25;
            int n2 = 0;
            while (n2 < n) {
                this.urlChain[n2] = this.urlChain[n + n2];
                ++n2;
            }
            this.currentURL = n - 1;
        }
        this.urlChain[++this.currentURL] = uRL;
    }

    private void setButtons() {
        this.backButton.setEnabled(this.currentURL > 0);
        this.nextButton.setEnabled(this.currentURL < this.lastURL);
        this.backButton.getModel().setRollover(false);
        this.nextButton.getModel().setRollover(false);
        this.backButton.setRolloverEnabled(true);
        this.nextButton.setRolloverEnabled(true);
    }
}

