/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.DefaultTableCellRenderer;
import org.eclipse.aperi.agent.req.AgtStatusResp;
import org.eclipse.aperi.gui.BaseTableModel;
import org.eclipse.aperi.gui.BaseTreeNode;
import org.eclipse.aperi.gui.GuiClient;
import org.eclipse.aperi.gui.GuiRequestor;
import org.eclipse.aperi.gui.LogViewer;
import org.eclipse.aperi.gui.TJCTableMouseInterface;
import org.eclipse.aperi.gui.TableCellRenderers;
import org.eclipse.aperi.gui.admin.AgentDDI;
import org.eclipse.aperi.gui.admin.AgentTreeNode;
import org.eclipse.aperi.gui.admin.JobDetail;
import org.eclipse.aperi.gui.tables.MegaTable;
import org.eclipse.aperi.jobs.JobRun;
import org.eclipse.aperi.jobs.StartedJob;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.req.ServerRequest;
import org.eclipse.aperi.xmsg.MessageLog;

public class JobTable
extends MegaTable
implements GuiRequestor,
ActionListener,
TJCTableMouseInterface {
    private static final String SCHEDULE = MessageLog.getMessageNoID("ADG0215L");
    private static final String JOB = MessageLog.getMessageNoID("ADG0216L");
    private static final String RUN = MessageLog.getMessageNoID("ADG0217L");
    private static final String STATUS = MessageLog.getMessageNoID("ADG0218L");
    private static final String SCHEDULED = MessageLog.getMessageNoID("ADG0220L");
    private static final String STARTED = MessageLog.getMessageNoID("ADG0221L");
    private static final String INIT = MessageLog.getMessageNoID("ADG0234T");
    private static final String WAITING = MessageLog.getMessageNoID("ADG0235T");
    private static final String EXECUTING = MessageLog.getMessageNoID("ADG0236T");
    private static final String COMPLETED = MessageLog.getMessageNoID("ADG0237T");
    private static final Byte INIT_BYTE = new Byte(73);
    private static final Byte WAIT_BYTE = new Byte(87);
    private static final Byte EXEC_BYTE = new Byte(69);
    private static final Byte COMP_BYTE = new Byte(67);
    private static final int SCHEDULE_COL = 0;
    private static final int JOB_COL = 1;
    private static final int RUN_COL = 2;
    private static final int STATUS_COL = 3;
    private static final int SCHEDULED_COL = 4;
    private static final int STARTED_COL = 5;
    private static final Color DARKGREEN = new Color(0, 75, 0);
    private static final Color DARKBLUE = new Color(0, 0, 175);
    private static final String[] colNames = new String[]{SCHEDULE, JOB, RUN, STATUS, SCHEDULED, STARTED};
    private JobTableModel jtm = null;
    protected StartedJob[] jobs = new StartedJob[0];
    private AgentTreeNode node = null;
    private AgtStatusResp asr = null;
    private int popupJob;
    private static final String LOG = "ADG0017L";

    public JobTable(AgentTreeNode agentTreeNode) {
        this.node = agentTreeNode;
        Request request = new Request();
        ServerRequest.agentJobs(request, agentTreeNode.computerID);
        this.popupJob = -1;
        GuiClient.doRequest(this, request);
    }

    public void handleResponse(short s, Response response) {
        if (s > 4) {
            this.asr = null;
        } else {
            this.asr = (AgtStatusResp)response.responseData;
            if (!this.asr.jobs.isEmpty()) {
                this.jobs = this.asr.jobs.toArray(this.jobs);
            }
        }
        this.jtm = new JobTableModel();
        this.setCellRenderer(Byte.class, new StatusRenderer());
        this.setCellRenderer(Date.class, TableCellRenderers.date);
        this.setRowIcon(10, true);
        this.setMouseListener(this);
        this.setBaseTableModel(this.jtm);
    }

    public boolean select(int n, int n2) {
        return false;
    }

    public void doubleClick(int n, int n2) {
        AgentDDI agentDDI = new AgentDDI();
        agentDDI.panel = new JobDetail(this.jobs[n], this.node);
        agentDDI.setDescription(String.valueOf(MessageLog.getMessageNoID("ADG0216L")) + "   " + this.jobs[n].getJobRun().getJobName());
        agentDDI.treeNode = this.node;
        agentDDI.runNumber = this.jobs[n].getRunNumber();
        agentDDI.show();
    }

    public void showPopup(int n, int n2, Component component, int n3, int n4) {
        this.popupJob = n;
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem(MessageLog.getMessageNoID(LOG));
        jMenuItem.setToolTipText(MessageLog.getMessageNoID("ADG0259T"));
        jMenuItem.setActionCommand(LOG);
        jMenuItem.addActionListener(this);
        byte by = this.jobs[this.popupJob].getJobStatus();
        if (by == 69 || by == 67) {
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(component, n3, n4);
        jPopupMenu.requestFocus();
    }

    public void selectionChanged(boolean bl) {
    }

    public void showDefaultChart(int n) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == LOG) {
            new LogViewer(this.node.computerID, (BaseTreeNode)this.node, this.jobs[this.popupJob].getLogFileName());
        }
    }

    private class JobTableModel
    extends BaseTableModel {
        JobTableModel() {
            this.columnNames = colNames;
            this.rowCount = JobTable.this.jobs.length;
        }

        public Object getTableDataItem(int n, int n2) {
            JobRun jobRun = JobTable.this.jobs[n].getJobRun();
            switch (n2) {
                case 0: {
                    return String.valueOf(jobRun.getSchedCreator()) + "." + jobRun.getSchedName();
                }
                case 1: {
                    return jobRun.getJobName();
                }
                case 2: {
                    return Integer.toString(JobTable.this.jobs[n].getRunNumber());
                }
                case 3: {
                    return new Byte(JobTable.this.jobs[n].getJobStatus());
                }
                case 4: {
                    return new Date(jobRun.getDesiredStartTime());
                }
                case 5: {
                    return new Date(JobTable.this.jobs[n].getStarted());
                }
            }
            return null;
        }
    }

    public class StatusRenderer
    extends DefaultTableCellRenderer {
        public void setValue(Object object) {
            if (object == null) {
                this.setText("");
            } else if (INIT_BYTE.compareTo((Byte)object) == 0) {
                this.setForeground(DARKBLUE);
                this.setText(INIT);
            } else if (WAIT_BYTE.compareTo((Byte)object) == 0) {
                this.setForeground(Color.black);
                this.setText(WAITING);
            } else if (EXEC_BYTE.compareTo((Byte)object) == 0) {
                this.setForeground(DARKGREEN);
                this.setText(EXECUTING);
            } else if (COMP_BYTE.compareTo((Byte)object) == 0) {
                this.setForeground(Color.red);
                this.setText(COMPLETED);
            } else {
                this.setText("");
            }
        }
    }
}

