/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.gui.admin;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.eclipse.aperi.TStorm.gui.PrimitiveConditionEditor;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.gui.BaseTree;
import org.eclipse.aperi.gui.GuiUtil;
import org.eclipse.aperi.gui.TTextField;
import org.eclipse.aperi.gui.admin.ConfigSettingsDDI;
import org.eclipse.aperi.gui.admin.ConfigSettingsPanel;
import org.eclipse.aperi.gui.admin.SnmpSettingsPanel;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.xmsg.MessageLog;

public class NetworkSettingsPanel
extends ConfigSettingsPanel
implements ComponentListener {
    private static final int TEC_SERVER_FIELD = 0;
    private static final int TEC_PORT_FIELD = 1;
    private static final int SMTP_SERVER_FIELD = 2;
    private static final int SMTP_PORT_FIELD = 3;
    private static final int DEFAULT_DOMAIN_FIELD = 4;
    private static final int REPLY_TO_FIELD = 5;
    private static final int RETURN_TO_FIELD = 6;
    private static final int SRM_ADMIN_FIELD = 7;
    private static final int DEL_AFTER_DAYS = 8;
    private static final int N_FIELDS = 9;
    private static final String[] validationMsgs;
    private JTextField[] fieldArray;
    private JTextField smtpServer;
    private JTextField smtpPort;
    private JTextField smtpDefaultDomain;
    private JTextField smtpReplyTo;
    private JTextField smtpReturnTo;
    private JTextField smtpSrmAdmin;
    private JTextField delafterdays;
    private ConfigSettingsDDI ddi;
    private boolean setFocus;
    private ConfigSettings settings;
    private JTextField tecServer;
    private JTextField tecPort;
    private SnmpSettingsPanel[] snmpArray;

    static {
        String[] stringArray = new String[9];
        stringArray[0] = "GUI2093E";
        stringArray[2] = "GUI2061E";
        stringArray[4] = "GUI2062E";
        stringArray[5] = "GUI2063E";
        stringArray[6] = "GUI2064E";
        stringArray[8] = "GUI6005E";
        validationMsgs = stringArray;
    }

    public NetworkSettingsPanel(ConfigSettingsDDI configSettingsDDI) {
        this.ddi = configSettingsDDI;
        this.setFocus = false;
    }

    public JComponent getComponent(ConfigSettings configSettings) {
        this.settings = configSettings != null ? configSettings : this.makeDefaultSettings();
        this.smtpServer = TTextField.newTTextField(this.settings.csSmtp.ssServer, 20, 128, false);
        this.tecServer = TTextField.newTTextField(this.settings.csTecServer, 20, 128, false);
        String string = Integer.toString(this.settings.csTecPort);
        this.tecPort = TTextField.newTTextField(string, 5, true);
        string = Integer.toString(this.settings.csSmtp.ssPort);
        this.smtpPort = TTextField.newTTextField(string, 5, true);
        this.smtpDefaultDomain = TTextField.newTTextField(this.settings.csSmtp.ssDfltDomain, 20, 128, false);
        this.smtpReplyTo = TTextField.newTTextField(this.settings.csSmtp.ssReplyTo, 20, 128, false);
        this.smtpReturnTo = TTextField.newTTextField(this.settings.csSmtp.ssReturn, 20, 128, false);
        string = this.settings.csSmtp.getSrmAdminString();
        this.smtpSrmAdmin = TTextField.newTTextField(string, 20, 255, false);
        string = String.valueOf(this.settings.csDellogDays);
        this.delafterdays = TTextField.newTTextField(string, 3, 5, true);
        this.fieldArray = new JTextField[9];
        this.fieldArray[0] = this.tecServer;
        this.fieldArray[1] = this.tecPort;
        this.fieldArray[2] = this.smtpServer;
        this.fieldArray[3] = this.smtpPort;
        this.fieldArray[4] = this.smtpDefaultDomain;
        this.fieldArray[5] = this.smtpReplyTo;
        this.fieldArray[6] = this.smtpReturnTo;
        this.fieldArray[7] = this.smtpSrmAdmin;
        this.fieldArray[8] = this.delafterdays;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 3;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.insets.right = 6;
        gridBagConstraints.insets.bottom = 3;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(GuiUtil.getBorder("SNMP"));
        Color color = jPanel2.getBackground();
        this.snmpArray = new SnmpSettingsPanel[this.settings.csSnmp.length];
        int n = 0;
        while (n < this.snmpArray.length) {
            Component component;
            if (n > 0) {
                component = new PrimitiveConditionEditor.HorizontalSeparator(color);
                gridBagConstraints.insets.right = 10;
                jPanel2.add(component, gridBagConstraints);
                gridBagConstraints.insets.right = 6;
            }
            component = new SnmpSettingsPanel(this.settings.csSnmp[n], n);
            this.snmpArray[n] = component;
            jPanel2.add(component, gridBagConstraints);
            ++n;
        }
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        string = "TEC";
        jPanel2.setBorder(GuiUtil.getBorder(string));
        string = MessageLog.getMessageNoID("GUI2090L");
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(BaseTree.boldFont);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2091L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.tecServer, "MNEMONIC_TECSERVER", string, "DESCRIPTION_TECSERVER");
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.left = 0;
        jPanel2.add((Component)this.tecServer, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2092L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.tecPort, "MNEMONIC_TECPORT", string, "DESCRIPTION_TECPORT");
        gridBagConstraints.insets.left = 40;
        gridBagConstraints.insets.bottom = 7;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        jPanel2.add((Component)this.tecPort, gridBagConstraints);
        string = Util.getString("LABEL_DEFAULT_TEC_PORT");
        jLabel = new JLabel(string);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets.top = 4;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.insets.right = 6;
        gridBagConstraints.insets.bottom = 2;
        jPanel2 = new JPanel(new GridBagLayout());
        string = MessageLog.getMessageNoID("GUI0220L");
        jPanel2.setBorder(GuiUtil.getBorder(string));
        string = MessageLog.getMessageNoID("GUI2057L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.smtpServer, "MNEMONIC_SMPTSERVER", string, "DESCRIPTION_SMPTSERVER");
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.smtpServer, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2088L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.smtpPort, "MNEMONIC_SMPTPORT", string, "DESCRIPTION_SMPTPORT");
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        jPanel2.add((Component)this.smtpPort, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        string = MessageLog.getMessageNoID("GUI2089L");
        jLabel = new JLabel(string);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        string = MessageLog.getMessageNoID("GUI2056L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.smtpDefaultDomain, "MNEMONIC_SMPTDEFAULTDOMAIN", string, "DESCRIPTION_SMPTDEFAULTDOMAIN");
        string = MessageLog.getMessageNoID("GUI2053T");
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.smtpDefaultDomain.setToolTipText(string);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.smtpDefaultDomain, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2055L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.smtpReturnTo, "MNEMONIC_SMPTRETURNTO", string, "DESCRIPTION_SMPTRETURNTO");
        string = MessageLog.getMessageNoID("GUI2058T");
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.smtpReturnTo.setToolTipText(string);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.smtpReturnTo, gridBagConstraints);
        string = MessageLog.getMessageNoID("GUI2054L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.smtpReplyTo, "MNEMONIC_SMPTREPLYTO", string, "DESCRIPTION_SMPTREPLYTO");
        string = MessageLog.getMessageNoID("GUI2059T");
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.gridwidth = 1;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.smtpReplyTo.setToolTipText(string);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.smtpReplyTo, gridBagConstraints);
        string = Util.getString("LABEL_DATA_ADMIN_COLON");
        jLabel = new JLabel(string);
        string = Util.getString("DESC_SRM_ADMIN");
        GuiUtil.setAccessibleLabel(jLabel, this.smtpSrmAdmin, "", string, string);
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.bottom = 7;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.smtpSrmAdmin.setToolTipText(string);
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel2.add((Component)this.smtpSrmAdmin, gridBagConstraints);
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.insets.right = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel2 = new JPanel(new GridBagLayout());
        string = MessageLog.getMessageNoID("GUI6002L");
        jPanel2.setBorder(GuiUtil.getBorder(string));
        string = MessageLog.getMessageNoID("GUI6003L");
        jLabel = new JLabel(string);
        GuiUtil.setAccessibleLabel(jLabel, this.delafterdays, "MNEMONIC_ALERTLOG", string, "DESCRIPTION_ALERTLOG");
        gridBagConstraints.insets.left = 4;
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.insets.left = 0;
        jPanel2.add((Component)this.delafterdays, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        string = MessageLog.getMessageNoID("GUI6004L");
        jLabel = new JLabel(string);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 2;
        gridBagConstraints.insets.left = 6;
        gridBagConstraints.insets.right = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.insets.left = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 0;
        jPanel.add(Box.createVerticalStrut(1), gridBagConstraints);
        return jPanel;
    }

    public ConfigSettings getData() {
        int n = 0;
        while (n < this.snmpArray.length) {
            this.settings.csSnmp[n] = this.snmpArray[n].getData();
            ++n;
        }
        this.settings.csTecServer = this.tecServer.getText();
        String string = this.tecPort.getText();
        this.settings.csTecPort = string.length() > 0 ? Integer.parseInt(string) : 5524;
        this.settings.csSmtp.ssServer = this.smtpServer.getText();
        string = this.smtpPort.getText();
        this.settings.csSmtp.ssPort = string.length() > 0 ? Integer.parseInt(string) : 25;
        this.settings.csSmtp.ssReplyTo = this.smtpReplyTo.getText();
        this.settings.csSmtp.ssReturn = this.smtpReturnTo.getText();
        this.settings.csSmtp.ssDfltDomain = this.smtpDefaultDomain.getText();
        this.settings.csSmtp.setSrmAdmin(this.smtpSrmAdmin.getText());
        string = this.delafterdays.getText();
        if (string.length() > 0) {
            this.settings.csDellogDays = Integer.parseInt(string);
        }
        return this.settings;
    }

    public void validate(ConfigSettings configSettings) throws GeneralException {
        String string;
        int n = 0;
        while (n < validationMsgs.length) {
            JTextField jTextField;
            if (validationMsgs[n] != null && (string = (jTextField = this.fieldArray[n]).getText()).length() == 0) {
                this.ddi.badField = n;
                string = MessageLog.getMessageNoTS(validationMsgs[n], null);
                throw new GeneralException(string);
            }
            ++n;
        }
        n = 0;
        int n2 = 0;
        while (n2 < this.snmpArray.length) {
            this.ddi.badField = 9 + n2;
            if (this.snmpArray[n2].validateData()) {
                n = 1;
            }
            ++n2;
        }
        if (n == 0) {
            this.ddi.badField = 9;
            string = MessageLog.getMessageNoTS("GUI0271E", null);
            throw new GeneralException(string);
        }
    }

    public void selectField(boolean bl) {
        if (bl) {
            if (this.ddi.badField >= 9) {
                int n = this.ddi.badField - 9;
                this.snmpArray[n].requestFocus();
            } else {
                this.fieldArray[this.ddi.badField].requestFocus();
            }
        } else {
            this.setFocus = true;
        }
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (!this.setFocus || this.ddi.badField >= 9) {
            return;
        }
        int n = this.ddi.badField;
        Component component = componentEvent.getComponent();
        if (component == this.fieldArray[n]) {
            this.setFocus = false;
            component.requestFocus();
        }
    }
}

